# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAwsCurConfigResult',
    'AwaitableGetAwsCurConfigResult',
    'get_aws_cur_config',
    'get_aws_cur_config_output',
]

@pulumi.output_type
class GetAwsCurConfigResult:
    """
    A collection of values returned by getAwsCurConfig.
    """
    def __init__(__self__, account_filters=None, account_id=None, bucket_name=None, bucket_region=None, cloud_account_id=None, created_at=None, error_messages=None, id=None, report_name=None, report_prefix=None, status=None, status_updated_at=None, updated_at=None):
        if account_filters and not isinstance(account_filters, dict):
            raise TypeError("Expected argument 'account_filters' to be a dict")
        pulumi.set(__self__, "account_filters", account_filters)
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_region and not isinstance(bucket_region, str):
            raise TypeError("Expected argument 'bucket_region' to be a str")
        pulumi.set(__self__, "bucket_region", bucket_region)
        if cloud_account_id and not isinstance(cloud_account_id, int):
            raise TypeError("Expected argument 'cloud_account_id' to be a int")
        pulumi.set(__self__, "cloud_account_id", cloud_account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if error_messages and not isinstance(error_messages, list):
            raise TypeError("Expected argument 'error_messages' to be a list")
        pulumi.set(__self__, "error_messages", error_messages)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if report_name and not isinstance(report_name, str):
            raise TypeError("Expected argument 'report_name' to be a str")
        pulumi.set(__self__, "report_name", report_name)
        if report_prefix and not isinstance(report_prefix, str):
            raise TypeError("Expected argument 'report_prefix' to be a str")
        pulumi.set(__self__, "report_prefix", report_prefix)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_updated_at and not isinstance(status_updated_at, str):
            raise TypeError("Expected argument 'status_updated_at' to be a str")
        pulumi.set(__self__, "status_updated_at", status_updated_at)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountFilters")
    def account_filters(self) -> Optional['outputs.GetAwsCurConfigAccountFiltersResult']:
        return pulumi.get(self, "account_filters")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The AWS account ID associated with this CUR configuration.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The S3 bucket name where Cost and Usage Report files are stored.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> _builtins.str:
        """
        The AWS region where the S3 bucket is located.
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter(name="cloudAccountId")
    def cloud_account_id(self) -> _builtins.int:
        """
        The Datadog cloud account ID for the AWS CUR configuration you want to retrieve information about.
        """
        return pulumi.get(self, "cloud_account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The timestamp when the CUR configuration was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Sequence[_builtins.str]:
        """
        List of error messages if the CUR configuration encountered any issues.
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> _builtins.str:
        """
        The name of the AWS Cost and Usage Report.
        """
        return pulumi.get(self, "report_name")

    @_builtins.property
    @pulumi.getter(name="reportPrefix")
    def report_prefix(self) -> _builtins.str:
        """
        The S3 key prefix where CUR files are stored within the bucket.
        """
        return pulumi.get(self, "report_prefix")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the CUR configuration (e.g., active, archived).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> _builtins.str:
        """
        The timestamp when the CUR configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The timestamp when the CUR configuration was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetAwsCurConfigResult(GetAwsCurConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsCurConfigResult(
            account_filters=self.account_filters,
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            bucket_region=self.bucket_region,
            cloud_account_id=self.cloud_account_id,
            created_at=self.created_at,
            error_messages=self.error_messages,
            id=self.id,
            report_name=self.report_name,
            report_prefix=self.report_prefix,
            status=self.status,
            status_updated_at=self.status_updated_at,
            updated_at=self.updated_at)


def get_aws_cur_config(account_filters: Optional[Union['GetAwsCurConfigAccountFiltersArgs', 'GetAwsCurConfigAccountFiltersArgsDict']] = None,
                       cloud_account_id: Optional[_builtins.int] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsCurConfigResult:
    """
    Use this data source to retrieve information about a specific Datadog AWS CUR (Cost and Usage Report) configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for AWS billing data access.


    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the AWS CUR configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['accountFilters'] = account_filters
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getAwsCurConfig:getAwsCurConfig', __args__, opts=opts, typ=GetAwsCurConfigResult).value

    return AwaitableGetAwsCurConfigResult(
        account_filters=pulumi.get(__ret__, 'account_filters'),
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        bucket_region=pulumi.get(__ret__, 'bucket_region'),
        cloud_account_id=pulumi.get(__ret__, 'cloud_account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        id=pulumi.get(__ret__, 'id'),
        report_name=pulumi.get(__ret__, 'report_name'),
        report_prefix=pulumi.get(__ret__, 'report_prefix'),
        status=pulumi.get(__ret__, 'status'),
        status_updated_at=pulumi.get(__ret__, 'status_updated_at'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_aws_cur_config_output(account_filters: Optional[pulumi.Input[Optional[Union['GetAwsCurConfigAccountFiltersArgs', 'GetAwsCurConfigAccountFiltersArgsDict']]]] = None,
                              cloud_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsCurConfigResult]:
    """
    Use this data source to retrieve information about a specific Datadog AWS CUR (Cost and Usage Report) configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for AWS billing data access.


    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the AWS CUR configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['accountFilters'] = account_filters
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getAwsCurConfig:getAwsCurConfig', __args__, opts=opts, typ=GetAwsCurConfigResult)
    return __ret__.apply(lambda __response__: GetAwsCurConfigResult(
        account_filters=pulumi.get(__response__, 'account_filters'),
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        bucket_region=pulumi.get(__response__, 'bucket_region'),
        cloud_account_id=pulumi.get(__response__, 'cloud_account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        error_messages=pulumi.get(__response__, 'error_messages'),
        id=pulumi.get(__response__, 'id'),
        report_name=pulumi.get(__response__, 'report_name'),
        report_prefix=pulumi.get(__response__, 'report_prefix'),
        status=pulumi.get(__response__, 'status'),
        status_updated_at=pulumi.get(__response__, 'status_updated_at'),
        updated_at=pulumi.get(__response__, 'updated_at')))
