# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceLevelObjectivesResult',
    'AwaitableGetServiceLevelObjectivesResult',
    'get_service_level_objectives',
    'get_service_level_objectives_output',
]

@pulumi.output_type
class GetServiceLevelObjectivesResult:
    """
    A collection of values returned by getServiceLevelObjectives.
    """
    def __init__(__self__, error_on_empty_result=None, id=None, ids=None, metrics_query=None, name_query=None, query=None, slos=None, tags_query=None):
        if error_on_empty_result and not isinstance(error_on_empty_result, bool):
            raise TypeError("Expected argument 'error_on_empty_result' to be a bool")
        pulumi.set(__self__, "error_on_empty_result", error_on_empty_result)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if metrics_query and not isinstance(metrics_query, str):
            raise TypeError("Expected argument 'metrics_query' to be a str")
        pulumi.set(__self__, "metrics_query", metrics_query)
        if name_query and not isinstance(name_query, str):
            raise TypeError("Expected argument 'name_query' to be a str")
        pulumi.set(__self__, "name_query", name_query)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if slos and not isinstance(slos, list):
            raise TypeError("Expected argument 'slos' to be a list")
        pulumi.set(__self__, "slos", slos)
        if tags_query and not isinstance(tags_query, str):
            raise TypeError("Expected argument 'tags_query' to be a str")
        pulumi.set(__self__, "tags_query", tags_query)

    @_builtins.property
    @pulumi.getter(name="errorOnEmptyResult")
    def error_on_empty_result(self) -> Optional[_builtins.bool]:
        """
        Throw an error if no results are found. Defaults to `true`.
        """
        return pulumi.get(self, "error_on_empty_result")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of SLO IDs to limit the search.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="metricsQuery")
    def metrics_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on SLO numerator and denominator.
        """
        return pulumi.get(self, "metrics_query")

    @_builtins.property
    @pulumi.getter(name="nameQuery")
    def name_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on SLO names.
        """
        return pulumi.get(self, "name_query")

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[_builtins.str]:
        """
        The query string to filter results based on SLO names. Some examples of queries include service:\\n\\n and \\n\\n.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def slos(self) -> Sequence['outputs.GetServiceLevelObjectivesSloResult']:
        """
        List of SLOs
        """
        return pulumi.get(self, "slos")

    @_builtins.property
    @pulumi.getter(name="tagsQuery")
    def tags_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on a single SLO tag.
        """
        return pulumi.get(self, "tags_query")


class AwaitableGetServiceLevelObjectivesResult(GetServiceLevelObjectivesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceLevelObjectivesResult(
            error_on_empty_result=self.error_on_empty_result,
            id=self.id,
            ids=self.ids,
            metrics_query=self.metrics_query,
            name_query=self.name_query,
            query=self.query,
            slos=self.slos,
            tags_query=self.tags_query)


def get_service_level_objectives(error_on_empty_result: Optional[_builtins.bool] = None,
                                 ids: Optional[Sequence[_builtins.str]] = None,
                                 metrics_query: Optional[_builtins.str] = None,
                                 name_query: Optional[_builtins.str] = None,
                                 query: Optional[_builtins.str] = None,
                                 tags_query: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceLevelObjectivesResult:
    """
    Use this data source to retrieve information about multiple SLOs for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    ft_foo_slos = datadog.get_service_level_objectives(tags_query="owner:ft-foo")
    ```


    :param _builtins.bool error_on_empty_result: Throw an error if no results are found. Defaults to `true`.
    :param Sequence[_builtins.str] ids: An array of SLO IDs to limit the search.
    :param _builtins.str metrics_query: Filter results based on SLO numerator and denominator.
    :param _builtins.str name_query: Filter results based on SLO names.
    :param _builtins.str query: The query string to filter results based on SLO names. Some examples of queries include service:\\n\\n and \\n\\n.
    :param _builtins.str tags_query: Filter results based on a single SLO tag.
    """
    __args__ = dict()
    __args__['errorOnEmptyResult'] = error_on_empty_result
    __args__['ids'] = ids
    __args__['metricsQuery'] = metrics_query
    __args__['nameQuery'] = name_query
    __args__['query'] = query
    __args__['tagsQuery'] = tags_query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getServiceLevelObjectives:getServiceLevelObjectives', __args__, opts=opts, typ=GetServiceLevelObjectivesResult).value

    return AwaitableGetServiceLevelObjectivesResult(
        error_on_empty_result=pulumi.get(__ret__, 'error_on_empty_result'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        metrics_query=pulumi.get(__ret__, 'metrics_query'),
        name_query=pulumi.get(__ret__, 'name_query'),
        query=pulumi.get(__ret__, 'query'),
        slos=pulumi.get(__ret__, 'slos'),
        tags_query=pulumi.get(__ret__, 'tags_query'))
def get_service_level_objectives_output(error_on_empty_result: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                        metrics_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        name_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        tags_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceLevelObjectivesResult]:
    """
    Use this data source to retrieve information about multiple SLOs for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    ft_foo_slos = datadog.get_service_level_objectives(tags_query="owner:ft-foo")
    ```


    :param _builtins.bool error_on_empty_result: Throw an error if no results are found. Defaults to `true`.
    :param Sequence[_builtins.str] ids: An array of SLO IDs to limit the search.
    :param _builtins.str metrics_query: Filter results based on SLO numerator and denominator.
    :param _builtins.str name_query: Filter results based on SLO names.
    :param _builtins.str query: The query string to filter results based on SLO names. Some examples of queries include service:\\n\\n and \\n\\n.
    :param _builtins.str tags_query: Filter results based on a single SLO tag.
    """
    __args__ = dict()
    __args__['errorOnEmptyResult'] = error_on_empty_result
    __args__['ids'] = ids
    __args__['metricsQuery'] = metrics_query
    __args__['nameQuery'] = name_query
    __args__['query'] = query
    __args__['tagsQuery'] = tags_query
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getServiceLevelObjectives:getServiceLevelObjectives', __args__, opts=opts, typ=GetServiceLevelObjectivesResult)
    return __ret__.apply(lambda __response__: GetServiceLevelObjectivesResult(
        error_on_empty_result=pulumi.get(__response__, 'error_on_empty_result'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        metrics_query=pulumi.get(__response__, 'metrics_query'),
        name_query=pulumi.get(__response__, 'name_query'),
        query=pulumi.get(__response__, 'query'),
        slos=pulumi.get(__response__, 'slos'),
        tags_query=pulumi.get(__response__, 'tags_query')))
