# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IncidentNotificationTemplateArgs', 'IncidentNotificationTemplate']

@pulumi.input_type
class IncidentNotificationTemplateArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 content: pulumi.Input[_builtins.str],
                 incident_type: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 subject: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IncidentNotificationTemplate resource.
        :param pulumi.Input[_builtins.str] category: The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        :param pulumi.Input[_builtins.str] content: The content body of the notification template.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification template is associated with.
        :param pulumi.Input[_builtins.str] name: The name of the notification template.
        :param pulumi.Input[_builtins.str] subject: The subject line of the notification template.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "incident_type", incident_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The content body of the notification template.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the incident type this notification template is associated with.
        """
        return pulumi.get(self, "incident_type")

    @incident_type.setter
    def incident_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "incident_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the notification template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Input[_builtins.str]:
        """
        The subject line of the notification template.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subject", value)


@pulumi.input_type
class _IncidentNotificationTemplateState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IncidentNotificationTemplate resources.
        :param pulumi.Input[_builtins.str] category: The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        :param pulumi.Input[_builtins.str] content: The content body of the notification template.
        :param pulumi.Input[_builtins.str] created: Timestamp when the notification template was created.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification template is associated with.
        :param pulumi.Input[_builtins.str] modified: Timestamp when the notification template was last modified.
        :param pulumi.Input[_builtins.str] name: The name of the notification template.
        :param pulumi.Input[_builtins.str] subject: The subject line of the notification template.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if incident_type is not None:
            pulumi.set(__self__, "incident_type", incident_type)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content body of the notification template.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the notification template was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the incident type this notification template is associated with.
        """
        return pulumi.get(self, "incident_type")

    @incident_type.setter
    def incident_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "incident_type", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the notification template was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the notification template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subject line of the notification template.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)


@pulumi.type_token("datadog:index/incidentNotificationTemplate:IncidentNotificationTemplate")
class IncidentNotificationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog incident notification template resource. This can be used to create and manage Datadog incident notification templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Reference incident type
        security = datadog.IncidentType("security",
            name="Security Incident",
            description="Security-related incidents requiring immediate attention")
        # Create a notification template for incident alerts
        security_incident = datadog.IncidentNotificationTemplate("security_incident",
            name="Security Incident Template",
            subject="SEV-1 Security Incident: {{incident.title}}",
            content=\"\"\"🚨 SECURITY INCIDENT DECLARED 🚨

        **Incident Details:**
        - Title: {{incident.title}}
        - Severity: {{incident.severity}}
        - Status: {{incident.status}}
        - Declared at: {{incident.created}}

        **Affected Services:**
        {{#each incident.services}}
        - {{name}}
        {{/each}}

        **Commander:** {{incident.commander}}

        **Next Steps:**
        1. Join the incident Slack channel: #incident-{{incident.id}}
        2. Review the incident details in Datadog
        3. Await further instructions from the incident commander

        For more information: {{incident.url}}
        \"\"\",
            category="alert",
            incident_type=security.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        Import an existing incident notification template

        ```sh
        $ pulumi import datadog:index/incidentNotificationTemplate:IncidentNotificationTemplate security_incident 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        :param pulumi.Input[_builtins.str] content: The content body of the notification template.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification template is associated with.
        :param pulumi.Input[_builtins.str] name: The name of the notification template.
        :param pulumi.Input[_builtins.str] subject: The subject line of the notification template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IncidentNotificationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog incident notification template resource. This can be used to create and manage Datadog incident notification templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Reference incident type
        security = datadog.IncidentType("security",
            name="Security Incident",
            description="Security-related incidents requiring immediate attention")
        # Create a notification template for incident alerts
        security_incident = datadog.IncidentNotificationTemplate("security_incident",
            name="Security Incident Template",
            subject="SEV-1 Security Incident: {{incident.title}}",
            content=\"\"\"🚨 SECURITY INCIDENT DECLARED 🚨

        **Incident Details:**
        - Title: {{incident.title}}
        - Severity: {{incident.severity}}
        - Status: {{incident.status}}
        - Declared at: {{incident.created}}

        **Affected Services:**
        {{#each incident.services}}
        - {{name}}
        {{/each}}

        **Commander:** {{incident.commander}}

        **Next Steps:**
        1. Join the incident Slack channel: #incident-{{incident.id}}
        2. Review the incident details in Datadog
        3. Await further instructions from the incident commander

        For more information: {{incident.url}}
        \"\"\",
            category="alert",
            incident_type=security.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        Import an existing incident notification template

        ```sh
        $ pulumi import datadog:index/incidentNotificationTemplate:IncidentNotificationTemplate security_incident 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param IncidentNotificationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IncidentNotificationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IncidentNotificationTemplateArgs.__new__(IncidentNotificationTemplateArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if incident_type is None and not opts.urn:
                raise TypeError("Missing required property 'incident_type'")
            __props__.__dict__["incident_type"] = incident_type
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if subject is None and not opts.urn:
                raise TypeError("Missing required property 'subject'")
            __props__.__dict__["subject"] = subject
            __props__.__dict__["created"] = None
            __props__.__dict__["modified"] = None
        super(IncidentNotificationTemplate, __self__).__init__(
            'datadog:index/incidentNotificationTemplate:IncidentNotificationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            incident_type: Optional[pulumi.Input[_builtins.str]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None) -> 'IncidentNotificationTemplate':
        """
        Get an existing IncidentNotificationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        :param pulumi.Input[_builtins.str] content: The content body of the notification template.
        :param pulumi.Input[_builtins.str] created: Timestamp when the notification template was created.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification template is associated with.
        :param pulumi.Input[_builtins.str] modified: Timestamp when the notification template was last modified.
        :param pulumi.Input[_builtins.str] name: The name of the notification template.
        :param pulumi.Input[_builtins.str] subject: The subject line of the notification template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IncidentNotificationTemplateState.__new__(_IncidentNotificationTemplateState)

        __props__.__dict__["category"] = category
        __props__.__dict__["content"] = content
        __props__.__dict__["created"] = created
        __props__.__dict__["incident_type"] = incident_type
        __props__.__dict__["modified"] = modified
        __props__.__dict__["name"] = name
        __props__.__dict__["subject"] = subject
        return IncidentNotificationTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the notification template. Valid values are `alert`, `incident`, `recovery`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The content body of the notification template.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the notification template was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the incident type this notification template is associated with.
        """
        return pulumi.get(self, "incident_type")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the notification template was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the notification template.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        The subject line of the notification template.
        """
        return pulumi.get(self, "subject")

