# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogsMetricArgs', 'LogsMetric']

@pulumi.input_type
class LogsMetricArgs:
    def __init__(__self__, *,
                 compute: pulumi.Input['LogsMetricComputeArgs'],
                 filter: pulumi.Input['LogsMetricFilterArgs'],
                 name: pulumi.Input[_builtins.str],
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]] = None):
        """
        The set of arguments for constructing a LogsMetric resource.
        :param pulumi.Input['LogsMetricComputeArgs'] compute: The compute rule to compute the log-based metric. This field can't be updated after creation.
        :param pulumi.Input['LogsMetricFilterArgs'] filter: The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        :param pulumi.Input[_builtins.str] name: The name of the log-based metric. This field can't be updated after creation.
        :param pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]] group_bies: The rules for the group by.
        """
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> pulumi.Input['LogsMetricComputeArgs']:
        """
        The compute rule to compute the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: pulumi.Input['LogsMetricComputeArgs']):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input['LogsMetricFilterArgs']:
        """
        The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input['LogsMetricFilterArgs']):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]]:
        """
        The rules for the group by.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]]):
        pulumi.set(self, "group_bies", value)


@pulumi.input_type
class _LogsMetricState:
    def __init__(__self__, *,
                 compute: Optional[pulumi.Input['LogsMetricComputeArgs']] = None,
                 filter: Optional[pulumi.Input['LogsMetricFilterArgs']] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogsMetric resources.
        :param pulumi.Input['LogsMetricComputeArgs'] compute: The compute rule to compute the log-based metric. This field can't be updated after creation.
        :param pulumi.Input['LogsMetricFilterArgs'] filter: The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        :param pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]] group_bies: The rules for the group by.
        :param pulumi.Input[_builtins.str] name: The name of the log-based metric. This field can't be updated after creation.
        """
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['LogsMetricComputeArgs']]:
        """
        The compute rule to compute the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['LogsMetricComputeArgs']]):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['LogsMetricFilterArgs']]:
        """
        The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['LogsMetricFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]]:
        """
        The rules for the group by.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsMetricGroupByArgs']]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/logsMetric:LogsMetric")
class LogsMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute: Optional[pulumi.Input[Union['LogsMetricComputeArgs', 'LogsMetricComputeArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['LogsMetricFilterArgs', 'LogsMetricFilterArgsDict']]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsMetricGroupByArgs', 'LogsMetricGroupByArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for interacting with the logs_metric API

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        testing_logs_metric = datadog.LogsMetric("testing_logs_metric",
            name="testing.logs.metric",
            compute={
                "aggregation_type": "distribution",
                "path": "@duration",
            },
            filter={
                "query": "service:test",
            },
            group_bies=[
                {
                    "path": "@status",
                    "tag_name": "status",
                },
                {
                    "path": "@version",
                    "tag_name": "version",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/logsMetric:LogsMetric testing_logs_metric testing.logs.metric
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LogsMetricComputeArgs', 'LogsMetricComputeArgsDict']] compute: The compute rule to compute the log-based metric. This field can't be updated after creation.
        :param pulumi.Input[Union['LogsMetricFilterArgs', 'LogsMetricFilterArgsDict']] filter: The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogsMetricGroupByArgs', 'LogsMetricGroupByArgsDict']]]] group_bies: The rules for the group by.
        :param pulumi.Input[_builtins.str] name: The name of the log-based metric. This field can't be updated after creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for interacting with the logs_metric API

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        testing_logs_metric = datadog.LogsMetric("testing_logs_metric",
            name="testing.logs.metric",
            compute={
                "aggregation_type": "distribution",
                "path": "@duration",
            },
            filter={
                "query": "service:test",
            },
            group_bies=[
                {
                    "path": "@status",
                    "tag_name": "status",
                },
                {
                    "path": "@version",
                    "tag_name": "version",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/logsMetric:LogsMetric testing_logs_metric testing.logs.metric
        ```

        :param str resource_name: The name of the resource.
        :param LogsMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute: Optional[pulumi.Input[Union['LogsMetricComputeArgs', 'LogsMetricComputeArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['LogsMetricFilterArgs', 'LogsMetricFilterArgsDict']]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsMetricGroupByArgs', 'LogsMetricGroupByArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsMetricArgs.__new__(LogsMetricArgs)

            if compute is None and not opts.urn:
                raise TypeError("Missing required property 'compute'")
            __props__.__dict__["compute"] = compute
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            __props__.__dict__["group_bies"] = group_bies
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(LogsMetric, __self__).__init__(
            'datadog:index/logsMetric:LogsMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute: Optional[pulumi.Input[Union['LogsMetricComputeArgs', 'LogsMetricComputeArgsDict']]] = None,
            filter: Optional[pulumi.Input[Union['LogsMetricFilterArgs', 'LogsMetricFilterArgsDict']]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsMetricGroupByArgs', 'LogsMetricGroupByArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogsMetric':
        """
        Get an existing LogsMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LogsMetricComputeArgs', 'LogsMetricComputeArgsDict']] compute: The compute rule to compute the log-based metric. This field can't be updated after creation.
        :param pulumi.Input[Union['LogsMetricFilterArgs', 'LogsMetricFilterArgsDict']] filter: The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogsMetricGroupByArgs', 'LogsMetricGroupByArgsDict']]]] group_bies: The rules for the group by.
        :param pulumi.Input[_builtins.str] name: The name of the log-based metric. This field can't be updated after creation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsMetricState.__new__(_LogsMetricState)

        __props__.__dict__["compute"] = compute
        __props__.__dict__["filter"] = filter
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["name"] = name
        return LogsMetric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> pulumi.Output['outputs.LogsMetricCompute']:
        """
        The compute rule to compute the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "compute")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output['outputs.LogsMetricFilter']:
        """
        The log-based metric filter. Logs matching this filter will be aggregated in this metric.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Optional[Sequence['outputs.LogsMetricGroupBy']]]:
        """
        The rules for the group by.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

