# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnCallTeamRoutingRulesArgs', 'OnCallTeamRoutingRules']

@pulumi.input_type
class OnCallTeamRoutingRulesArgs:
    def __init__(__self__, *,
                 team_id: pulumi.Input[_builtins.str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]] = None):
        """
        The set of arguments for constructing a OnCallTeamRoutingRules resource.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to associate the routing rules with.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]] rules: List of team routing rules.
        """
        pulumi.set(__self__, "team_id", team_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the team to associate the routing rules with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]]:
        """
        List of team routing rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _OnCallTeamRoutingRulesState:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OnCallTeamRoutingRules resources.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]] rules: List of team routing rules.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to associate the routing rules with.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]]:
        """
        List of team routing rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallTeamRoutingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the team to associate the routing rules with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.type_token("datadog:index/onCallTeamRoutingRules:OnCallTeamRoutingRules")
class OnCallTeamRoutingRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallTeamRoutingRulesRuleArgs', 'OnCallTeamRoutingRulesRuleArgsDict']]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog On-Call team routing rules resource.

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing on_call_team_routing_rules

        ```sh
        $ pulumi import datadog:index/onCallTeamRoutingRules:OnCallTeamRoutingRules test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallTeamRoutingRulesRuleArgs', 'OnCallTeamRoutingRulesRuleArgsDict']]]] rules: List of team routing rules.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to associate the routing rules with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnCallTeamRoutingRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog On-Call team routing rules resource.

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing on_call_team_routing_rules

        ```sh
        $ pulumi import datadog:index/onCallTeamRoutingRules:OnCallTeamRoutingRules test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param OnCallTeamRoutingRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnCallTeamRoutingRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallTeamRoutingRulesRuleArgs', 'OnCallTeamRoutingRulesRuleArgsDict']]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnCallTeamRoutingRulesArgs.__new__(OnCallTeamRoutingRulesArgs)

            __props__.__dict__["rules"] = rules
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
        super(OnCallTeamRoutingRules, __self__).__init__(
            'datadog:index/onCallTeamRoutingRules:OnCallTeamRoutingRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallTeamRoutingRulesRuleArgs', 'OnCallTeamRoutingRulesRuleArgsDict']]]]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OnCallTeamRoutingRules':
        """
        Get an existing OnCallTeamRoutingRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallTeamRoutingRulesRuleArgs', 'OnCallTeamRoutingRulesRuleArgsDict']]]] rules: List of team routing rules.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to associate the routing rules with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnCallTeamRoutingRulesState.__new__(_OnCallTeamRoutingRulesState)

        __props__.__dict__["rules"] = rules
        __props__.__dict__["team_id"] = team_id
        return OnCallTeamRoutingRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.OnCallTeamRoutingRulesRule']]]:
        """
        List of team routing rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the team to associate the routing rules with.
        """
        return pulumi.get(self, "team_id")

