# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SoftwareCatalogArgs', 'SoftwareCatalog']

@pulumi.input_type
class SoftwareCatalogArgs:
    def __init__(__self__, *,
                 entity: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SoftwareCatalog resource.
        :param pulumi.Input[_builtins.str] entity: The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        pulumi.set(__self__, "entity", entity)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> pulumi.Input[_builtins.str]:
        """
        The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity", value)


@pulumi.input_type
class _SoftwareCatalogState:
    def __init__(__self__, *,
                 entity: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SoftwareCatalog resources.
        :param pulumi.Input[_builtins.str] entity: The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity", value)


@pulumi.type_token("datadog:index/softwareCatalog:SoftwareCatalog")
class SoftwareCatalog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Software Catalog Entity resource. This can be used to create and manage entities in Datadog Software Catalog using the YAML/JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # v3 service entity 
        service_v3 = datadog.SoftwareCatalog("service_v3", entity=\"\"\"apiVersion: v3
        kind: service
        metadata:
          name: shopping-cart
          displayName: Shopping Cart
          inheritFrom: service:otherService
          tags:
            - tag:value
          links:
            - name: shopping-cart runbook
              type: runbook
              url: https://runbook/shopping-cart
            - name: shopping-cart architecture
              provider: gdoc
              url: https://google.drive/shopping-cart-architecture
              type: doc
            - name: shopping-cart Wiki
              provider: wiki
              url: https://wiki/shopping-cart
              type: doc
            - name: shopping-cart source code
              provider: github
              url: http://github/shopping-cart
              type: repo
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/shopping-cart:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: web
          languages:
            - go
            - python
          dependsOn:
            - service:serviceA
            - service:serviceB
        datadog:
          performanceData:
            tags:
              - 'service:shopping-cart'
              - 'hostname:shopping-cart'
          events:
            - name: "deployment events"
              query: "app:myapp AND type:github"
            - name: "event type B"
              query: "app:myapp AND type:github"
          logs:
            - name: "critical logs"
              query: "app:myapp AND type:github"
            - name: "ops logs"
              query: "app:myapp AND type:github"
          pipelines:
            fingerprints:
              - fp1
              - fp2
          codeLocations:
            - repositoryURL: http://github/shopping-cart.git
              paths:
                - baz/*.c
                - bat/**/*
                - ../plop/*.java
            - repositoryURL: http://github/shopping-cart-2.git
              paths:
                - baz/*.c
                - bat/**/*
                - ../plop/*.java
        \"\"\")
        # v3 datastore entity 
        datastore_v3 = datadog.SoftwareCatalog("datastore_v3", entity=\"\"\"apiVersion: v3
        kind: datastore
        metadata:
          name: shopping-cart-db
          tags:
            - tag:value
          links:
            - name: shopping-cart-db runbook
              type: runbook
              url: https://runbook/shopping-cart
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/shopping-cart-db:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: "postgres"
        datadog:
          performanceData:
            tags: ['tag:random']
        \"\"\")
        # v3 queue entity 
        queue_v3 = datadog.SoftwareCatalog("queue_v3", entity=\"\"\"apiVersion: v3
        kind: queue
        metadata:
          name: order-queue
          tags:
            - tag:value
          links:
            - name: order-queue runbook
              type: runbook
              url: https://runbook/order-queue
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/order-queue:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: kafka
        datadog:
          performanceData:
            tags: ['tag:random']
        \"\"\")
        # v3 system entity 
        system_v3 = datadog.SoftwareCatalog("system_v3", entity=\"\"\"apiVersion: v3
        kind: system
        metadata:
          name: shopping-system
          displayName: Shopping System
          tags:
            - tag:value
          links:
            - name: shopping-system runbook
              type: runbook
              url: https://runbook/shopping-system
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        spec:
          components:
            - service:shopping-cart
            - queue:order-queue
            - database:shopping-cart-db
        extensions:
          datadoghq.com/shopping-system:
            customField: customValue
        datadog:
          events:
            - name: "deployment events"
              query: "app:myapp AND type:github"
            - name: "event type B"
              query: "app:myapp AND type:github"
          logs:
            - name: "critical logs"
              query: "app:myapp AND type:github"
            - name: "ops logs"
              query: "app:myapp AND type:github"
        \"\"\")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/softwareCatalog:SoftwareCatalog this <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity: The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwareCatalogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Software Catalog Entity resource. This can be used to create and manage entities in Datadog Software Catalog using the YAML/JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # v3 service entity 
        service_v3 = datadog.SoftwareCatalog("service_v3", entity=\"\"\"apiVersion: v3
        kind: service
        metadata:
          name: shopping-cart
          displayName: Shopping Cart
          inheritFrom: service:otherService
          tags:
            - tag:value
          links:
            - name: shopping-cart runbook
              type: runbook
              url: https://runbook/shopping-cart
            - name: shopping-cart architecture
              provider: gdoc
              url: https://google.drive/shopping-cart-architecture
              type: doc
            - name: shopping-cart Wiki
              provider: wiki
              url: https://wiki/shopping-cart
              type: doc
            - name: shopping-cart source code
              provider: github
              url: http://github/shopping-cart
              type: repo
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/shopping-cart:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: web
          languages:
            - go
            - python
          dependsOn:
            - service:serviceA
            - service:serviceB
        datadog:
          performanceData:
            tags:
              - 'service:shopping-cart'
              - 'hostname:shopping-cart'
          events:
            - name: "deployment events"
              query: "app:myapp AND type:github"
            - name: "event type B"
              query: "app:myapp AND type:github"
          logs:
            - name: "critical logs"
              query: "app:myapp AND type:github"
            - name: "ops logs"
              query: "app:myapp AND type:github"
          pipelines:
            fingerprints:
              - fp1
              - fp2
          codeLocations:
            - repositoryURL: http://github/shopping-cart.git
              paths:
                - baz/*.c
                - bat/**/*
                - ../plop/*.java
            - repositoryURL: http://github/shopping-cart-2.git
              paths:
                - baz/*.c
                - bat/**/*
                - ../plop/*.java
        \"\"\")
        # v3 datastore entity 
        datastore_v3 = datadog.SoftwareCatalog("datastore_v3", entity=\"\"\"apiVersion: v3
        kind: datastore
        metadata:
          name: shopping-cart-db
          tags:
            - tag:value
          links:
            - name: shopping-cart-db runbook
              type: runbook
              url: https://runbook/shopping-cart
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/shopping-cart-db:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: "postgres"
        datadog:
          performanceData:
            tags: ['tag:random']
        \"\"\")
        # v3 queue entity 
        queue_v3 = datadog.SoftwareCatalog("queue_v3", entity=\"\"\"apiVersion: v3
        kind: queue
        metadata:
          name: order-queue
          tags:
            - tag:value
          links:
            - name: order-queue runbook
              type: runbook
              url: https://runbook/order-queue
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        extensions:
          datadoghq.com/order-queue:
            customField: customValue
        spec:
          lifecycle: production
          tier: "1"
          type: kafka
        datadog:
          performanceData:
            tags: ['tag:random']
        \"\"\")
        # v3 system entity 
        system_v3 = datadog.SoftwareCatalog("system_v3", entity=\"\"\"apiVersion: v3
        kind: system
        metadata:
          name: shopping-system
          displayName: Shopping System
          tags:
            - tag:value
          links:
            - name: shopping-system runbook
              type: runbook
              url: https://runbook/shopping-system
          contacts:
            - name: Support Email
              type: email
              contact: team@shopping.com
            - name: Support Slack
              type: slack
              contact: https://www.slack.com/archives/shopping-cart
          owner: myteam
          additionalOwners:
            - name: opsTeam
              type: operator
        integrations:
          pagerduty:
            serviceURL: https://www.pagerduty.com/service-directory/Pshopping-cart
          opsgenie:
            serviceURL: https://www.opsgenie.com/service/shopping-cart
            region: US
        spec:
          components:
            - service:shopping-cart
            - queue:order-queue
            - database:shopping-cart-db
        extensions:
          datadoghq.com/shopping-system:
            customField: customValue
        datadog:
          events:
            - name: "deployment events"
              query: "app:myapp AND type:github"
            - name: "event type B"
              query: "app:myapp AND type:github"
          logs:
            - name: "critical logs"
              query: "app:myapp AND type:github"
            - name: "ops logs"
              query: "app:myapp AND type:github"
        \"\"\")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/softwareCatalog:SoftwareCatalog this <name>
        ```

        :param str resource_name: The name of the resource.
        :param SoftwareCatalogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwareCatalogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwareCatalogArgs.__new__(SoftwareCatalogArgs)

            if entity is None and not opts.urn:
                raise TypeError("Missing required property 'entity'")
            __props__.__dict__["entity"] = entity
        super(SoftwareCatalog, __self__).__init__(
            'datadog:index/softwareCatalog:SoftwareCatalog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity: Optional[pulumi.Input[_builtins.str]] = None) -> 'SoftwareCatalog':
        """
        Get an existing SoftwareCatalog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity: The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SoftwareCatalogState.__new__(_SoftwareCatalogState)

        __props__.__dict__["entity"] = entity
        return SoftwareCatalog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> pulumi.Output[_builtins.str]:
        """
        The catalog entity definition. Entity must be a valid entity YAML/JSON structure.
        """
        return pulumi.get(self, "entity")

