<p align="center">
<img src="https://raw.githubusercontent.com/giecaruff/logos/main/APPY/stoneforge.png" width="400"/>

<h2 align="center">Algorithms, methods and equations for geophysics in Python</h2>

<p align="center">
Part of the <strong>Appy</strong> project
</p>



<p align="center">
<a href="https://giecaruff.github.io/stoneforge/"><strong>Documentation</strong> (latest)</a> |
<a href="http://gcr.sites.uff.br/"><strong>Institutional</strong> (GIECAR website)</a> 
</p>


<p align="center">
<a href="https://github.com/giecaruff/stoneforge/actions"><img src="https://github.com/giecaruff/stoneforge/actions/workflows/CI.yml/badge.svg" alt="Latest version on PyPI"/></a>
<a href="https://badge.fury.io/py/stoneforge"><img src="https://badge.fury.io/py/stoneforge.svg" alt="PyPI version" height="20"></a>
</p>
  
<!-- 
[![https://github.com/giecaruff/stoneforge/actions](https://github.com/giecaruff/stoneforge/actions/workflows/CI.yml/badge.svg)](https://github.com/giecaruff/stoneforge/actions)
-->

  
## About

The Stoneforge library is linked to the GIECAR laboratory at the Universidade Federal Fluminense (UFF) related to the Geology and Geophysics Departmnet <a href="http://geologiaegeofisica.sites.uff.br/"> (GGO)</a>, and its purpose is to teach and develop routines in Python to solve geological and geophysical problems.


## Installation and first steps

To install stoneforge use the following syntax in your command interpreter environment:

```
$pip install stoneforge
```

and them verify the installation using the following command in Python:

```
>>> import stoneforge
```
  
## Dataset

The stoneforge dataset comprises the following data: 

Four .las data from wildcat wells in the National Petroleum Reserve in Alaska. Those where drilled in the National Petroleum Reserve in Alaska (NPRA). </br>
[USGS Well Index](https://pubs.usgs.gov/of/1999/ofr-99-0015/Wells/WellIdx.htm)

Two .dlis data from the Mississippi Fan (Gulf of Mexico) from the DSDP (Deep Sea Drilling Project); DSDP Leg 96 - Hole 616; Processed and Original data. </br>
[DSDP Leg 96 - Hole 616](https://mlp.ldeo.columbia.edu/data/dsdp/leg96/616/)

Zihlman, F. N creator ; Oliver, H. L ; Geological Survey (U.S.)
Reston, Va. : Denver, Colo : U.S. Dept. of the Interior, U.S. Geological Survey1999
