# Example notebooks

This repository contains a number of notebooks designed to introduce key aspects of the Python interface to lephare. 
Here is a biref outline of each notebook and its purpose:

- [Minimal_photoz_run.ipynb] (Minimal_photoz_run.ipynb) This is a minimal run of photo-z.
- [Typical_use_case.ipynb] (Typical_use_case.ipynb) This is a run showing how to compute the photo-z for a reduced part of the COSMOS2020 catalogue.
- [Typical_use_case_physicalParameters.ipynb] (Typical_use_case_physicalParameters.ipynb) This is a run showing how to compute the physical parameters for a reduced part of the COSMOS2020 catalogue.
- [Example_full_run.ipynb](Example_full_run.ipynb) This is an example of how to conduct a full photometric redshift run over an input catalogue. All intermediate stages are performed.
- [Building_list_of_onesources.ipynb](Building_list_of_onesources.ipynb) This notebook creates a list of sources with similar photometric data which can be looped over to compute photometric redshift estimates.
- [Example_of_usage_of_magSvc.ipynb](Example_of_usage_of_magSvc.ipynb) This notebook demonstrates the magSvc class which can return magnitudes for a given SED template under given conditions.
- [Testing_fit_of_one_object_of_the_catalogue.ipynb](Testing_fit_of_one_object_of_the_catalogue.ipynb) Demonstrating a simple fit and plotting functions.
- [Example_cosmo.ipynb](Example_cosmo.ipynb) A very simple deomstration of the basic cosmology classes.
- [Example_SED_manipulation.ipynb](Example_SED_manipulation.ipynb) Demonstrates some features of the intermediate binary files created during a run.
- [Data_retrieval.ipynb](Data_retrieval.ipynb) Example getting and retrieving data required for a run.