import lephare as lp

__all__ = ["default_cosmos_config"]

default_cosmos_config = {
    "ADAPT_BAND": "5",
    "ADAPT_CONTEXT": "-1",
    "ADAPT_LIM": "1.5,23.0",
    "ADAPT_MODBIN": "1,1000",
    "ADAPT_ZBIN": "0.01,6",
    "ADDITIONAL_MAG": "none",
    "ADD_DUSTEM": "NO",
    "ADD_EMLINES": "0,10000",
    "AGE_RANGE": "0.,15.e9",
    "AUTO_ADAPT": "NO",
    "CAT_FMT": "MEME",
    "CAT_IN": "change_me_to_output_filename_required.ascii",
    "CAT_LINES": "0,1000000000",
    "CAT_MAG": "AB",
    "CAT_OUT": "zphot.out",
    "CAT_TYPE": "LONG",
    "CHI2_OUT": "NO",
    "COSMOLOGY": "70,0.3,0.7",
    "DZ_WIN": "1.0",
    "EBV_RANGE": "0,9",
    "EB_V": "0.,0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.5",
    "EM_DISPERSION": "0.5,0.75,1.,1.5,2.",
    "EM_LINES": "EMP_UV",
    "ERR_FACTOR": "1.5",
    "ERR_SCALE": "0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.05,0.05,0.05,0.05,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.05,0.05,0.05,0.05,0.1,0.2,0.3",  # noqa: E501
    "EXTERNALZ_FILE": "NONE",
    "EXTINC_LAW": "SMC_prevot.dat,SB_calzetti.dat,SB_calzetti_bump1.dat,SB_calzetti_bump2.dat",
    "FILTER_CALIB": "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1",
    "FILTER_FILE": "filter_cosmos",
    "FILTER_LIST": "cosmos/u_cfht.lowres,cosmos/u_new.pb,hsc/gHSC.pb,hsc/rHSC.pb,hsc/iHSC.pb,hsc/zHSC.pb,hsc/yHSC.pb,vista/Y.lowres,vista/J.lowres,vista/H.lowres,vista/K.lowres,cosmos/IB427.lowres,cosmos/IB464.lowres,cosmos/IB484.lowres,cosmos/IB505.lowres,cosmos/IB527.lowres,cosmos/IB574.lowres,cosmos/IB624.lowres,cosmos/IB679.lowres,cosmos/IB709.lowres,cosmos/IB738.lowres,cosmos/IB767.lowres,cosmos/IB827.lowres,cosmos/NB711.lowres,cosmos/NB816.lowres,vista/NB118.lowres,cosmos/irac_ch1.lowres,cosmos/irac_ch2.lowres,cosmos/irac_ch3.lowres,cosmos/irac_ch4.lowres",  # noqa: E501
    "FILTER_REP": f"{lp.LEPHAREDIR}/filt",
    "FIR_CONT": "-1",
    "FIR_FREESCALE": "YES",
    "FIR_LIB": "NONE",
    "FIR_LMIN": "7.0",
    "FIR_SCALE": "-1",
    "FIR_SUBSTELLAR": "NO",
    "FORB_CONTEXT": "-1",
    "GAL_FSCALE": "1.",
    "GAL_LIB": "LIB_CE",
    "GAL_LIB_IN": "LIB_CE",
    "GAL_LIB_OUT": "CE_COSMOS",
    "GAL_SED": f"{lp.LEPHAREDIR}/sed/GAL/COSMOS_SED/COSMOS_MOD.list",
    "GLB_CONTEXT": "0",
    "INP_TYPE": "F",
    "LIB_ASCII": "NO",
    "LIMITS_MAPP_CUT": "90",
    "LIMITS_MAPP_REF": "1",
    "LIMITS_MAPP_SEL": "1",
    "LIMITS_ZBIN": "0,99",
    "MABS_CONTEXT": "33556478",
    "MABS_FILT": "1,2,3,4",
    "MABS_METHOD": "1",
    "MABS_REF": "11",
    "MABS_ZBIN": "0,0.5,2,4,6",
    "MAGTYPE": "AB",
    "MAG_ABS": "-24,-5",
    "MAG_ABS_QSO": "-30,-10",
    "MAG_REF": "3",
    "MIN_THRES": "0.02",
    "MOD_EXTINC": "0,0",
    "PARA_OUT": f"{lp.LEPHAREDIR}/examples/output.para",
    "PDZ_OUT": "test",
    "PDZ_TYPE": "BAY_ZG",
    "QSO_FSCALE": "1.",
    "QSO_LIB": "LIB_QSO",
    "QSO_LIB_IN": "LIB_QSO",
    "QSO_LIB_OUT": "QSO_COSMOS",
    "QSO_SED": f"{lp.LEPHAREDIR}/sed/QSO/SALVATO09/AGN_MOD.list",
    "RF_COLORS": "32,4,4,13",
    "RM_DISCREPANT_BD": "500",
    "SPEC_OUT": "NO",
    "STAR_FSCALE": "3.432E-09",
    "STAR_LIB": "LIB_STAR",
    "STAR_LIB_IN": "LIB_STAR",
    "STAR_LIB_OUT": "STAR_COSMOS",
    "STAR_SED": f"{lp.LEPHAREDIR}/sed/STAR/STAR_MOD_ALL.list",
    "TRANS_TYPE": "1",
    "VERBOSE": "NO",
    "ZFIX": "NO",
    "ZGRID_TYPE": "0",
    "ZPHOTLIB": "CE_COSMOS,STAR_COSMOS,QSO_COSMOS",
    "Z_INTERP": "YES",
    "Z_METHOD": "BEST",
    "Z_RANGE": "0.,99.99",
    "Z_STEP": "0.01,0.,7.",
}
