from typing import List

# dependencies for the generated Python class
from ..ev3_msgs.pdu_pytype_Ev3PduColorSensor import Ev3PduColorSensor
from ..ev3_msgs.pdu_pytype_Ev3PduSensorHeader import Ev3PduSensorHeader
from ..ev3_msgs.pdu_pytype_Ev3PduTouchSensor import Ev3PduTouchSensor


# class definition for the ROS message
class Ev3PduSensor:
    """
    ROS message: ev3_msgs/Ev3PduSensor
    Generated by hakoniwa-ros2pdu.
    """

    head: Ev3PduSensorHeader
    buttons: List[int]
    color_sensors: List[Ev3PduColorSensor]
    touch_sensors: List[Ev3PduTouchSensor]
    motor_angle: List[int]
    gyro_degree: int
    gyro_degree_rate: int
    sensor_ultrasonic: int
    gps_lat: float
    gps_lon: float

    def __init__(self):
        self.head = Ev3PduSensorHeader()
        self.buttons = []
        self.color_sensors = []
        self.touch_sensors = []
        self.motor_angle = []
        self.gyro_degree = 0
        self.gyro_degree_rate = 0
        self.sensor_ultrasonic = 0
        self.gps_lat = 0.0
        self.gps_lon = 0.0

    def __str__(self):
        return f"Ev3PduSensor(" + ", ".join([
            f"head={self.head}"
            f"buttons={self.buttons}"
            f"color_sensors={self.color_sensors}"
            f"touch_sensors={self.touch_sensors}"
            f"motor_angle={self.motor_angle}"
            f"gyro_degree={self.gyro_degree}"
            f"gyro_degree_rate={self.gyro_degree_rate}"
            f"sensor_ultrasonic={self.sensor_ultrasonic}"
            f"gps_lat={self.gps_lat}"
            f"gps_lon={self.gps_lon}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'head'
        field_val = self.head
        if isinstance(field_val, bytearray):
            d['head'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['head'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['head'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['head'] = field_val
        # handle field 'buttons'
        field_val = self.buttons
        if isinstance(field_val, bytearray):
            d['buttons'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['buttons'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['buttons'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['buttons'] = field_val
        # handle field 'color_sensors'
        field_val = self.color_sensors
        if isinstance(field_val, bytearray):
            d['color_sensors'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['color_sensors'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['color_sensors'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['color_sensors'] = field_val
        # handle field 'touch_sensors'
        field_val = self.touch_sensors
        if isinstance(field_val, bytearray):
            d['touch_sensors'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['touch_sensors'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['touch_sensors'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['touch_sensors'] = field_val
        # handle field 'motor_angle'
        field_val = self.motor_angle
        if isinstance(field_val, bytearray):
            d['motor_angle'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['motor_angle'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['motor_angle'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['motor_angle'] = field_val
        # handle field 'gyro_degree'
        field_val = self.gyro_degree
        if isinstance(field_val, bytearray):
            d['gyro_degree'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['gyro_degree'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['gyro_degree'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['gyro_degree'] = field_val
        # handle field 'gyro_degree_rate'
        field_val = self.gyro_degree_rate
        if isinstance(field_val, bytearray):
            d['gyro_degree_rate'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['gyro_degree_rate'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['gyro_degree_rate'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['gyro_degree_rate'] = field_val
        # handle field 'sensor_ultrasonic'
        field_val = self.sensor_ultrasonic
        if isinstance(field_val, bytearray):
            d['sensor_ultrasonic'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['sensor_ultrasonic'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['sensor_ultrasonic'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['sensor_ultrasonic'] = field_val
        # handle field 'gps_lat'
        field_val = self.gps_lat
        if isinstance(field_val, bytearray):
            d['gps_lat'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['gps_lat'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['gps_lat'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['gps_lat'] = field_val
        # handle field 'gps_lon'
        field_val = self.gps_lon
        if isinstance(field_val, bytearray):
            d['gps_lon'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['gps_lon'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['gps_lon'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['gps_lon'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'head'
        if 'head' in d:
            field_type = cls.__annotations__.get('head')
            value = d['head']
            
            if field_type is bytearray:
                obj.head = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.head = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.head = value
            elif hasattr(field_type, 'from_dict'):
                obj.head = field_type.from_dict(value)
            else:
                obj.head = value
        # handle field 'buttons'
        if 'buttons' in d:
            field_type = cls.__annotations__.get('buttons')
            value = d['buttons']
            
            if field_type is bytearray:
                obj.buttons = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.buttons = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.buttons = value
            elif hasattr(field_type, 'from_dict'):
                obj.buttons = field_type.from_dict(value)
            else:
                obj.buttons = value
        # handle field 'color_sensors'
        if 'color_sensors' in d:
            field_type = cls.__annotations__.get('color_sensors')
            value = d['color_sensors']
            
            if field_type is bytearray:
                obj.color_sensors = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.color_sensors = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.color_sensors = value
            elif hasattr(field_type, 'from_dict'):
                obj.color_sensors = field_type.from_dict(value)
            else:
                obj.color_sensors = value
        # handle field 'touch_sensors'
        if 'touch_sensors' in d:
            field_type = cls.__annotations__.get('touch_sensors')
            value = d['touch_sensors']
            
            if field_type is bytearray:
                obj.touch_sensors = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.touch_sensors = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.touch_sensors = value
            elif hasattr(field_type, 'from_dict'):
                obj.touch_sensors = field_type.from_dict(value)
            else:
                obj.touch_sensors = value
        # handle field 'motor_angle'
        if 'motor_angle' in d:
            field_type = cls.__annotations__.get('motor_angle')
            value = d['motor_angle']
            
            if field_type is bytearray:
                obj.motor_angle = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.motor_angle = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.motor_angle = value
            elif hasattr(field_type, 'from_dict'):
                obj.motor_angle = field_type.from_dict(value)
            else:
                obj.motor_angle = value
        # handle field 'gyro_degree'
        if 'gyro_degree' in d:
            field_type = cls.__annotations__.get('gyro_degree')
            value = d['gyro_degree']
            
            if field_type is bytearray:
                obj.gyro_degree = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.gyro_degree = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.gyro_degree = value
            elif hasattr(field_type, 'from_dict'):
                obj.gyro_degree = field_type.from_dict(value)
            else:
                obj.gyro_degree = value
        # handle field 'gyro_degree_rate'
        if 'gyro_degree_rate' in d:
            field_type = cls.__annotations__.get('gyro_degree_rate')
            value = d['gyro_degree_rate']
            
            if field_type is bytearray:
                obj.gyro_degree_rate = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.gyro_degree_rate = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.gyro_degree_rate = value
            elif hasattr(field_type, 'from_dict'):
                obj.gyro_degree_rate = field_type.from_dict(value)
            else:
                obj.gyro_degree_rate = value
        # handle field 'sensor_ultrasonic'
        if 'sensor_ultrasonic' in d:
            field_type = cls.__annotations__.get('sensor_ultrasonic')
            value = d['sensor_ultrasonic']
            
            if field_type is bytearray:
                obj.sensor_ultrasonic = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.sensor_ultrasonic = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.sensor_ultrasonic = value
            elif hasattr(field_type, 'from_dict'):
                obj.sensor_ultrasonic = field_type.from_dict(value)
            else:
                obj.sensor_ultrasonic = value
        # handle field 'gps_lat'
        if 'gps_lat' in d:
            field_type = cls.__annotations__.get('gps_lat')
            value = d['gps_lat']
            
            if field_type is bytearray:
                obj.gps_lat = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.gps_lat = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.gps_lat = value
            elif hasattr(field_type, 'from_dict'):
                obj.gps_lat = field_type.from_dict(value)
            else:
                obj.gps_lat = value
        # handle field 'gps_lon'
        if 'gps_lon' in d:
            field_type = cls.__annotations__.get('gps_lon')
            value = d['gps_lon']
            
            if field_type is bytearray:
                obj.gps_lon = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.gps_lon = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.gps_lon = value
            elif hasattr(field_type, 'from_dict'):
                obj.gps_lon = field_type.from_dict(value)
            else:
                obj.gps_lon = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
