from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Twist:
    """
    ROS message: geometry_msgs/Twist
    Generated by hakoniwa-ros2pdu.
    """

    linear: Vector3
    angular: Vector3

    def __init__(self):
        self.linear = Vector3()
        self.angular = Vector3()

    def __str__(self):
        return f"Twist(" + ", ".join([
            f"linear={self.linear}"
            f"angular={self.angular}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'linear'
        field_val = self.linear
        if isinstance(field_val, bytearray):
            d['linear'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['linear'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['linear'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['linear'] = field_val
        # handle field 'angular'
        field_val = self.angular
        if isinstance(field_val, bytearray):
            d['angular'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angular'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angular'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angular'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'linear'
        if 'linear' in d:
            field_type = cls.__annotations__.get('linear')
            value = d['linear']
            
            if field_type is bytearray:
                obj.linear = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.linear = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.linear = value
            elif hasattr(field_type, 'from_dict'):
                obj.linear = field_type.from_dict(value)
            else:
                obj.linear = value
        # handle field 'angular'
        if 'angular' in d:
            field_type = cls.__annotations__.get('angular')
            value = d['angular']
            
            if field_type is bytearray:
                obj.angular = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angular = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angular = value
            elif hasattr(field_type, 'from_dict'):
                obj.angular = field_type.from_dict(value)
            else:
                obj.angular = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
