from typing import List

# dependencies for the generated Python class
from ..hako_msgs.pdu_pytype_DisturbanceAtm import DisturbanceAtm
from ..hako_msgs.pdu_pytype_DisturbanceBoundary import DisturbanceBoundary
from ..hako_msgs.pdu_pytype_DisturbanceTemperature import DisturbanceTemperature
from ..hako_msgs.pdu_pytype_DisturbanceWind import DisturbanceWind
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Disturbance:
    """
    ROS message: hako_msgs/Disturbance
    Generated by hakoniwa-ros2pdu.
    """

    d_temp: DisturbanceTemperature
    d_wind: DisturbanceWind
    d_atm: DisturbanceAtm
    d_boundary: DisturbanceBoundary

    def __init__(self):
        self.d_temp = DisturbanceTemperature()
        self.d_wind = DisturbanceWind()
        self.d_atm = DisturbanceAtm()
        self.d_boundary = DisturbanceBoundary()

    def __str__(self):
        return f"Disturbance(" + ", ".join([
            f"d_temp={self.d_temp}"
            f"d_wind={self.d_wind}"
            f"d_atm={self.d_atm}"
            f"d_boundary={self.d_boundary}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'd_temp'
        field_val = self.d_temp
        if isinstance(field_val, bytearray):
            d['d_temp'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['d_temp'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['d_temp'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['d_temp'] = field_val
        # handle field 'd_wind'
        field_val = self.d_wind
        if isinstance(field_val, bytearray):
            d['d_wind'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['d_wind'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['d_wind'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['d_wind'] = field_val
        # handle field 'd_atm'
        field_val = self.d_atm
        if isinstance(field_val, bytearray):
            d['d_atm'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['d_atm'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['d_atm'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['d_atm'] = field_val
        # handle field 'd_boundary'
        field_val = self.d_boundary
        if isinstance(field_val, bytearray):
            d['d_boundary'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['d_boundary'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['d_boundary'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['d_boundary'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'd_temp'
        if 'd_temp' in d:
            field_type = cls.__annotations__.get('d_temp')
            value = d['d_temp']
            
            if field_type is bytearray:
                obj.d_temp = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.d_temp = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.d_temp = value
            elif hasattr(field_type, 'from_dict'):
                obj.d_temp = field_type.from_dict(value)
            else:
                obj.d_temp = value
        # handle field 'd_wind'
        if 'd_wind' in d:
            field_type = cls.__annotations__.get('d_wind')
            value = d['d_wind']
            
            if field_type is bytearray:
                obj.d_wind = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.d_wind = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.d_wind = value
            elif hasattr(field_type, 'from_dict'):
                obj.d_wind = field_type.from_dict(value)
            else:
                obj.d_wind = value
        # handle field 'd_atm'
        if 'd_atm' in d:
            field_type = cls.__annotations__.get('d_atm')
            value = d['d_atm']
            
            if field_type is bytearray:
                obj.d_atm = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.d_atm = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.d_atm = value
            elif hasattr(field_type, 'from_dict'):
                obj.d_atm = field_type.from_dict(value)
            else:
                obj.d_atm = value
        # handle field 'd_boundary'
        if 'd_boundary' in d:
            field_type = cls.__annotations__.get('d_boundary')
            value = d['d_boundary']
            
            if field_type is bytearray:
                obj.d_boundary = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.d_boundary = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.d_boundary = value
            elif hasattr(field_type, 'from_dict'):
                obj.d_boundary = field_type.from_dict(value)
            else:
                obj.d_boundary = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
