from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Twist import Twist
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class ShareObjectOwner:
    """
    ROS message: hako_msgs/ShareObjectOwner
    Generated by hakoniwa-ros2pdu.
    """

    object_name: str
    owner_id: int
    last_update: int
    pos: Twist

    def __init__(self):
        self.object_name = ""
        self.owner_id = 0
        self.last_update = 0
        self.pos = Twist()

    def __str__(self):
        return f"ShareObjectOwner(" + ", ".join([
            f"object_name={self.object_name}"
            f"owner_id={self.owner_id}"
            f"last_update={self.last_update}"
            f"pos={self.pos}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'object_name'
        field_val = self.object_name
        if isinstance(field_val, bytearray):
            d['object_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['object_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['object_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['object_name'] = field_val
        # handle field 'owner_id'
        field_val = self.owner_id
        if isinstance(field_val, bytearray):
            d['owner_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['owner_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['owner_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['owner_id'] = field_val
        # handle field 'last_update'
        field_val = self.last_update
        if isinstance(field_val, bytearray):
            d['last_update'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['last_update'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['last_update'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['last_update'] = field_val
        # handle field 'pos'
        field_val = self.pos
        if isinstance(field_val, bytearray):
            d['pos'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['pos'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['pos'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['pos'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'object_name'
        if 'object_name' in d:
            field_type = cls.__annotations__.get('object_name')
            value = d['object_name']
            
            if field_type is bytearray:
                obj.object_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.object_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.object_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.object_name = field_type.from_dict(value)
            else:
                obj.object_name = value
        # handle field 'owner_id'
        if 'owner_id' in d:
            field_type = cls.__annotations__.get('owner_id')
            value = d['owner_id']
            
            if field_type is bytearray:
                obj.owner_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.owner_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.owner_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.owner_id = field_type.from_dict(value)
            else:
                obj.owner_id = value
        # handle field 'last_update'
        if 'last_update' in d:
            field_type = cls.__annotations__.get('last_update')
            value = d['last_update']
            
            if field_type is bytearray:
                obj.last_update = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.last_update = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.last_update = value
            elif hasattr(field_type, 'from_dict'):
                obj.last_update = field_type.from_dict(value)
            else:
                obj.last_update = value
        # handle field 'pos'
        if 'pos' in d:
            field_type = cls.__annotations__.get('pos')
            value = d['pos']
            
            if field_type is bytearray:
                obj.pos = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.pos = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.pos = value
            elif hasattr(field_type, 'from_dict'):
                obj.pos = field_type.from_dict(value)
            else:
                obj.pos = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
