from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class GlobalPositionTarget:
    """
    ROS message: mavros_msgs/GlobalPositionTarget
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    coordinate_frame: int
    type_mask: int
    latitude: float
    longitude: float
    altitude: float
    velocity: Vector3
    acceleration_or_force: Vector3
    yaw: float
    yaw_rate: float

    def __init__(self):
        self.header = Header()
        self.coordinate_frame = 0
        self.type_mask = 0
        self.latitude = 0.0
        self.longitude = 0.0
        self.altitude = 0.0
        self.velocity = Vector3()
        self.acceleration_or_force = Vector3()
        self.yaw = 0.0
        self.yaw_rate = 0.0

    def __str__(self):
        return f"GlobalPositionTarget(" + ", ".join([
            f"header={self.header}"
            f"coordinate_frame={self.coordinate_frame}"
            f"type_mask={self.type_mask}"
            f"latitude={self.latitude}"
            f"longitude={self.longitude}"
            f"altitude={self.altitude}"
            f"velocity={self.velocity}"
            f"acceleration_or_force={self.acceleration_or_force}"
            f"yaw={self.yaw}"
            f"yaw_rate={self.yaw_rate}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'coordinate_frame'
        field_val = self.coordinate_frame
        if isinstance(field_val, bytearray):
            d['coordinate_frame'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['coordinate_frame'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['coordinate_frame'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['coordinate_frame'] = field_val
        # handle field 'type_mask'
        field_val = self.type_mask
        if isinstance(field_val, bytearray):
            d['type_mask'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['type_mask'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['type_mask'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['type_mask'] = field_val
        # handle field 'latitude'
        field_val = self.latitude
        if isinstance(field_val, bytearray):
            d['latitude'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['latitude'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['latitude'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['latitude'] = field_val
        # handle field 'longitude'
        field_val = self.longitude
        if isinstance(field_val, bytearray):
            d['longitude'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['longitude'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['longitude'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['longitude'] = field_val
        # handle field 'altitude'
        field_val = self.altitude
        if isinstance(field_val, bytearray):
            d['altitude'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['altitude'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['altitude'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['altitude'] = field_val
        # handle field 'velocity'
        field_val = self.velocity
        if isinstance(field_val, bytearray):
            d['velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['velocity'] = field_val
        # handle field 'acceleration_or_force'
        field_val = self.acceleration_or_force
        if isinstance(field_val, bytearray):
            d['acceleration_or_force'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['acceleration_or_force'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['acceleration_or_force'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['acceleration_or_force'] = field_val
        # handle field 'yaw'
        field_val = self.yaw
        if isinstance(field_val, bytearray):
            d['yaw'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['yaw'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['yaw'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['yaw'] = field_val
        # handle field 'yaw_rate'
        field_val = self.yaw_rate
        if isinstance(field_val, bytearray):
            d['yaw_rate'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['yaw_rate'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['yaw_rate'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['yaw_rate'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'coordinate_frame'
        if 'coordinate_frame' in d:
            field_type = cls.__annotations__.get('coordinate_frame')
            value = d['coordinate_frame']
            
            if field_type is bytearray:
                obj.coordinate_frame = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.coordinate_frame = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.coordinate_frame = value
            elif hasattr(field_type, 'from_dict'):
                obj.coordinate_frame = field_type.from_dict(value)
            else:
                obj.coordinate_frame = value
        # handle field 'type_mask'
        if 'type_mask' in d:
            field_type = cls.__annotations__.get('type_mask')
            value = d['type_mask']
            
            if field_type is bytearray:
                obj.type_mask = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.type_mask = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.type_mask = value
            elif hasattr(field_type, 'from_dict'):
                obj.type_mask = field_type.from_dict(value)
            else:
                obj.type_mask = value
        # handle field 'latitude'
        if 'latitude' in d:
            field_type = cls.__annotations__.get('latitude')
            value = d['latitude']
            
            if field_type is bytearray:
                obj.latitude = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.latitude = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.latitude = value
            elif hasattr(field_type, 'from_dict'):
                obj.latitude = field_type.from_dict(value)
            else:
                obj.latitude = value
        # handle field 'longitude'
        if 'longitude' in d:
            field_type = cls.__annotations__.get('longitude')
            value = d['longitude']
            
            if field_type is bytearray:
                obj.longitude = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.longitude = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.longitude = value
            elif hasattr(field_type, 'from_dict'):
                obj.longitude = field_type.from_dict(value)
            else:
                obj.longitude = value
        # handle field 'altitude'
        if 'altitude' in d:
            field_type = cls.__annotations__.get('altitude')
            value = d['altitude']
            
            if field_type is bytearray:
                obj.altitude = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.altitude = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.altitude = value
            elif hasattr(field_type, 'from_dict'):
                obj.altitude = field_type.from_dict(value)
            else:
                obj.altitude = value
        # handle field 'velocity'
        if 'velocity' in d:
            field_type = cls.__annotations__.get('velocity')
            value = d['velocity']
            
            if field_type is bytearray:
                obj.velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.velocity = field_type.from_dict(value)
            else:
                obj.velocity = value
        # handle field 'acceleration_or_force'
        if 'acceleration_or_force' in d:
            field_type = cls.__annotations__.get('acceleration_or_force')
            value = d['acceleration_or_force']
            
            if field_type is bytearray:
                obj.acceleration_or_force = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.acceleration_or_force = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.acceleration_or_force = value
            elif hasattr(field_type, 'from_dict'):
                obj.acceleration_or_force = field_type.from_dict(value)
            else:
                obj.acceleration_or_force = value
        # handle field 'yaw'
        if 'yaw' in d:
            field_type = cls.__annotations__.get('yaw')
            value = d['yaw']
            
            if field_type is bytearray:
                obj.yaw = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.yaw = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.yaw = value
            elif hasattr(field_type, 'from_dict'):
                obj.yaw = field_type.from_dict(value)
            else:
                obj.yaw = value
        # handle field 'yaw_rate'
        if 'yaw_rate' in d:
            field_type = cls.__annotations__.get('yaw_rate')
            value = d['yaw_rate']
            
            if field_type is bytearray:
                obj.yaw_rate = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.yaw_rate = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.yaw_rate = value
            elif hasattr(field_type, 'from_dict'):
                obj.yaw_rate = field_type.from_dict(value)
            else:
                obj.yaw_rate = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
