from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Pose import Pose
from ..geometry_msgs.pdu_pytype_PoseWithCovariance import PoseWithCovariance
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Twist import Twist
from ..geometry_msgs.pdu_pytype_TwistWithCovariance import TwistWithCovariance
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Odometry:
    """
    ROS message: nav_msgs/Odometry
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    child_frame_id: str
    pose: PoseWithCovariance
    twist: TwistWithCovariance

    def __init__(self):
        self.header = Header()
        self.child_frame_id = ""
        self.pose = PoseWithCovariance()
        self.twist = TwistWithCovariance()

    def __str__(self):
        return f"Odometry(" + ", ".join([
            f"header={self.header}"
            f"child_frame_id={self.child_frame_id}"
            f"pose={self.pose}"
            f"twist={self.twist}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'child_frame_id'
        field_val = self.child_frame_id
        if isinstance(field_val, bytearray):
            d['child_frame_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['child_frame_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['child_frame_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['child_frame_id'] = field_val
        # handle field 'pose'
        field_val = self.pose
        if isinstance(field_val, bytearray):
            d['pose'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['pose'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['pose'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['pose'] = field_val
        # handle field 'twist'
        field_val = self.twist
        if isinstance(field_val, bytearray):
            d['twist'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['twist'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['twist'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['twist'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'child_frame_id'
        if 'child_frame_id' in d:
            field_type = cls.__annotations__.get('child_frame_id')
            value = d['child_frame_id']
            
            if field_type is bytearray:
                obj.child_frame_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.child_frame_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.child_frame_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.child_frame_id = field_type.from_dict(value)
            else:
                obj.child_frame_id = value
        # handle field 'pose'
        if 'pose' in d:
            field_type = cls.__annotations__.get('pose')
            value = d['pose']
            
            if field_type is bytearray:
                obj.pose = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.pose = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.pose = value
            elif hasattr(field_type, 'from_dict'):
                obj.pose = field_type.from_dict(value)
            else:
                obj.pose = value
        # handle field 'twist'
        if 'twist' in d:
            field_type = cls.__annotations__.get('twist')
            value = d['twist']
            
            if field_type is bytearray:
                obj.twist = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.twist = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.twist = value
            elif hasattr(field_type, 'from_dict'):
                obj.twist = field_type.from_dict(value)
            else:
                obj.twist = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
