"""
Backboard API Python SDK

A developer-friendly Python SDK for the Backboard API.
Build conversational AI applications with persistent memory and intelligent document processing.
"""

__version__ = "1.0.2"

from .client import BackboardClient
from .models import (
    Assistant,
    Thread, 
    Document,
    Message,
    ToolDefinition,
    FunctionDefinition,
    ToolParameters,
    ToolParameterProperties,
    AttachmentInfo,
    MessageResponse,
    ToolOutputsResponse,
    SubmitToolOutputsRequest,
    ToolOutput
)
from .exceptions import (
    BackboardError,
    BackboardAPIError,
    BackboardValidationError,
    BackboardNotFoundError,
    BackboardRateLimitError,
    BackboardServerError
)

__all__ = [
    "BackboardClient",
    "Assistant",
    "Thread",
    "Document", 
    "Message",
    "ToolDefinition",
    "FunctionDefinition",
    "ToolParameters",
    "ToolParameterProperties",
    "AttachmentInfo",
    "MessageResponse",
    "ToolOutputsResponse",
    "SubmitToolOutputsRequest",
    "ToolOutput",
    "BackboardError",
    "BackboardAPIError",
    "BackboardValidationError", 
    "BackboardNotFoundError",
    "BackboardRateLimitError",
    "BackboardServerError"
]
