# mathutils

A simple mathematics utilities library.

## Installation

From source:

1. Build the package
2. Install the wheel

## Usage

```python
from mathutils.basic_ops import add, subtract
from mathutils.statistics import mean

print(add(2,3))
print(mean([1,2,3]))
```

## Development

- Python >=3.9
- Build using `python -m build` or `/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m build`
- Install
```
prefer wheel:
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m pip install -U dist/*.whl --force-reinstall

or less common:
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m pip install -U dist/*.tar.gz --force-reinstall
``` 
- Uninstall:
`pip uninstall mathutils`

- Clean up
`rm -rf dist build mathutils.egg-info`

## Publish to (Test)PyPI with Twine

1) Build distributions (wheel + sdist):

```zsh
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m build
```

2) Install Twine:

```zsh
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m pip install -U twine
```

3) Authenticate (pick one):
- Environment vars (recommended):
```zsh
export TWINE_USERNAME="__token__"
export TWINE_PASSWORD="pypi-<your-api-token>"
```
- Or configure ~/.pypirc (optional):
```
[distutils]
index-servers = pypi

[pypi]
repository = https://upload.pypi.org/legacy/
username = __token__
password = pypi-<your-api-token>

[testpypi]
repository = https://test.pypi.org/legacy/
username = __token__
password = pypi-<your-testpypi-token>
```

4) Upload to TestPyPI first:

```zsh
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m twine upload --repository testpypi dist/*
```

5) Test install from TestPyPI:

```zsh
python3 -m pip install --index-url https://test.pypi.org/simple/ \
	--extra-index-url https://pypi.org/simple \
	mathutils-yourname
```

6) When ready, bump version in pyproject.toml, rebuild, then upload to PyPI:

```zsh
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m build
/Users/c0y00hq/Documents/Local_code/mathutils/.venv/bin/python -m twine upload dist/*
```

Notes:
- PyPI doesn’t allow re-uploading the same version. Update the version each release.
- Package install name is `mathutils-yourname`; import name is `mathutils`.