import json
import pprint

from typing_extensions import Self
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional, Set

from OuterRail.models import Address, Geo



class Location(BaseModel):

    address: Optional[Address] = None
    geo: Optional[Geo] = None
    __properties: ClassVar[List[str]] = ["address", "geo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geo
        if self.geo:
            _dict["geo"] = self.geo.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "address": (
                    Address.from_dict(obj["address"])
                    if obj.get("address") is not None
                    else None
                ),
                "geo": (
                    Geo.from_dict(obj["geo"]) if obj.get("geo") is not None else None
                ),
            }
        )
        return _obj
