"""add location regulation selections table

Revision ID: 4ced99dabebb
Revises: 548a1ac26771
Create Date: 2023-12-18 13:50:50.620939

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "4ced99dabebb"
down_revision = "548a1ac26771"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "location_regulation_selections",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("selected_locations", sa.ARRAY(sa.String()), nullable=False),
        sa.Column("selected_regulations", sa.ARRAY(sa.String()), nullable=False),
        sa.Column(
            "single_row",
            sa.Boolean(),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.CheckConstraint("single_row", name="single_row_check"),
        sa.UniqueConstraint("single_row", name="single_row_unique"),
    )
    op.create_index(
        op.f("ix_location_regulation_selections_id"),
        "location_regulation_selections",
        ["id"],
        unique=False,
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_location_regulation_selections_id"),
        table_name="location_regulation_selections",
    )
    op.drop_table("location_regulation_selections")
