# Contributing to LionAGI

Thank you for considering contributing to LionAGI! This document provides
guidelines and instructions for contributing to this project.

## Getting Started

1. **Fork the Repository**: Begin by forking the repository to your GitHub
   account. This creates your own copy of the project where you can make
   changes.

2. **Clone the Forked Repository**: Clone the repository to your local machine
   to start working on the changes.

3. **Set Up Your Development Environment**: Ensure you have a suitable Python
   development environment. Any IDE that supports Python and package
   installation should be sufficient.

## Making Changes

1. **Creating Branches**: For new features or bug fixes, create a new branch off
   the main branch. Branch names should be descriptive and reflect the feature
   or fix you are working on.

2. **Commit Messages**: Write clear and descriptive commit messages. While
   there’s no strict format, ensure your messages convey the purpose of the
   commit.

## Submitting Contributions

1. **Pull Requests**: Once you are ready with your changes, push your branch to
   your fork and open a pull request against the main repository.

2. **Pull Request Description**: Provide a detailed description of the changes
   in your pull request. Link it to any relevant issues.

3. **Code Review Process**: Your pull request will be reviewed by the project
   maintainers. Feedback may be provided for improvements.

4. **Merging**: After approval, one of the maintainers will merge your pull
   request. No direct merges into the main branch are allowed without approval.

## Testing

1. **Writing Tests**: Include unit and integration tests for your code. Ensure
   your tests cover new features as well as any changes to existing
   functionality.

2. **Running Tests Locally**: Before submitting your pull request, run all tests
   locally to ensure they pass.

## Coding Standards

1. **PEP 8**: Follow [PEP 8](https://www.python.org/dev/peps/pep-0008/) style
   guidelines for writing Python code.

2. **PEP 257**: Adhere to [PEP 257](https://www.python.org/dev/peps/pep-0257/)
   for docstring conventions.

3. **Linting**: Use linters to check your code against these standards.

## Dependencies

1. **Managing Dependencies**: Do not add or update dependencies without prior
   approval from the maintainers.

## Documentation

1. **Update Documentation**: Accompany your code changes with corresponding
   updates in the documentation.

2. **Versioning Documentation**: Documentation should be versioned alongside the
   code.

## Community Interaction

1. **Using Discord**: Use the project’s Discord for discussions, questions, and
   collaboration.

## Acknowledging Contributions

1. **Recognition**: We value your contributions and will acknowledge significant
   contributions in our social media and release notes.

2. **GitHub Sponsors**: We are considering setting up a GitHub Sponsor button to
   enable sponsorship for our contributors.

## Questions?

If you have any questions or need further clarification about contributing, feel
free to reach out on our Discord server.

Thank you for contributing to LionAGI, and we look forward to your
contributions!
