from eptr2.processing.postprocess.items import (
    postprocess_items_to_df,
    postprocess_mcp_status,
    postprocess_direct_dict,
    postprocess_direct_dict_to_df,
    postprocess_ren_capacity_dict_to_df,
)


def get_postprocess_function(key):
    if key in [
        "dam-volume",
        "pi-offer",
        "pi-bid",
        "supply-demand",
        "dam-bid",
        "dam-offer",
        "dam-block-bid",
        "dam-block-offer",
        "dam-flexible-bid",
        "dam-flexible-offer",
        "dam-flexible-matching",
        "dam-clearing",
        "dam-clearing-org-list",
        "dam-diff",
        "smp",
        "smp-dir",
        "bpm-up",
        "bpm-down",
        "mcp",
        "wap",
        "idm-qty",
        "idm-mm-bid",
        "idm-mm-offer",
        "idm-mm-matching",
        "idm-volume",
        "idm-log",
        "idm-ob-qty",
        "bi-long",
        "bi-short",
        "bi-euas",
        "imb-qty",
        "imb-vol",
        "imb-qty-g",
        "imb-org-list",
        "interim-mcp",
        "mcp-smp-imb",
        "bpm-orders-w-avg",
        "bpm-orders",
        "market-participants",
        "market-participants-organization-list",
        "participant-count-based-upon-license-type",
        "kgup",
        "kgup-v1",
        "kudup",
        "eak",
        "gen-org",
        "gen-uevcb",
        "rt-gen",
        "pp-list",
        "uevm-pp-list",
        "lic-pp-list",
        "load-plan",
        "rt-cons",
        "uecm",
        "st-uecm",
        "su-uecm",
        "uevm",
        "wind-forecast",
        "ren-rt-gen",
        "ren-ul-gen",
        "ren-ul-cost",
        "ren-unit-cost",
        "ren-income",
        "ren-total-cost",
        "ren-participant-list",
        "ren-uevm",
        "ren-lic-cost",
        "zero-balance",
        "iskk",
        "congestion-cost",
        "eic-x-org-list",
        "eic-w-org-list",
        "eic-w-uevcb-list",
        "mms",
        "mms-pp-list",
        "region-list",
        "mms-message-type-list",
        "mms-region-list",
        "mms-uevcb-list",
        "tcat-pre-year-forecast",
        "tcat-pre-month-forecast",
        "international-line-events",
        "line-capacities",
        "capacity-demand",
        "nominal-capacity",
        "dams-active-fullness",
        "dams-daily-level",
        "dams-active-volume",
        "dams-daily-volume",
        "dams-level-minmax",
        "dams-volume-minmax",
        "dams-info",
        "dams-water-energy-provision",
        "idm-summary",
        "electricity-market-quantity",
        "idm-contract-list",
        "idm-order-history",
        "anc-pf-qty",
        "anc-sf-qty",
        "anc-pfk",
        "anc-sfk",
        "long-term-demand-forecast",
        "consumption-breakdown",
        "consumer-breakdown",
        "distribution-region-list",
        "ra-distribution-list",
        "ra-organization-list",
        "ra-spg-list",
        "ra-vspg-list",
        "ra-meters",
        "ra-meter-volumes-period",
        "ra-meter-volumes-version",
        "ra-sum",
        "ng-participants",
        "ng-participant-list",
        "ng-balancing-notifications",
        "ng-balancing-price",
        "ng-bast",
        "ng-blue-code-ops",
        "ng-daily-match-qty",
        "ng-drp",
        "ng-daily-trade-volume",
        "ng-code-four-ops",
        "ng-gddk",
        "ng-green-code-ops",
        "ng-grp-match-qty",
        "ng-grp-trade-volume",
        "ng-imbalance-amount",
        "ng-imbalance-system",
        "ng-match-quantity",
        "ng-orange-code-ops",
        "ng-physical-realization",
        "ng-spot-prices",
        "ng-shippers-imbalance-quantity",
        "ng-system-direction",
        "ng-total-trade-volume",
        "ng-transaction-history",
        "ng-virtual-realization",
        "ng-weekly-matched-quantity",
        "ng-wrp",
        "ng-weekly-trade-volume",
        "ng-vgp-contract-price-summary",
        "ng-vgp-contract-price-summary-period",
        "ng-vgp-contract-price-summary-se",
        "ng-vgp-delivery-period",
        "ng-vgp-delivery-year",
        "ng-vgp-ggf",
        "ng-vgp-ggf-period",
        "ng-vgp-ggf-se",
        "ng-vgp-matched-quantity",
        "ng-vgp-matched-quantity-period",
        "ng-vgp-matched-quantity-se",
        "ng-vgp-open-positions",
        "ng-vgp-open-positions-period",
        "ng-vgp-open-positions-se",
        "ng-vgp-order-book",
        "ng-vgp-transaction-history",
        "ng-vgp-transaction-history-period",
        "ng-vgp-transaction-history-se",
        "ng-vgp-transaction-volumes",
        "ng-vgp-transaction-volumes-period",
        "ng-vgp-transaction-volumes-se",
        "ng-tr-capacity-point",
        "ng-tr-daily-transmission",
        "ng-tr-day-ahead",
        "ng-tr-day-end",
        "ng-tr-entry-nomination",
        "ng-tr-exit-nomination",
        "ng-tr-max-entry-amount",
        "ng-tr-max-exit-amount",
        "ng-tr-actual-entry-amount",
        "ng-tr-actual-exit-amount",
        "ng-tr-reserved-entry-amount",
        "ng-tr-reserved-exit-amount",
        "ng-tr-stock-amount",
        "ng-tr-storage-facility-list",
        "ng-tr-bilateral-transfer",
        "menu",
        "yek-g-bilateral-contracts",
        "yek-g-redemptions",
        "yek-g-expirations",
        "yek-g-issued",
        "yek-g-match-price-minmax",
        "yek-g-order-quantity",
        "yek-g-trade-volume",
        "yek-g-wap",
        "yek-g-withdrawals",
        "yek-g-match-quantity",
        "vep-contract-price-summary",
        "vep-delivery-period-list",
        "vep-delivery-year-list",
        "vep-ggf",
        "vep-ggf-period",
        "vep-load-types",
        "vep-price-summaries",
        "vep-open-positions",
        "vep-trade-volume",
        "vep-transaction-history",
        "vep-transaction-history-periods",
        "vep-matching-quantity",
        "eligible-consumer-count-detail",
        "eligible-consumer-quantity",
        "monthly-index",
        "multiple-factor",
        "percentage-consumption-info",
        "planned-outages",
        "eligible-consumer-count",
        "unplanned-outages",
    ]:
        return postprocess_items_to_df

    elif key in ["interim-mcp-status"]:
        return postprocess_mcp_status

    elif key in [
        "date-init",
        "intl-direction-list",
        "intl-capacity-demand-direction-list",
        "basin-list",
        "dam-list",
        "ng-latest-settlement-date",
        "page-settings",
    ]:
        return postprocess_direct_dict

    elif key in [
        "profile-group-list",
        "province-list",
        "district-list",
        "ren-pp-list",
        "get-distribution-companies",
        "main-tariff-group-list",
        "mf-distribution",
        "mf-meter-reading-type",
        "mf-profile-group",
        "elig-profile-groups",
    ]:
        return postprocess_direct_dict_to_df

    elif key in ["ren-capacity"]:
        return postprocess_ren_capacity_dict_to_df
    else:
        raise Exception("Postprocess function is not defined for this call.")
