"""webui

迁移 ID: 5d80e832962b
父迁移: 9c25f4ea773e
创建时间: 2025-08-24 20:59:48.463140

"""

from __future__ import annotations

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

revision: str = "5d80e832962b"
down_revision: str | Sequence[str] | None = "9c25f4ea773e"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "amrita_daily_usage",
        sa.Column("id", sa.BigInteger(), autoincrement=True, nullable=False),
        sa.Column("created_at", sa.String(length=64), nullable=False),
        sa.Column("bot_id", sa.String(length=255), nullable=False),
        sa.Column("msg_received", sa.BigInteger(), nullable=False),
        sa.Column("msg_sent", sa.BigInteger(), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_amrita_daily_usage")),
        sa.UniqueConstraint("bot_id", "created_at", name="uq_bot_id_created_at"),
        info={"bind_key": "webui"},
    )
    with op.batch_alter_table("amrita_daily_usage", schema=None) as batch_op:
        batch_op.create_index("idx_bot_id", ["bot_id"], unique=False)
        batch_op.create_index("idx_created_at", ["created_at"], unique=False)

    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("amrita_daily_usage", schema=None) as batch_op:
        batch_op.drop_index("idx_created_at")
        batch_op.drop_index("idx_bot_id")

    op.drop_table("amrita_daily_usage")
    # ### end Alembic commands ###
