# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessControlPolicyArgs', 'AccessControlPolicy']

@pulumi.input_type
class AccessControlPolicyArgs:
    def __init__(__self__, *,
                 role_reference: pulumi.Input['AccessControlPolicyRoleReferenceArgs'],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]] = None,
                 context_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']] = None,
                 user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]] = None):
        """
        The set of arguments for constructing a AccessControlPolicy resource.
        :param pulumi.Input['AccessControlPolicyRoleReferenceArgs'] role_reference: - (Required) The reference to a role.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[_builtins.str] description: - (Optional) The description of Access Control Policy.
        :param pulumi.Input[_builtins.str] name: - (Optional) Name of the Access Control Policy.
        :param pulumi.Input['AccessControlPolicyOwnerReferenceArgs'] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]] user_group_reference_lists: - (Optional) The User group(s) being assigned a given role.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]] user_reference_lists: - (Optional) The User(s) being assigned a given role.
        """
        pulumi.set(__self__, "role_reference", role_reference)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if context_filter_lists is not None:
            pulumi.set(__self__, "context_filter_lists", context_filter_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if user_group_reference_lists is not None:
            pulumi.set(__self__, "user_group_reference_lists", user_group_reference_lists)
        if user_reference_lists is not None:
            pulumi.set(__self__, "user_reference_lists", user_reference_lists)

    @_builtins.property
    @pulumi.getter(name="roleReference")
    def role_reference(self) -> pulumi.Input['AccessControlPolicyRoleReferenceArgs']:
        """
        - (Required) The reference to a role.
        """
        return pulumi.get(self, "role_reference")

    @role_reference.setter
    def role_reference(self, value: pulumi.Input['AccessControlPolicyRoleReferenceArgs']):
        pulumi.set(self, "role_reference", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="contextFilterLists")
    def context_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]]:
        return pulumi.get(self, "context_filter_lists")

    @context_filter_lists.setter
    def context_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]]):
        pulumi.set(self, "context_filter_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The description of Access Control Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Name of the Access Control Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="userGroupReferenceLists")
    def user_group_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]]:
        """
        - (Optional) The User group(s) being assigned a given role.
        """
        return pulumi.get(self, "user_group_reference_lists")

    @user_group_reference_lists.setter
    def user_group_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]]):
        pulumi.set(self, "user_group_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]]:
        """
        - (Optional) The User(s) being assigned a given role.
        """
        return pulumi.get(self, "user_reference_lists")

    @user_reference_lists.setter
    def user_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]]):
        pulumi.set(self, "user_reference_lists", value)


@pulumi.input_type
class _AccessControlPolicyState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]] = None,
                 context_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']] = None,
                 role_reference: Optional[pulumi.Input['AccessControlPolicyRoleReferenceArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]] = None):
        """
        Input properties used for looking up and filtering AccessControlPolicy resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[_builtins.str] description: - (Optional) The description of Access Control Policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The Access Control Policy kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Optional) Name of the Access Control Policy.
        :param pulumi.Input['AccessControlPolicyOwnerReferenceArgs'] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input['AccessControlPolicyRoleReferenceArgs'] role_reference: - (Required) The reference to a role.
        :param pulumi.Input[_builtins.str] state: - The state of the Access Control Policy.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]] user_group_reference_lists: - (Optional) The User group(s) being assigned a given role.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]] user_reference_lists: - (Optional) The User(s) being assigned a given role.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if context_filter_lists is not None:
            pulumi.set(__self__, "context_filter_lists", context_filter_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if role_reference is not None:
            pulumi.set(__self__, "role_reference", role_reference)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_group_reference_lists is not None:
            pulumi.set(__self__, "user_group_reference_lists", user_group_reference_lists)
        if user_reference_lists is not None:
            pulumi.set(__self__, "user_reference_lists", user_reference_lists)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="contextFilterLists")
    def context_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]]:
        return pulumi.get(self, "context_filter_lists")

    @context_filter_lists.setter
    def context_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyContextFilterListArgs']]]]):
        pulumi.set(self, "context_filter_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The description of Access Control Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - The Access Control Policy kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Name of the Access Control Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['AccessControlPolicyOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="roleReference")
    def role_reference(self) -> Optional[pulumi.Input['AccessControlPolicyRoleReferenceArgs']]:
        """
        - (Required) The reference to a role.
        """
        return pulumi.get(self, "role_reference")

    @role_reference.setter
    def role_reference(self, value: Optional[pulumi.Input['AccessControlPolicyRoleReferenceArgs']]):
        pulumi.set(self, "role_reference", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The state of the Access Control Policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="userGroupReferenceLists")
    def user_group_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]]:
        """
        - (Optional) The User group(s) being assigned a given role.
        """
        return pulumi.get(self, "user_group_reference_lists")

    @user_group_reference_lists.setter
    def user_group_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserGroupReferenceListArgs']]]]):
        pulumi.set(self, "user_group_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]]:
        """
        - (Optional) The User(s) being assigned a given role.
        """
        return pulumi.get(self, "user_reference_lists")

    @user_reference_lists.setter
    def user_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlPolicyUserReferenceListArgs']]]]):
        pulumi.set(self, "user_reference_lists", value)


@pulumi.type_token("nutanix:index/accessControlPolicy:AccessControlPolicy")
class AccessControlPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyCategoryArgs', 'AccessControlPolicyCategoryArgsDict']]]]] = None,
                 context_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyContextFilterListArgs', 'AccessControlPolicyContextFilterListArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Union['AccessControlPolicyOwnerReferenceArgs', 'AccessControlPolicyOwnerReferenceArgsDict']]] = None,
                 role_reference: Optional[pulumi.Input[Union['AccessControlPolicyRoleReferenceArgs', 'AccessControlPolicyRoleReferenceArgsDict']]] = None,
                 user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserGroupReferenceListArgs', 'AccessControlPolicyUserGroupReferenceListArgsDict']]]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserReferenceListArgs', 'AccessControlPolicyUserReferenceListArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a resource to create an access control policy based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.AccessControlPolicy("test",
            name="NAME OF ACCESS CONTROL POLICY",
            description="DESCRIPTION OF THE ACCESS CONTROL POLICY",
            role_reference={
                "kind": "role",
                "uuid": "UUID of role",
            },
            user_reference_lists=[{
                "uuid": "UUID of User existent",
                "name": "admin",
            }],
            context_filter_lists=[{
                "entity_filter_expression_lists": [
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "cluster",
                        "right_hand_side": {
                            "uuid_lists": ["00058ef8-c31c-f0bc-0000-000000007b23"],
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "image",
                        "right_hand_side": {
                            "collection": "ALL",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "category",
                        "right_hand_side": {
                            "collection": "ALL",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "marketplace_item",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "app_task",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "app_variable",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyCategoryArgs', 'AccessControlPolicyCategoryArgsDict']]]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[_builtins.str] description: - (Optional) The description of Access Control Policy.
        :param pulumi.Input[_builtins.str] name: - (Optional) Name of the Access Control Policy.
        :param pulumi.Input[Union['AccessControlPolicyOwnerReferenceArgs', 'AccessControlPolicyOwnerReferenceArgsDict']] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Union['AccessControlPolicyRoleReferenceArgs', 'AccessControlPolicyRoleReferenceArgsDict']] role_reference: - (Required) The reference to a role.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserGroupReferenceListArgs', 'AccessControlPolicyUserGroupReferenceListArgsDict']]]] user_group_reference_lists: - (Optional) The User group(s) being assigned a given role.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserReferenceListArgs', 'AccessControlPolicyUserReferenceListArgsDict']]]] user_reference_lists: - (Optional) The User(s) being assigned a given role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessControlPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an access control policy based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.AccessControlPolicy("test",
            name="NAME OF ACCESS CONTROL POLICY",
            description="DESCRIPTION OF THE ACCESS CONTROL POLICY",
            role_reference={
                "kind": "role",
                "uuid": "UUID of role",
            },
            user_reference_lists=[{
                "uuid": "UUID of User existent",
                "name": "admin",
            }],
            context_filter_lists=[{
                "entity_filter_expression_lists": [
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "cluster",
                        "right_hand_side": {
                            "uuid_lists": ["00058ef8-c31c-f0bc-0000-000000007b23"],
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "image",
                        "right_hand_side": {
                            "collection": "ALL",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "category",
                        "right_hand_side": {
                            "collection": "ALL",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "marketplace_item",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "app_task",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                    {
                        "operator": "IN",
                        "left_hand_side_entity_type": "app_variable",
                        "right_hand_side": {
                            "collection": "SELF_OWNED",
                        },
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param AccessControlPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessControlPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyCategoryArgs', 'AccessControlPolicyCategoryArgsDict']]]]] = None,
                 context_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyContextFilterListArgs', 'AccessControlPolicyContextFilterListArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Union['AccessControlPolicyOwnerReferenceArgs', 'AccessControlPolicyOwnerReferenceArgsDict']]] = None,
                 role_reference: Optional[pulumi.Input[Union['AccessControlPolicyRoleReferenceArgs', 'AccessControlPolicyRoleReferenceArgsDict']]] = None,
                 user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserGroupReferenceListArgs', 'AccessControlPolicyUserGroupReferenceListArgsDict']]]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserReferenceListArgs', 'AccessControlPolicyUserReferenceListArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessControlPolicyArgs.__new__(AccessControlPolicyArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["context_filter_lists"] = context_filter_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_reference"] = owner_reference
            if role_reference is None and not opts.urn:
                raise TypeError("Missing required property 'role_reference'")
            __props__.__dict__["role_reference"] = role_reference
            __props__.__dict__["user_group_reference_lists"] = user_group_reference_lists
            __props__.__dict__["user_reference_lists"] = user_reference_lists
            __props__.__dict__["api_version"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["state"] = None
        super(AccessControlPolicy, __self__).__init__(
            'nutanix:index/accessControlPolicy:AccessControlPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyCategoryArgs', 'AccessControlPolicyCategoryArgsDict']]]]] = None,
            context_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyContextFilterListArgs', 'AccessControlPolicyContextFilterListArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_reference: Optional[pulumi.Input[Union['AccessControlPolicyOwnerReferenceArgs', 'AccessControlPolicyOwnerReferenceArgsDict']]] = None,
            role_reference: Optional[pulumi.Input[Union['AccessControlPolicyRoleReferenceArgs', 'AccessControlPolicyRoleReferenceArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserGroupReferenceListArgs', 'AccessControlPolicyUserGroupReferenceListArgsDict']]]]] = None,
            user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserReferenceListArgs', 'AccessControlPolicyUserReferenceListArgsDict']]]]] = None) -> 'AccessControlPolicy':
        """
        Get an existing AccessControlPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyCategoryArgs', 'AccessControlPolicyCategoryArgsDict']]]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[_builtins.str] description: - (Optional) The description of Access Control Policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The Access Control Policy kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Optional) Name of the Access Control Policy.
        :param pulumi.Input[Union['AccessControlPolicyOwnerReferenceArgs', 'AccessControlPolicyOwnerReferenceArgsDict']] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Union['AccessControlPolicyRoleReferenceArgs', 'AccessControlPolicyRoleReferenceArgsDict']] role_reference: - (Required) The reference to a role.
        :param pulumi.Input[_builtins.str] state: - The state of the Access Control Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserGroupReferenceListArgs', 'AccessControlPolicyUserGroupReferenceListArgsDict']]]] user_group_reference_lists: - (Optional) The User group(s) being assigned a given role.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlPolicyUserReferenceListArgs', 'AccessControlPolicyUserReferenceListArgsDict']]]] user_reference_lists: - (Optional) The User(s) being assigned a given role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessControlPolicyState.__new__(_AccessControlPolicyState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["categories"] = categories
        __props__.__dict__["context_filter_lists"] = context_filter_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["role_reference"] = role_reference
        __props__.__dict__["state"] = state
        __props__.__dict__["user_group_reference_lists"] = user_group_reference_lists
        __props__.__dict__["user_reference_lists"] = user_reference_lists
        return AccessControlPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.AccessControlPolicyCategory']]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="contextFilterLists")
    def context_filter_lists(self) -> pulumi.Output[Sequence['outputs.AccessControlPolicyContextFilterList']]:
        return pulumi.get(self, "context_filter_lists")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The description of Access Control Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - The Access Control Policy kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Name of the Access Control Policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output['outputs.AccessControlPolicyOwnerReference']:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="roleReference")
    def role_reference(self) -> pulumi.Output['outputs.AccessControlPolicyRoleReference']:
        """
        - (Required) The reference to a role.
        """
        return pulumi.get(self, "role_reference")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - The state of the Access Control Policy.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userGroupReferenceLists")
    def user_group_reference_lists(self) -> pulumi.Output[Sequence['outputs.AccessControlPolicyUserGroupReferenceList']]:
        """
        - (Optional) The User group(s) being assigned a given role.
        """
        return pulumi.get(self, "user_group_reference_lists")

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> pulumi.Output[Sequence['outputs.AccessControlPolicyUserReferenceList']]:
        """
        - (Optional) The User(s) being assigned a given role.
        """
        return pulumi.get(self, "user_reference_lists")

