# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddressGroupArgs', 'AddressGroup']

@pulumi.input_type
class AddressGroupArgs:
    def __init__(__self__, *,
                 ip_address_block_lists: pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AddressGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]] ip_address_block_lists: - (Required) list of IP address blocks with their prefix length
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        """
        pulumi.set(__self__, "ip_address_block_lists", ip_address_block_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="ipAddressBlockLists")
    def ip_address_block_lists(self) -> pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]]:
        """
        - (Required) list of IP address blocks with their prefix length
        """
        return pulumi.get(self, "ip_address_block_lists")

    @ip_address_block_lists.setter
    def ip_address_block_lists(self, value: pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]]):
        pulumi.set(self, "ip_address_block_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AddressGroupState:
    def __init__(__self__, *,
                 address_group_string: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroup resources.
        :param pulumi.Input[_builtins.str] address_group_string: - (ReadOnly) Address Group string
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]] ip_address_block_lists: - (Required) list of IP address blocks with their prefix length
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        """
        if address_group_string is not None:
            pulumi.set(__self__, "address_group_string", address_group_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address_block_lists is not None:
            pulumi.set(__self__, "ip_address_block_lists", ip_address_block_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="addressGroupString")
    def address_group_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (ReadOnly) Address Group string
        """
        return pulumi.get(self, "address_group_string")

    @address_group_string.setter
    def address_group_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_group_string", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressBlockLists")
    def ip_address_block_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]]]:
        """
        - (Required) list of IP address blocks with their prefix length
        """
        return pulumi.get(self, "ip_address_block_lists")

    @ip_address_block_lists.setter
    def ip_address_block_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpAddressBlockListArgs']]]]):
        pulumi.set(self, "ip_address_block_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("nutanix:index/addressGroup:AddressGroup")
class AddressGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpAddressBlockListArgs', 'AddressGroupIpAddressBlockListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a address group based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test_address = nutanix.AddressGroup("test_address",
            name="test",
            description="test address groups resource",
            ip_address_block_lists=[{
                "ip": "10.0.0.0",
                "prefix_length": 24,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpAddressBlockListArgs', 'AddressGroupIpAddressBlockListArgsDict']]]] ip_address_block_lists: - (Required) list of IP address blocks with their prefix length
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a address group based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test_address = nutanix.AddressGroup("test_address",
            name="test",
            description="test address groups resource",
            ip_address_block_lists=[{
                "ip": "10.0.0.0",
                "prefix_length": 24,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpAddressBlockListArgs', 'AddressGroupIpAddressBlockListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupArgs.__new__(AddressGroupArgs)

            __props__.__dict__["description"] = description
            if ip_address_block_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address_block_lists'")
            __props__.__dict__["ip_address_block_lists"] = ip_address_block_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["address_group_string"] = None
        super(AddressGroup, __self__).__init__(
            'nutanix:index/addressGroup:AddressGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_group_string: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpAddressBlockListArgs', 'AddressGroupIpAddressBlockListArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddressGroup':
        """
        Get an existing AddressGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_group_string: - (ReadOnly) Address Group string
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpAddressBlockListArgs', 'AddressGroupIpAddressBlockListArgsDict']]]] ip_address_block_lists: - (Required) list of IP address blocks with their prefix length
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupState.__new__(_AddressGroupState)

        __props__.__dict__["address_group_string"] = address_group_string
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address_block_lists"] = ip_address_block_lists
        __props__.__dict__["name"] = name
        return AddressGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressGroupString")
    def address_group_string(self) -> pulumi.Output[_builtins.str]:
        """
        - (ReadOnly) Address Group string
        """
        return pulumi.get(self, "address_group_string")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipAddressBlockLists")
    def ip_address_block_lists(self) -> pulumi.Output[Sequence['outputs.AddressGroupIpAddressBlockList']]:
        """
        - (Required) list of IP address blocks with their prefix length
        """
        return pulumi.get(self, "ip_address_block_lists")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

