# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizationPolicyV2Args', 'AuthorizationPolicyV2']

@pulumi.input_type
class AuthorizationPolicyV2Args:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 entities: pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]],
                 identities: pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]],
                 role: pulumi.Input[_builtins.str],
                 authorization_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthorizationPolicyV2 resource.
        :param pulumi.Input[_builtins.str] display_name: Name of the Authorization Policy.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]] entities: The entities being qualified by the Authorization Policy.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]] identities: The identities for which the Authorization Policy is created.
        :param pulumi.Input[_builtins.str] role: The Role associated with the Authorization Policy.
        :param pulumi.Input[_builtins.str] authorization_policy_type: Type of Authorization Policy.
               * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
               * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
               * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
               * `SERVICE_DEFINED` : ACP defined by a service.
               * `USER_DEFINED` : ACP defined by an User.
        :param pulumi.Input[_builtins.str] description: Description of the Authorization Policy.
        :param pulumi.Input[_builtins.str] ext_id: ext_id of Authorization policy.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entities", entities)
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "role", role)
        if authorization_policy_type is not None:
            pulumi.set(__self__, "authorization_policy_type", authorization_policy_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Authorization Policy.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]]:
        """
        The entities being qualified by the Authorization Policy.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter
    def identities(self) -> pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]]:
        """
        The identities for which the Authorization Policy is created.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]]):
        pulumi.set(self, "identities", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The Role associated with the Authorization Policy.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="authorizationPolicyType")
    def authorization_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Authorization Policy.
        * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
        * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
        * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
        * `SERVICE_DEFINED` : ACP defined by a service.
        * `USER_DEFINED` : ACP defined by an User.
        """
        return pulumi.get(self, "authorization_policy_type")

    @authorization_policy_type.setter
    def authorization_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Authorization Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ext_id of Authorization policy.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)


@pulumi.input_type
class _AuthorizationPolicyV2State:
    def __init__(__self__, *,
                 authorization_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]]] = None,
                 is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationPolicyV2 resources.
        :param pulumi.Input[_builtins.str] authorization_policy_type: Type of Authorization Policy.
               * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
               * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
               * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
               * `SERVICE_DEFINED` : ACP defined by a service.
               * `USER_DEFINED` : ACP defined by an User.
        :param pulumi.Input[_builtins.str] client_name: Client that created the entity.
        :param pulumi.Input[_builtins.str] created_by: User or Service Name that created the Authorization Policy.
        :param pulumi.Input[_builtins.str] created_time: The creation time of the Authorization Policy.
        :param pulumi.Input[_builtins.str] description: Description of the Authorization Policy.
        :param pulumi.Input[_builtins.str] display_name: Name of the Authorization Policy.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]] entities: The entities being qualified by the Authorization Policy.
        :param pulumi.Input[_builtins.str] ext_id: ext_id of Authorization policy.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]] identities: The identities for which the Authorization Policy is created.
        :param pulumi.Input[_builtins.bool] is_system_defined: Flag identifying if the Authorization Policy is system defined or not.
        :param pulumi.Input[_builtins.str] last_updated_time: The time when the Authorization Policy was last updated.
        :param pulumi.Input[_builtins.str] role: The Role associated with the Authorization Policy.
        """
        if authorization_policy_type is not None:
            pulumi.set(__self__, "authorization_policy_type", authorization_policy_type)
        if client_name is not None:
            pulumi.set(__self__, "client_name", client_name)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if is_system_defined is not None:
            pulumi.set(__self__, "is_system_defined", is_system_defined)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="authorizationPolicyType")
    def authorization_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Authorization Policy.
        * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
        * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
        * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
        * `SERVICE_DEFINED` : ACP defined by a service.
        * `USER_DEFINED` : ACP defined by an User.
        """
        return pulumi.get(self, "authorization_policy_type")

    @authorization_policy_type.setter
    def authorization_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_policy_type", value)

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_name", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User or Service Name that created the Authorization Policy.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the Authorization Policy.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Authorization Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Authorization Policy.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]]]:
        """
        The entities being qualified by the Authorization Policy.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2EntityArgs']]]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ext_id of Authorization policy.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]]]:
        """
        The identities for which the Authorization Policy is created.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationPolicyV2IdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag identifying if the Authorization Policy is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @is_system_defined.setter
    def is_system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_defined", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the Authorization Policy was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Role associated with the Authorization Policy.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("nutanix:index/authorizationPolicyV2:AuthorizationPolicyV2")
class AuthorizationPolicyV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2EntityArgs', 'AuthorizationPolicyV2EntityArgsDict']]]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2IdentityArgs', 'AuthorizationPolicyV2IdentityArgsDict']]]]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create authorization policy.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        ap_example = nutanix.AuthorizationPolicyV2("ap-example",
            role="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            display_name="auth_policy_example",
            description="authorization policy example",
            authorization_policy_type="USER_DEFINED",
            identities=[{
                "reserved": "{\\"user\\":{\\"uuid\\":{\\"anyof\\":[\\"00000000-0000-0000-0000-000000000000\\"]}}}",
            }],
            entities=[
                {
                    "reserved": "{\\"images\\":{\\"*\\":{\\"eq\\":\\"*\\"}}}",
                },
                {
                    "reserved": "{\\"marketplace_item\\":{\\"owner_uuid\\":{\\"eq\\":\\"SELF_OWNED\\"}}}",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_policy_type: Type of Authorization Policy.
               * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
               * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
               * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
               * `SERVICE_DEFINED` : ACP defined by a service.
               * `USER_DEFINED` : ACP defined by an User.
        :param pulumi.Input[_builtins.str] description: Description of the Authorization Policy.
        :param pulumi.Input[_builtins.str] display_name: Name of the Authorization Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2EntityArgs', 'AuthorizationPolicyV2EntityArgsDict']]]] entities: The entities being qualified by the Authorization Policy.
        :param pulumi.Input[_builtins.str] ext_id: ext_id of Authorization policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2IdentityArgs', 'AuthorizationPolicyV2IdentityArgsDict']]]] identities: The identities for which the Authorization Policy is created.
        :param pulumi.Input[_builtins.str] role: The Role associated with the Authorization Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizationPolicyV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create authorization policy.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        ap_example = nutanix.AuthorizationPolicyV2("ap-example",
            role="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            display_name="auth_policy_example",
            description="authorization policy example",
            authorization_policy_type="USER_DEFINED",
            identities=[{
                "reserved": "{\\"user\\":{\\"uuid\\":{\\"anyof\\":[\\"00000000-0000-0000-0000-000000000000\\"]}}}",
            }],
            entities=[
                {
                    "reserved": "{\\"images\\":{\\"*\\":{\\"eq\\":\\"*\\"}}}",
                },
                {
                    "reserved": "{\\"marketplace_item\\":{\\"owner_uuid\\":{\\"eq\\":\\"SELF_OWNED\\"}}}",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationPolicyV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationPolicyV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2EntityArgs', 'AuthorizationPolicyV2EntityArgsDict']]]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2IdentityArgs', 'AuthorizationPolicyV2IdentityArgsDict']]]]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationPolicyV2Args.__new__(AuthorizationPolicyV2Args)

            __props__.__dict__["authorization_policy_type"] = authorization_policy_type
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if entities is None and not opts.urn:
                raise TypeError("Missing required property 'entities'")
            __props__.__dict__["entities"] = entities
            __props__.__dict__["ext_id"] = ext_id
            if identities is None and not opts.urn:
                raise TypeError("Missing required property 'identities'")
            __props__.__dict__["identities"] = identities
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["client_name"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["is_system_defined"] = None
            __props__.__dict__["last_updated_time"] = None
        super(AuthorizationPolicyV2, __self__).__init__(
            'nutanix:index/authorizationPolicyV2:AuthorizationPolicyV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            client_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2EntityArgs', 'AuthorizationPolicyV2EntityArgsDict']]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2IdentityArgs', 'AuthorizationPolicyV2IdentityArgsDict']]]]] = None,
            is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthorizationPolicyV2':
        """
        Get an existing AuthorizationPolicyV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_policy_type: Type of Authorization Policy.
               * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
               * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
               * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
               * `SERVICE_DEFINED` : ACP defined by a service.
               * `USER_DEFINED` : ACP defined by an User.
        :param pulumi.Input[_builtins.str] client_name: Client that created the entity.
        :param pulumi.Input[_builtins.str] created_by: User or Service Name that created the Authorization Policy.
        :param pulumi.Input[_builtins.str] created_time: The creation time of the Authorization Policy.
        :param pulumi.Input[_builtins.str] description: Description of the Authorization Policy.
        :param pulumi.Input[_builtins.str] display_name: Name of the Authorization Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2EntityArgs', 'AuthorizationPolicyV2EntityArgsDict']]]] entities: The entities being qualified by the Authorization Policy.
        :param pulumi.Input[_builtins.str] ext_id: ext_id of Authorization policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationPolicyV2IdentityArgs', 'AuthorizationPolicyV2IdentityArgsDict']]]] identities: The identities for which the Authorization Policy is created.
        :param pulumi.Input[_builtins.bool] is_system_defined: Flag identifying if the Authorization Policy is system defined or not.
        :param pulumi.Input[_builtins.str] last_updated_time: The time when the Authorization Policy was last updated.
        :param pulumi.Input[_builtins.str] role: The Role associated with the Authorization Policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationPolicyV2State.__new__(_AuthorizationPolicyV2State)

        __props__.__dict__["authorization_policy_type"] = authorization_policy_type
        __props__.__dict__["client_name"] = client_name
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entities"] = entities
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["identities"] = identities
        __props__.__dict__["is_system_defined"] = is_system_defined
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["role"] = role
        return AuthorizationPolicyV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationPolicyType")
    def authorization_policy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of Authorization Policy.
        * `PREDEFINED_READ_ONLY` : System-defined read-only ACP, i.e. no modifications allowed.
        * `SERVICE_DEFINED_READ_ONLY` : Read-only ACP defined by a service.
        * `PREDEFINED_UPDATE_IDENTITY_ONLY` : System-defined ACP prohibiting any modifications from customer.
        * `SERVICE_DEFINED` : ACP defined by a service.
        * `USER_DEFINED` : ACP defined by an User.
        """
        return pulumi.get(self, "authorization_policy_type")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> pulumi.Output[_builtins.str]:
        """
        Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        User or Service Name that created the Authorization Policy.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the Authorization Policy.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the Authorization Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Authorization Policy.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> pulumi.Output[Sequence['outputs.AuthorizationPolicyV2Entity']]:
        """
        The entities being qualified by the Authorization Policy.
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        ext_id of Authorization policy.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Sequence['outputs.AuthorizationPolicyV2Identity']]:
        """
        The identities for which the Authorization Policy is created.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag identifying if the Authorization Policy is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the Authorization Policy was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The Role associated with the Authorization Policy.
        """
        return pulumi.get(self, "role")

