# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CategoryKeyArgs', 'CategoryKey']

@pulumi.input_type
class CategoryKeyArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CategoryKey resource.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for category key.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the category key.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for category key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the category key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CategoryKeyState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_defined: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering CategoryKey resources.
        :param pulumi.Input[_builtins.str] api_version: (Optional) The version of the API.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for category key.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the category key.
        :param pulumi.Input[_builtins.bool] system_defined: - Specifying whether its a system defined category.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if system_defined is not None:
            pulumi.set(__self__, "system_defined", system_defined)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional) The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for category key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the category key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="systemDefined")
    def system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Specifying whether its a system defined category.
        """
        return pulumi.get(self, "system_defined")

    @system_defined.setter
    def system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_defined", value)


@pulumi.type_token("nutanix:index/categoryKey:CategoryKey")
class CategoryKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Nutanix Category key resource to Create a category key name.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.CategoryKey("test",
            name="app-support-example",
            description="App Support Category Key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for category key.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the category key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CategoryKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Category key resource to Create a category key name.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.CategoryKey("test",
            name="app-support-example",
            description="App Support Category Key")
        ```

        :param str resource_name: The name of the resource.
        :param CategoryKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CategoryKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CategoryKeyArgs.__new__(CategoryKeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["api_version"] = None
            __props__.__dict__["system_defined"] = None
        super(CategoryKey, __self__).__init__(
            'nutanix:index/categoryKey:CategoryKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            system_defined: Optional[pulumi.Input[_builtins.bool]] = None) -> 'CategoryKey':
        """
        Get an existing CategoryKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: (Optional) The version of the API.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for category key.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the category key.
        :param pulumi.Input[_builtins.bool] system_defined: - Specifying whether its a system defined category.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CategoryKeyState.__new__(_CategoryKeyState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["system_defined"] = system_defined
        return CategoryKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional) The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) A description for category key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name for the category key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="systemDefined")
    def system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        - Specifying whether its a system defined category.
        """
        return pulumi.get(self, "system_defined")

