# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CategoryV2Args', 'CategoryV2']

@pulumi.input_type
class CategoryV2Args:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CategoryV2 resource.
        :param pulumi.Input[_builtins.str] key: -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
        :param pulumi.Input[_builtins.str] value: -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
               Updating the value will not change the extId of the category.
        :param pulumi.Input[_builtins.str] description: -(Optional) A string consisting of the description of the category as defined by the user.
               Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
               Description field can be updated through updateCategoryById API.
               The server does not validate this value nor does it enforce the uniqueness or any other constraints.
               It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        :param pulumi.Input[_builtins.str] owner_uuid: -(Optional) This field contains the UUID of a user who owns the category.
               This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
               This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
               Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
               It is used for enabling RBAC access to self-owned categories.
        :param pulumi.Input[_builtins.str] type: -(Required) Denotes the type of a category.
               Valid values are:
               - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
               - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
               - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner_uuid is not None:
            pulumi.set(__self__, "owner_uuid", owner_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        Updating the value will not change the extId of the category.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A string consisting of the description of the category as defined by the user.
        Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
        Description field can be updated through updateCategoryById API.
        The server does not validate this value nor does it enforce the uniqueness or any other constraints.
        It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) This field contains the UUID of a user who owns the category.
        This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
        This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
        Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
        It is used for enabling RBAC access to self-owned categories.
        """
        return pulumi.get(self, "owner_uuid")

    @owner_uuid.setter
    def owner_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_uuid", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Denotes the type of a category.
        Valid values are:
        - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
        - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
        - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _CategoryV2State:
    def __init__(__self__, *,
                 associations: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2AssociationArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detailed_associations: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2DetailedAssociationArgs']]]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CategoryV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['CategoryV2AssociationArgs']]] associations: This field gives basic information about resources that are associated with the category.
               The results present under this field summarize the counts of various kinds of resources associated with the category.
               For more detailed information about the UUIDs of the resources, please look into the field detailedAssociations.
               This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
               This field will not be present by default in listCategories API, unless the parameter $expand=associations is present in the URL.
        :param pulumi.Input[_builtins.str] description: -(Optional) A string consisting of the description of the category as defined by the user.
               Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
               Description field can be updated through updateCategoryById API.
               The server does not validate this value nor does it enforce the uniqueness or any other constraints.
               It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        :param pulumi.Input[Sequence[pulumi.Input['CategoryV2DetailedAssociationArgs']]] detailed_associations: This field gives detailed information about the resources which are associated with the category.
               The results present under this field contain the UUIDs of the entities and policies of various kinds associated with the category.
               This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
               This field will not be present by default in listCategories or getCategoryById APIs, unless the parameter $expand=detailedAssociations is present in the URL.
        :param pulumi.Input[_builtins.str] key: -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
        :param pulumi.Input[_builtins.str] owner_uuid: -(Optional) This field contains the UUID of a user who owns the category.
               This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
               This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
               Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
               It is used for enabling RBAC access to self-owned categories.
        :param pulumi.Input[_builtins.str] type: -(Required) Denotes the type of a category.
               Valid values are:
               - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
               - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
               - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        :param pulumi.Input[_builtins.str] value: -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
               Updating the value will not change the extId of the category.
        """
        if associations is not None:
            pulumi.set(__self__, "associations", associations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detailed_associations is not None:
            pulumi.set(__self__, "detailed_associations", detailed_associations)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if owner_uuid is not None:
            pulumi.set(__self__, "owner_uuid", owner_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2AssociationArgs']]]]:
        """
        This field gives basic information about resources that are associated with the category.
        The results present under this field summarize the counts of various kinds of resources associated with the category.
        For more detailed information about the UUIDs of the resources, please look into the field detailedAssociations.
        This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
        This field will not be present by default in listCategories API, unless the parameter $expand=associations is present in the URL.
        """
        return pulumi.get(self, "associations")

    @associations.setter
    def associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2AssociationArgs']]]]):
        pulumi.set(self, "associations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A string consisting of the description of the category as defined by the user.
        Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
        Description field can be updated through updateCategoryById API.
        The server does not validate this value nor does it enforce the uniqueness or any other constraints.
        It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detailedAssociations")
    def detailed_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2DetailedAssociationArgs']]]]:
        """
        This field gives detailed information about the resources which are associated with the category.
        The results present under this field contain the UUIDs of the entities and policies of various kinds associated with the category.
        This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
        This field will not be present by default in listCategories or getCategoryById APIs, unless the parameter $expand=detailedAssociations is present in the URL.
        """
        return pulumi.get(self, "detailed_associations")

    @detailed_associations.setter
    def detailed_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryV2DetailedAssociationArgs']]]]):
        pulumi.set(self, "detailed_associations", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) This field contains the UUID of a user who owns the category.
        This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
        This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
        Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
        It is used for enabling RBAC access to self-owned categories.
        """
        return pulumi.get(self, "owner_uuid")

    @owner_uuid.setter
    def owner_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_uuid", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Denotes the type of a category.
        Valid values are:
        - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
        - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
        - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        Updating the value will not change the extId of the category.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("nutanix:index/categoryV2:CategoryV2")
class CategoryV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Fetch a category

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.CategoryV2("example",
            key="category_example_key",
            value="category_example_value",
            description="category example description")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: -(Optional) A string consisting of the description of the category as defined by the user.
               Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
               Description field can be updated through updateCategoryById API.
               The server does not validate this value nor does it enforce the uniqueness or any other constraints.
               It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        :param pulumi.Input[_builtins.str] key: -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
        :param pulumi.Input[_builtins.str] owner_uuid: -(Optional) This field contains the UUID of a user who owns the category.
               This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
               This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
               Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
               It is used for enabling RBAC access to self-owned categories.
        :param pulumi.Input[_builtins.str] type: -(Required) Denotes the type of a category.
               Valid values are:
               - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
               - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
               - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        :param pulumi.Input[_builtins.str] value: -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
               Updating the value will not change the extId of the category.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CategoryV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Fetch a category

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.CategoryV2("example",
            key="category_example_key",
            value="category_example_value",
            description="category example description")
        ```

        :param str resource_name: The name of the resource.
        :param CategoryV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CategoryV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CategoryV2Args.__new__(CategoryV2Args)

            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["owner_uuid"] = owner_uuid
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["associations"] = None
            __props__.__dict__["detailed_associations"] = None
        super(CategoryV2, __self__).__init__(
            'nutanix:index/categoryV2:CategoryV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CategoryV2AssociationArgs', 'CategoryV2AssociationArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detailed_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CategoryV2DetailedAssociationArgs', 'CategoryV2DetailedAssociationArgsDict']]]]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            owner_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'CategoryV2':
        """
        Get an existing CategoryV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CategoryV2AssociationArgs', 'CategoryV2AssociationArgsDict']]]] associations: This field gives basic information about resources that are associated with the category.
               The results present under this field summarize the counts of various kinds of resources associated with the category.
               For more detailed information about the UUIDs of the resources, please look into the field detailedAssociations.
               This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
               This field will not be present by default in listCategories API, unless the parameter $expand=associations is present in the URL.
        :param pulumi.Input[_builtins.str] description: -(Optional) A string consisting of the description of the category as defined by the user.
               Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
               Description field can be updated through updateCategoryById API.
               The server does not validate this value nor does it enforce the uniqueness or any other constraints.
               It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CategoryV2DetailedAssociationArgs', 'CategoryV2DetailedAssociationArgsDict']]]] detailed_associations: This field gives detailed information about the resources which are associated with the category.
               The results present under this field contain the UUIDs of the entities and policies of various kinds associated with the category.
               This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
               This field will not be present by default in listCategories or getCategoryById APIs, unless the parameter $expand=detailedAssociations is present in the URL.
        :param pulumi.Input[_builtins.str] key: -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
        :param pulumi.Input[_builtins.str] owner_uuid: -(Optional) This field contains the UUID of a user who owns the category.
               This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
               This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
               Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
               It is used for enabling RBAC access to self-owned categories.
        :param pulumi.Input[_builtins.str] type: -(Required) Denotes the type of a category.
               Valid values are:
               - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
               - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
               - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        :param pulumi.Input[_builtins.str] value: -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:
               
               - A string of maxlength of 64
               - Character at the start cannot be `$`
               - Character `/` is not allowed anywhere.
               
               It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
               This field can't be updated through `updateCategoryById` API.
               Updating the value will not change the extId of the category.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CategoryV2State.__new__(_CategoryV2State)

        __props__.__dict__["associations"] = associations
        __props__.__dict__["description"] = description
        __props__.__dict__["detailed_associations"] = detailed_associations
        __props__.__dict__["key"] = key
        __props__.__dict__["owner_uuid"] = owner_uuid
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return CategoryV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> pulumi.Output[Sequence['outputs.CategoryV2Association']]:
        """
        This field gives basic information about resources that are associated with the category.
        The results present under this field summarize the counts of various kinds of resources associated with the category.
        For more detailed information about the UUIDs of the resources, please look into the field detailedAssociations.
        This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
        This field will not be present by default in listCategories API, unless the parameter $expand=associations is present in the URL.
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) A string consisting of the description of the category as defined by the user.
        Description can be optionally provided in the payload of createCategory and updateCategoryById APIs.
        Description field can be updated through updateCategoryById API.
        The server does not validate this value nor does it enforce the uniqueness or any other constraints.
        It is the responsibility of the user to ensure that any semantic or syntactic constraints are retained when mutating this field.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detailedAssociations")
    def detailed_associations(self) -> pulumi.Output[Sequence['outputs.CategoryV2DetailedAssociation']]:
        """
        This field gives detailed information about the resources which are associated with the category.
        The results present under this field contain the UUIDs of the entities and policies of various kinds associated with the category.
        This field will be ignored, if given in the payload of updateCategoryById or createCategory APIs.
        This field will not be present by default in listCategories or getCategoryById APIs, unless the parameter $expand=detailedAssociations is present in the URL.
        """
        return pulumi.get(self, "detailed_associations")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The key of a category when it is represented in key:value format. Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) This field contains the UUID of a user who owns the category.
        This field will be ignored if given in the payload of createCategory API. Hence, when a category is created, the logged-in user automatically becomes the owner of the category.
        This field can be updated through updateCategoryById API, in which case, should be provided, UUID of a valid user is present in the system.
        Validity of the user UUID can be checked by invoking the API: authn/users/{extId} in the 'Identity and Access Management' or 'IAM' namespace.
        It is used for enabling RBAC access to self-owned categories.
        """
        return pulumi.get(self, "owner_uuid")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Denotes the type of a category.
        Valid values are:
        - `SYSTEM` Predefined categories contained in the system to be used by workflows visible in the UI that involve categories. System-defined categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. System-defined categories can't be updated or deleted.
        - `INTERNAL` Predefined categories contained in the system to be used by internal services, APIs and workflows that involve categories. These categories will not be visible in the UI. However, these categories will be returned in the response of `listCategories` and `getCategoryById` APIs, and are available for filtering as well. Internal categories can't be created through the Categories API. They are predefined in a configuration file and are created at PC boot-up time. Internal categories can't be updated or deleted.
        - `USER` These categories get created by users through the invocation of `createCategory` API. User-defined categories can be updated or deleted after creation.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The value of a category when it is represented in key:value format.  Constraints applicable when field is given in the payload during create and update:

        - A string of maxlength of 64
        - Character at the start cannot be `$`
        - Character `/` is not allowed anywhere.

        It is a mandatory field in the payload of `createCategory` and `updateCategoryById` APIs.
        This field can't be updated through `updateCategoryById` API.
        Updating the value will not change the extId of the category.
        """
        return pulumi.get(self, "value")

