# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterAddNodeV2Args', 'ClusterAddNodeV2']

@pulumi.input_type
class ClusterAddNodeV2Args:
    def __init__(__self__, *,
                 cluster_ext_id: pulumi.Input[_builtins.str],
                 node_params: pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]],
                 config_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]] = None,
                 remove_node_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]] = None,
                 should_skip_add_node: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_skip_pre_expand_checks: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ClusterAddNodeV2 resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]] node_params: -(Required) Parameters of the node to be added.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]] config_params: -(Optional) Config parameters.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]] remove_node_params: -(Optional) configuration for node removal.
        :param pulumi.Input[_builtins.bool] should_skip_add_node: -(Optional) Indicates if node addition can be skipped.
        :param pulumi.Input[_builtins.bool] should_skip_pre_expand_checks: -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        pulumi.set(__self__, "node_params", node_params)
        if config_params is not None:
            pulumi.set(__self__, "config_params", config_params)
        if remove_node_params is not None:
            pulumi.set(__self__, "remove_node_params", remove_node_params)
        if should_skip_add_node is not None:
            pulumi.set(__self__, "should_skip_add_node", should_skip_add_node)
        if should_skip_pre_expand_checks is not None:
            pulumi.set(__self__, "should_skip_pre_expand_checks", should_skip_pre_expand_checks)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeParams")
    def node_params(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]]:
        """
        -(Required) Parameters of the node to be added.
        """
        return pulumi.get(self, "node_params")

    @node_params.setter
    def node_params(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]]):
        pulumi.set(self, "node_params", value)

    @_builtins.property
    @pulumi.getter(name="configParams")
    def config_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]]:
        """
        -(Optional) Config parameters.
        """
        return pulumi.get(self, "config_params")

    @config_params.setter
    def config_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]]):
        pulumi.set(self, "config_params", value)

    @_builtins.property
    @pulumi.getter(name="removeNodeParams")
    def remove_node_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]]:
        """
        -(Optional) configuration for node removal.
        """
        return pulumi.get(self, "remove_node_params")

    @remove_node_params.setter
    def remove_node_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]]):
        pulumi.set(self, "remove_node_params", value)

    @_builtins.property
    @pulumi.getter(name="shouldSkipAddNode")
    def should_skip_add_node(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates if node addition can be skipped.
        """
        return pulumi.get(self, "should_skip_add_node")

    @should_skip_add_node.setter
    def should_skip_add_node(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_skip_add_node", value)

    @_builtins.property
    @pulumi.getter(name="shouldSkipPreExpandChecks")
    def should_skip_pre_expand_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        return pulumi.get(self, "should_skip_pre_expand_checks")

    @should_skip_pre_expand_checks.setter
    def should_skip_pre_expand_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_skip_pre_expand_checks", value)


@pulumi.input_type
class _ClusterAddNodeV2State:
    def __init__(__self__, *,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]] = None,
                 node_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]]] = None,
                 remove_node_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]] = None,
                 should_skip_add_node: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_skip_pre_expand_checks: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ClusterAddNodeV2 resources.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]] config_params: -(Optional) Config parameters.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]] node_params: -(Required) Parameters of the node to be added.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]] remove_node_params: -(Optional) configuration for node removal.
        :param pulumi.Input[_builtins.bool] should_skip_add_node: -(Optional) Indicates if node addition can be skipped.
        :param pulumi.Input[_builtins.bool] should_skip_pre_expand_checks: -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if config_params is not None:
            pulumi.set(__self__, "config_params", config_params)
        if node_params is not None:
            pulumi.set(__self__, "node_params", node_params)
        if remove_node_params is not None:
            pulumi.set(__self__, "remove_node_params", remove_node_params)
        if should_skip_add_node is not None:
            pulumi.set(__self__, "should_skip_add_node", should_skip_add_node)
        if should_skip_pre_expand_checks is not None:
            pulumi.set(__self__, "should_skip_pre_expand_checks", should_skip_pre_expand_checks)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="configParams")
    def config_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]]:
        """
        -(Optional) Config parameters.
        """
        return pulumi.get(self, "config_params")

    @config_params.setter
    def config_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2ConfigParamArgs']]]]):
        pulumi.set(self, "config_params", value)

    @_builtins.property
    @pulumi.getter(name="nodeParams")
    def node_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]]]:
        """
        -(Required) Parameters of the node to be added.
        """
        return pulumi.get(self, "node_params")

    @node_params.setter
    def node_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2NodeParamArgs']]]]):
        pulumi.set(self, "node_params", value)

    @_builtins.property
    @pulumi.getter(name="removeNodeParams")
    def remove_node_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]]:
        """
        -(Optional) configuration for node removal.
        """
        return pulumi.get(self, "remove_node_params")

    @remove_node_params.setter
    def remove_node_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAddNodeV2RemoveNodeParamArgs']]]]):
        pulumi.set(self, "remove_node_params", value)

    @_builtins.property
    @pulumi.getter(name="shouldSkipAddNode")
    def should_skip_add_node(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates if node addition can be skipped.
        """
        return pulumi.get(self, "should_skip_add_node")

    @should_skip_add_node.setter
    def should_skip_add_node(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_skip_add_node", value)

    @_builtins.property
    @pulumi.getter(name="shouldSkipPreExpandChecks")
    def should_skip_pre_expand_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        return pulumi.get(self, "should_skip_pre_expand_checks")

    @should_skip_pre_expand_checks.setter
    def should_skip_pre_expand_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_skip_pre_expand_checks", value)


@pulumi.type_token("nutanix:index/clusterAddNodeV2:ClusterAddNodeV2")
class ClusterAddNodeV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2ConfigParamArgs', 'ClusterAddNodeV2ConfigParamArgsDict']]]]] = None,
                 node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2NodeParamArgs', 'ClusterAddNodeV2NodeParamArgsDict']]]]] = None,
                 remove_node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2RemoveNodeParamArgs', 'ClusterAddNodeV2RemoveNodeParamArgsDict']]]]] = None,
                 should_skip_add_node: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_skip_pre_expand_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Add node on a cluster identified by {extId}.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # cluster of 3 node uuid that we want to add node
        clusters_ext_id = "00057b8b-0b3b-4b3b-0000-000000000000"
        # for example
        cvm_ip = "10.xx.xx.xx"
        ## check if the node to add is un configured or not
        cluster_node = nutanix.ClustersDiscoverUnconfiguredNodesV2("cluster-node",
            ext_id=clusters_ext_id,
            address_type="IPV4",
            ip_filter_lists=[{
                "ipv4s": [{
                    "value": cvm_ip,
                }],
            }])
        ## fetch Network info for unconfigured node
        node_network_info = nutanix.ClustersUnconfiguredNodeNetworksV2("node-network-info",
            ext_id=clusters_ext_id,
            request_type="expand_cluster",
            node_lists=[{
                "cvm_ips": [{
                    "ipv4s": [{
                        "value": cvm_ip,
                    }],
                }],
                "hypervisor_ips": [{
                    "ipv4s": [{
                        "value": cluster_node.unconfigured_nodes[0].hypervisor_ips[0].ipv4s[0].value,
                    }],
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[cluster_node]))
        ## add node to the cluster
        add_node = nutanix.ClusterAddNodeV2("add-node",
            cluster_ext_id=clusters_ext_id,
            should_skip_add_node=False,
            should_skip_pre_expand_checks=False,
            node_params=[{
                "should_skip_host_networking": False,
                "hypervisor_isos": [{
                    "type": cluster_node.unconfigured_nodes[0].hypervisor_type,
                }],
                "node_lists": [{
                    "node_uuid": cluster_node.unconfigured_nodes[0].node_uuid,
                    "model": cluster_node.unconfigured_nodes[0].rackable_unit_model,
                    "block_id": cluster_node.unconfigured_nodes[0].rackable_unit_serial,
                    "hypervisor_type": cluster_node.unconfigured_nodes[0].hypervisor_type,
                    "hypervisor_version": cluster_node.unconfigured_nodes[0].hypervisor_version,
                    "node_position": cluster_node.unconfigured_nodes[0].node_position,
                    "nos_version": cluster_node.unconfigured_nodes[0].nos_version,
                    "hypervisor_hostname": "example",
                    "current_network_interface": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                    "hypervisor_ips": [{
                        "ipv4s": [{
                            "value": cluster_node.unconfigured_nodes[0].hypervisor_ips[0].ipv4s[0].value,
                        }],
                    }],
                    "cvm_ips": [{
                        "ipv4s": [{
                            "value": cvm_ip,
                        }],
                    }],
                    "ipmi_ips": [{
                        "ipv4s": [{
                            "value": cluster_node.unconfigured_nodes[0].ipmi_ips[0].ipv4s[0].value,
                        }],
                    }],
                    "is_robo_mixed_hypervisor": True,
                    "networks": [{
                        "name": node_network_info.nodes_networking_details[0].network_infos[0].hcis[0].name,
                        "networks": node_network_info.nodes_networking_details[0].network_infos[0].hcis[0].networks,
                        "uplinks": [{
                            "actives": [{
                                "name": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                                "mac": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].mac,
                                "value": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                            }],
                            "standbies": [{
                                "name": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].name,
                                "mac": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].mac,
                                "value": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].name,
                            }],
                        }],
                    }],
                }],
            }],
            config_params=[{
                "should_skip_imaging": True,
                "target_hypervisor": cluster_node.unconfigured_nodes[0].hypervisor_type,
            }],
            remove_node_params=[{
                "extra_params": [{
                    "should_skip_upgrade_check": False,
                    "skip_space_check": False,
                    "should_skip_add_check": False,
                }],
                "should_skip_remove": False,
                "should_skip_prechecks": False,
            }],
            opts = pulumi.ResourceOptions(depends_on=[node_network_info]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2ConfigParamArgs', 'ClusterAddNodeV2ConfigParamArgsDict']]]] config_params: -(Optional) Config parameters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2NodeParamArgs', 'ClusterAddNodeV2NodeParamArgsDict']]]] node_params: -(Required) Parameters of the node to be added.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2RemoveNodeParamArgs', 'ClusterAddNodeV2RemoveNodeParamArgsDict']]]] remove_node_params: -(Optional) configuration for node removal.
        :param pulumi.Input[_builtins.bool] should_skip_add_node: -(Optional) Indicates if node addition can be skipped.
        :param pulumi.Input[_builtins.bool] should_skip_pre_expand_checks: -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterAddNodeV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Add node on a cluster identified by {extId}.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # cluster of 3 node uuid that we want to add node
        clusters_ext_id = "00057b8b-0b3b-4b3b-0000-000000000000"
        # for example
        cvm_ip = "10.xx.xx.xx"
        ## check if the node to add is un configured or not
        cluster_node = nutanix.ClustersDiscoverUnconfiguredNodesV2("cluster-node",
            ext_id=clusters_ext_id,
            address_type="IPV4",
            ip_filter_lists=[{
                "ipv4s": [{
                    "value": cvm_ip,
                }],
            }])
        ## fetch Network info for unconfigured node
        node_network_info = nutanix.ClustersUnconfiguredNodeNetworksV2("node-network-info",
            ext_id=clusters_ext_id,
            request_type="expand_cluster",
            node_lists=[{
                "cvm_ips": [{
                    "ipv4s": [{
                        "value": cvm_ip,
                    }],
                }],
                "hypervisor_ips": [{
                    "ipv4s": [{
                        "value": cluster_node.unconfigured_nodes[0].hypervisor_ips[0].ipv4s[0].value,
                    }],
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[cluster_node]))
        ## add node to the cluster
        add_node = nutanix.ClusterAddNodeV2("add-node",
            cluster_ext_id=clusters_ext_id,
            should_skip_add_node=False,
            should_skip_pre_expand_checks=False,
            node_params=[{
                "should_skip_host_networking": False,
                "hypervisor_isos": [{
                    "type": cluster_node.unconfigured_nodes[0].hypervisor_type,
                }],
                "node_lists": [{
                    "node_uuid": cluster_node.unconfigured_nodes[0].node_uuid,
                    "model": cluster_node.unconfigured_nodes[0].rackable_unit_model,
                    "block_id": cluster_node.unconfigured_nodes[0].rackable_unit_serial,
                    "hypervisor_type": cluster_node.unconfigured_nodes[0].hypervisor_type,
                    "hypervisor_version": cluster_node.unconfigured_nodes[0].hypervisor_version,
                    "node_position": cluster_node.unconfigured_nodes[0].node_position,
                    "nos_version": cluster_node.unconfigured_nodes[0].nos_version,
                    "hypervisor_hostname": "example",
                    "current_network_interface": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                    "hypervisor_ips": [{
                        "ipv4s": [{
                            "value": cluster_node.unconfigured_nodes[0].hypervisor_ips[0].ipv4s[0].value,
                        }],
                    }],
                    "cvm_ips": [{
                        "ipv4s": [{
                            "value": cvm_ip,
                        }],
                    }],
                    "ipmi_ips": [{
                        "ipv4s": [{
                            "value": cluster_node.unconfigured_nodes[0].ipmi_ips[0].ipv4s[0].value,
                        }],
                    }],
                    "is_robo_mixed_hypervisor": True,
                    "networks": [{
                        "name": node_network_info.nodes_networking_details[0].network_infos[0].hcis[0].name,
                        "networks": node_network_info.nodes_networking_details[0].network_infos[0].hcis[0].networks,
                        "uplinks": [{
                            "actives": [{
                                "name": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                                "mac": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].mac,
                                "value": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[0].name,
                            }],
                            "standbies": [{
                                "name": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].name,
                                "mac": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].mac,
                                "value": node_network_info.nodes_networking_details[0].uplinks[0].uplink_lists[1].name,
                            }],
                        }],
                    }],
                }],
            }],
            config_params=[{
                "should_skip_imaging": True,
                "target_hypervisor": cluster_node.unconfigured_nodes[0].hypervisor_type,
            }],
            remove_node_params=[{
                "extra_params": [{
                    "should_skip_upgrade_check": False,
                    "skip_space_check": False,
                    "should_skip_add_check": False,
                }],
                "should_skip_remove": False,
                "should_skip_prechecks": False,
            }],
            opts = pulumi.ResourceOptions(depends_on=[node_network_info]))
        ```

        :param str resource_name: The name of the resource.
        :param ClusterAddNodeV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterAddNodeV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2ConfigParamArgs', 'ClusterAddNodeV2ConfigParamArgsDict']]]]] = None,
                 node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2NodeParamArgs', 'ClusterAddNodeV2NodeParamArgsDict']]]]] = None,
                 remove_node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2RemoveNodeParamArgs', 'ClusterAddNodeV2RemoveNodeParamArgsDict']]]]] = None,
                 should_skip_add_node: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_skip_pre_expand_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterAddNodeV2Args.__new__(ClusterAddNodeV2Args)

            if cluster_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ext_id'")
            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            __props__.__dict__["config_params"] = config_params
            if node_params is None and not opts.urn:
                raise TypeError("Missing required property 'node_params'")
            __props__.__dict__["node_params"] = node_params
            __props__.__dict__["remove_node_params"] = remove_node_params
            __props__.__dict__["should_skip_add_node"] = should_skip_add_node
            __props__.__dict__["should_skip_pre_expand_checks"] = should_skip_pre_expand_checks
        super(ClusterAddNodeV2, __self__).__init__(
            'nutanix:index/clusterAddNodeV2:ClusterAddNodeV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2ConfigParamArgs', 'ClusterAddNodeV2ConfigParamArgsDict']]]]] = None,
            node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2NodeParamArgs', 'ClusterAddNodeV2NodeParamArgsDict']]]]] = None,
            remove_node_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2RemoveNodeParamArgs', 'ClusterAddNodeV2RemoveNodeParamArgsDict']]]]] = None,
            should_skip_add_node: Optional[pulumi.Input[_builtins.bool]] = None,
            should_skip_pre_expand_checks: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ClusterAddNodeV2':
        """
        Get an existing ClusterAddNodeV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2ConfigParamArgs', 'ClusterAddNodeV2ConfigParamArgsDict']]]] config_params: -(Optional) Config parameters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2NodeParamArgs', 'ClusterAddNodeV2NodeParamArgsDict']]]] node_params: -(Required) Parameters of the node to be added.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAddNodeV2RemoveNodeParamArgs', 'ClusterAddNodeV2RemoveNodeParamArgsDict']]]] remove_node_params: -(Optional) configuration for node removal.
        :param pulumi.Input[_builtins.bool] should_skip_add_node: -(Optional) Indicates if node addition can be skipped.
        :param pulumi.Input[_builtins.bool] should_skip_pre_expand_checks: -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterAddNodeV2State.__new__(_ClusterAddNodeV2State)

        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["config_params"] = config_params
        __props__.__dict__["node_params"] = node_params
        __props__.__dict__["remove_node_params"] = remove_node_params
        __props__.__dict__["should_skip_add_node"] = should_skip_add_node
        __props__.__dict__["should_skip_pre_expand_checks"] = should_skip_pre_expand_checks
        return ClusterAddNodeV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="configParams")
    def config_params(self) -> pulumi.Output[Sequence['outputs.ClusterAddNodeV2ConfigParam']]:
        """
        -(Optional) Config parameters.
        """
        return pulumi.get(self, "config_params")

    @_builtins.property
    @pulumi.getter(name="nodeParams")
    def node_params(self) -> pulumi.Output[Sequence['outputs.ClusterAddNodeV2NodeParam']]:
        """
        -(Required) Parameters of the node to be added.
        """
        return pulumi.get(self, "node_params")

    @_builtins.property
    @pulumi.getter(name="removeNodeParams")
    def remove_node_params(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterAddNodeV2RemoveNodeParam']]]:
        """
        -(Optional) configuration for node removal.
        """
        return pulumi.get(self, "remove_node_params")

    @_builtins.property
    @pulumi.getter(name="shouldSkipAddNode")
    def should_skip_add_node(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates if node addition can be skipped.
        """
        return pulumi.get(self, "should_skip_add_node")

    @_builtins.property
    @pulumi.getter(name="shouldSkipPreExpandChecks")
    def should_skip_pre_expand_checks(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates if pre-expand checks can be skipped for node addition.
        """
        return pulumi.get(self, "should_skip_pre_expand_checks")

