# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterV2Args', 'ClusterV2']

@pulumi.input_type
class ClusterV2Args:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dryrun: Optional[pulumi.Input[_builtins.bool]] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]] = None):
        """
        The set of arguments for constructing a ClusterV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]] configs: - (Optional) Cluster configuration details.
        :param pulumi.Input[_builtins.str] container_name: - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        :param pulumi.Input[_builtins.bool] dryrun: - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]] networks: - (Optional) Network details of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]] nodes: - (Optional) The reference to a node.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if dryrun is not None:
            pulumi.set(__self__, "dryrun", dryrun)
        if expand is not None:
            pulumi.set(__self__, "expand", expand)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]]:
        """
        - (Optional) Cluster configuration details.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter
    def dryrun(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        """
        return pulumi.get(self, "dryrun")

    @dryrun.setter
    def dryrun(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dryrun", value)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expand")

    @expand.setter
    def expand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expand", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]]:
        """
        - (Optional) Network details of a cluster.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]]:
        """
        - (Optional) The reference to a node.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]]):
        pulumi.set(self, "nodes", value)


@pulumi.input_type
class _ClusterV2State:
    def __init__(__self__, *,
                 backup_eligibility_score: Optional[pulumi.Input[_builtins.int]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_profile_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dryrun: Optional[pulumi.Input[_builtins.bool]] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 inefficient_vm_count: Optional[pulumi.Input[_builtins.int]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2LinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ClusterV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]] configs: - (Optional) Cluster configuration details.
        :param pulumi.Input[_builtins.str] container_name: - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        :param pulumi.Input[_builtins.bool] dryrun: - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]] networks: - (Optional) Network details of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]] nodes: - (Optional) The reference to a node.
        :param pulumi.Input[_builtins.str] upgrade_status: - (Optional) The reference to a project.
               Valid values are:
               - "CANCELLED"	The cluster upgrade is cancelled.
               - "FAILED"	The cluster upgrade failed.
               - "QUEUED"	The cluster upgrade is in the queue.
               - "SUCCEEDED"	The cluster was upgraded successfully.
               - "DOWNLOADING"	The cluster upgrade is downloading.
               - "PENDING"	The cluster upgrade is in pending state.
               - "UPGRADING"	The cluster is in upgrade state.
               - "PREUPGRADE"	The cluster is in pre-upgrade state.
               - "SCHEDULED"	The cluster upgrade is in scheduled state.
        """
        if backup_eligibility_score is not None:
            pulumi.set(__self__, "backup_eligibility_score", backup_eligibility_score)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cluster_profile_ext_id is not None:
            pulumi.set(__self__, "cluster_profile_ext_id", cluster_profile_ext_id)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if dryrun is not None:
            pulumi.set(__self__, "dryrun", dryrun)
        if expand is not None:
            pulumi.set(__self__, "expand", expand)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if inefficient_vm_count is not None:
            pulumi.set(__self__, "inefficient_vm_count", inefficient_vm_count)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if upgrade_status is not None:
            pulumi.set(__self__, "upgrade_status", upgrade_status)
        if vm_count is not None:
            pulumi.set(__self__, "vm_count", vm_count)

    @_builtins.property
    @pulumi.getter(name="backupEligibilityScore")
    def backup_eligibility_score(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "backup_eligibility_score")

    @backup_eligibility_score.setter
    def backup_eligibility_score(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_eligibility_score", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="clusterProfileExtId")
    def cluster_profile_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_profile_ext_id")

    @cluster_profile_ext_id.setter
    def cluster_profile_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_profile_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]]:
        """
        - (Optional) Cluster configuration details.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter
    def dryrun(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        """
        return pulumi.get(self, "dryrun")

    @dryrun.setter
    def dryrun(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dryrun", value)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expand")

    @expand.setter
    def expand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expand", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="inefficientVmCount")
    def inefficient_vm_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "inefficient_vm_count")

    @inefficient_vm_count.setter
    def inefficient_vm_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inefficient_vm_count", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]]:
        """
        - (Optional) Network details of a cluster.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]]:
        """
        - (Optional) The reference to a node.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2NodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="upgradeStatus")
    def upgrade_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The reference to a project.
        Valid values are:
        - "CANCELLED"	The cluster upgrade is cancelled.
        - "FAILED"	The cluster upgrade failed.
        - "QUEUED"	The cluster upgrade is in the queue.
        - "SUCCEEDED"	The cluster was upgraded successfully.
        - "DOWNLOADING"	The cluster upgrade is downloading.
        - "PENDING"	The cluster upgrade is in pending state.
        - "UPGRADING"	The cluster is in upgrade state.
        - "PREUPGRADE"	The cluster is in pre-upgrade state.
        - "SCHEDULED"	The cluster upgrade is in scheduled state.
        """
        return pulumi.get(self, "upgrade_status")

    @upgrade_status.setter
    def upgrade_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_status", value)

    @_builtins.property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "vm_count")

    @vm_count.setter
    def vm_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vm_count", value)


@pulumi.type_token("nutanix:index/clusterV2:ClusterV2")
class ClusterV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ConfigArgs', 'ClusterV2ConfigArgsDict']]]]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dryrun: Optional[pulumi.Input[_builtins.bool]] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NetworkArgs', 'ClusterV2NetworkArgsDict']]]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NodeArgs', 'ClusterV2NodeArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents the Cluster entity. Provides the basic infrastructure for compute, storage and networking. This includes the operations that can be carried out on cluster and its subresources - host (node), rsyslog servers etc and actions that can be performed on cluster - add a node, remove a node, attach categories.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cluster = nutanix.ClusterV2("cluster",
            name="cluster-example",
            nodes=[{
                "node_lists": [{
                    "controller_vm_ips": [{
                        "ipv4s": [{
                            "value": "10.xx.xx.xx",
                        }],
                    }],
                }],
            }],
            configs=[{
                "cluster_functions": ["AOS"],
                "redundancy_factor": 1,
                "cluster_arch": "X86_64",
                "fault_tolerance_states": [{
                    "domain_awareness_level": "DISK",
                }],
            }],
            networks=[{
                "external_addresses": [{
                    "ipv4s": [{
                        "value": "10.xx.xx.xx",
                    }],
                }],
                "external_data_services_ips": [{
                    "ipv4s": [{
                        "value": "10.xx.xx.xx",
                    }],
                }],
                "ntp_server_ip_lists": [
                    {
                        "fqdns": [{
                            "value": "ntp.server.nutanix.com",
                        }],
                    },
                    {
                        "fqdns": [{
                            "value": "ntp.server_1.nutanix.com",
                        }],
                    },
                ],
                "smtp_servers": [{
                    "email_address": "example.ex@exmple.com",
                    "servers": [{
                        "ip_addresses": [{
                            "ipv4s": [{
                                "value": "10.xx.xx.xx",
                            }],
                        }],
                        "port": 123,
                        "username": "example",
                        "password": "example!2134",
                    }],
                    "type": "PLAIN",
                }],
            }])
        ```

        ## Import

        This helps to manage existing entities which are not created through terraform. Users can be imported using the `UUID`.  eg,

        hcl

        // create its configuration in the root module. For example:

        resource "nutanix_cluster_v2" "import_cluster" {}

        // execute this cli command

        ```sh
        $ pulumi import nutanix:index/clusterV2:ClusterV2 import_cluster <UUID>
        ```

        See detailed information in [Nutanix Create Cluster V4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/Clusters/operation/createCluster).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ConfigArgs', 'ClusterV2ConfigArgsDict']]]] configs: - (Optional) Cluster configuration details.
        :param pulumi.Input[_builtins.str] container_name: - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        :param pulumi.Input[_builtins.bool] dryrun: - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NetworkArgs', 'ClusterV2NetworkArgsDict']]]] networks: - (Optional) Network details of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NodeArgs', 'ClusterV2NodeArgsDict']]]] nodes: - (Optional) The reference to a node.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents the Cluster entity. Provides the basic infrastructure for compute, storage and networking. This includes the operations that can be carried out on cluster and its subresources - host (node), rsyslog servers etc and actions that can be performed on cluster - add a node, remove a node, attach categories.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cluster = nutanix.ClusterV2("cluster",
            name="cluster-example",
            nodes=[{
                "node_lists": [{
                    "controller_vm_ips": [{
                        "ipv4s": [{
                            "value": "10.xx.xx.xx",
                        }],
                    }],
                }],
            }],
            configs=[{
                "cluster_functions": ["AOS"],
                "redundancy_factor": 1,
                "cluster_arch": "X86_64",
                "fault_tolerance_states": [{
                    "domain_awareness_level": "DISK",
                }],
            }],
            networks=[{
                "external_addresses": [{
                    "ipv4s": [{
                        "value": "10.xx.xx.xx",
                    }],
                }],
                "external_data_services_ips": [{
                    "ipv4s": [{
                        "value": "10.xx.xx.xx",
                    }],
                }],
                "ntp_server_ip_lists": [
                    {
                        "fqdns": [{
                            "value": "ntp.server.nutanix.com",
                        }],
                    },
                    {
                        "fqdns": [{
                            "value": "ntp.server_1.nutanix.com",
                        }],
                    },
                ],
                "smtp_servers": [{
                    "email_address": "example.ex@exmple.com",
                    "servers": [{
                        "ip_addresses": [{
                            "ipv4s": [{
                                "value": "10.xx.xx.xx",
                            }],
                        }],
                        "port": 123,
                        "username": "example",
                        "password": "example!2134",
                    }],
                    "type": "PLAIN",
                }],
            }])
        ```

        ## Import

        This helps to manage existing entities which are not created through terraform. Users can be imported using the `UUID`.  eg,

        hcl

        // create its configuration in the root module. For example:

        resource "nutanix_cluster_v2" "import_cluster" {}

        // execute this cli command

        ```sh
        $ pulumi import nutanix:index/clusterV2:ClusterV2 import_cluster <UUID>
        ```

        See detailed information in [Nutanix Create Cluster V4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/Clusters/operation/createCluster).

        :param str resource_name: The name of the resource.
        :param ClusterV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ConfigArgs', 'ClusterV2ConfigArgsDict']]]]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dryrun: Optional[pulumi.Input[_builtins.bool]] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NetworkArgs', 'ClusterV2NetworkArgsDict']]]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NodeArgs', 'ClusterV2NodeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterV2Args.__new__(ClusterV2Args)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["configs"] = configs
            __props__.__dict__["container_name"] = container_name
            __props__.__dict__["dryrun"] = dryrun
            __props__.__dict__["expand"] = expand
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["backup_eligibility_score"] = None
            __props__.__dict__["cluster_profile_ext_id"] = None
            __props__.__dict__["inefficient_vm_count"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["upgrade_status"] = None
            __props__.__dict__["vm_count"] = None
        super(ClusterV2, __self__).__init__(
            'nutanix:index/clusterV2:ClusterV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_eligibility_score: Optional[pulumi.Input[_builtins.int]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_profile_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ConfigArgs', 'ClusterV2ConfigArgsDict']]]]] = None,
            container_name: Optional[pulumi.Input[_builtins.str]] = None,
            dryrun: Optional[pulumi.Input[_builtins.bool]] = None,
            expand: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            inefficient_vm_count: Optional[pulumi.Input[_builtins.int]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2LinkArgs', 'ClusterV2LinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NetworkArgs', 'ClusterV2NetworkArgsDict']]]]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NodeArgs', 'ClusterV2NodeArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_status: Optional[pulumi.Input[_builtins.str]] = None,
            vm_count: Optional[pulumi.Input[_builtins.int]] = None) -> 'ClusterV2':
        """
        Get an existing ClusterV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ConfigArgs', 'ClusterV2ConfigArgsDict']]]] configs: - (Optional) Cluster configuration details.
        :param pulumi.Input[_builtins.str] container_name: - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        :param pulumi.Input[_builtins.bool] dryrun: - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NetworkArgs', 'ClusterV2NetworkArgsDict']]]] networks: - (Optional) Network details of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2NodeArgs', 'ClusterV2NodeArgsDict']]]] nodes: - (Optional) The reference to a node.
        :param pulumi.Input[_builtins.str] upgrade_status: - (Optional) The reference to a project.
               Valid values are:
               - "CANCELLED"	The cluster upgrade is cancelled.
               - "FAILED"	The cluster upgrade failed.
               - "QUEUED"	The cluster upgrade is in the queue.
               - "SUCCEEDED"	The cluster was upgraded successfully.
               - "DOWNLOADING"	The cluster upgrade is downloading.
               - "PENDING"	The cluster upgrade is in pending state.
               - "UPGRADING"	The cluster is in upgrade state.
               - "PREUPGRADE"	The cluster is in pre-upgrade state.
               - "SCHEDULED"	The cluster upgrade is in scheduled state.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterV2State.__new__(_ClusterV2State)

        __props__.__dict__["backup_eligibility_score"] = backup_eligibility_score
        __props__.__dict__["categories"] = categories
        __props__.__dict__["cluster_profile_ext_id"] = cluster_profile_ext_id
        __props__.__dict__["configs"] = configs
        __props__.__dict__["container_name"] = container_name
        __props__.__dict__["dryrun"] = dryrun
        __props__.__dict__["expand"] = expand
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["inefficient_vm_count"] = inefficient_vm_count
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["upgrade_status"] = upgrade_status
        __props__.__dict__["vm_count"] = vm_count
        return ClusterV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupEligibilityScore")
    def backup_eligibility_score(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "backup_eligibility_score")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="clusterProfileExtId")
    def cluster_profile_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_profile_ext_id")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.ClusterV2Config']]:
        """
        - (Optional) Cluster configuration details.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter
    def dryrun(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) parameter that allows long-running operations to execute in a dry-run mode providing ability to identify trouble spots and system failures without performing the actual operation. Additionally this mode also offers a summary snapshot of the resultant system in order to better understand how things fit together. The operation runs in dry-run mode only if the provided value is true.
        """
        return pulumi.get(self, "dryrun")

    @_builtins.property
    @pulumi.getter
    def expand(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="inefficientVmCount")
    def inefficient_vm_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "inefficient_vm_count")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ClusterV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.ClusterV2Network']]:
        """
        - (Optional) Network details of a cluster.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.ClusterV2Node']]:
        """
        - (Optional) The reference to a node.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="upgradeStatus")
    def upgrade_status(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The reference to a project.
        Valid values are:
        - "CANCELLED"	The cluster upgrade is cancelled.
        - "FAILED"	The cluster upgrade failed.
        - "QUEUED"	The cluster upgrade is in the queue.
        - "SUCCEEDED"	The cluster was upgraded successfully.
        - "DOWNLOADING"	The cluster upgrade is downloading.
        - "PENDING"	The cluster upgrade is in pending state.
        - "UPGRADING"	The cluster is in upgrade state.
        - "PREUPGRADE"	The cluster is in pre-upgrade state.
        - "SCHEDULED"	The cluster upgrade is in scheduled state.
        """
        return pulumi.get(self, "upgrade_status")

    @_builtins.property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "vm_count")

