# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClustersDiscoverUnconfiguredNodesV2Args', 'ClustersDiscoverUnconfiguredNodesV2']

@pulumi.input_type
class ClustersDiscoverUnconfiguredNodesV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]] = None,
                 is_manual_discovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 uuid_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClustersDiscoverUnconfiguredNodesV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[_builtins.str] address_type: - (Optional) Address type.
               Valid values are:
               - "IPV4"	IPV4 address type.
               - "IPV6"	IPV6 address type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_filter_lists: - (Optional) Interface name that is used for packet broadcasting.
        :param pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]] ip_filter_lists: - (Optional) IP addresses of the unconfigured nodes.
        :param pulumi.Input[_builtins.bool] is_manual_discovery: - (Optional) Indicates if the discovery is manual or not.
        :param pulumi.Input[_builtins.int] timeout: - (Optional) Timeout for the workflow in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uuid_filter_lists: - (Optional) Unconfigured node UUIDs.
        """
        pulumi.set(__self__, "ext_id", ext_id)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if interface_filter_lists is not None:
            pulumi.set(__self__, "interface_filter_lists", interface_filter_lists)
        if ip_filter_lists is not None:
            pulumi.set(__self__, "ip_filter_lists", ip_filter_lists)
        if is_manual_discovery is not None:
            pulumi.set(__self__, "is_manual_discovery", is_manual_discovery)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if uuid_filter_lists is not None:
            pulumi.set(__self__, "uuid_filter_lists", uuid_filter_lists)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Address type.
        Valid values are:
        - "IPV4"	IPV4 address type.
        - "IPV6"	IPV6 address type.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="interfaceFilterLists")
    def interface_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Interface name that is used for packet broadcasting.
        """
        return pulumi.get(self, "interface_filter_lists")

    @interface_filter_lists.setter
    def interface_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "interface_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipFilterLists")
    def ip_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]]:
        """
        - (Optional) IP addresses of the unconfigured nodes.
        """
        return pulumi.get(self, "ip_filter_lists")

    @ip_filter_lists.setter
    def ip_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]]):
        pulumi.set(self, "ip_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="isManualDiscovery")
    def is_manual_discovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Indicates if the discovery is manual or not.
        """
        return pulumi.get(self, "is_manual_discovery")

    @is_manual_discovery.setter
    def is_manual_discovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_manual_discovery", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Timeout for the workflow in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="uuidFilterLists")
    def uuid_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Unconfigured node UUIDs.
        """
        return pulumi.get(self, "uuid_filter_lists")

    @uuid_filter_lists.setter
    def uuid_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uuid_filter_lists", value)


@pulumi.input_type
class _ClustersDiscoverUnconfiguredNodesV2State:
    def __init__(__self__, *,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]] = None,
                 is_manual_discovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 unconfigured_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2UnconfiguredNodeArgs']]]] = None,
                 uuid_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ClustersDiscoverUnconfiguredNodesV2 resources.
        :param pulumi.Input[_builtins.str] address_type: - (Optional) Address type.
               Valid values are:
               - "IPV4"	IPV4 address type.
               - "IPV6"	IPV6 address type.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_filter_lists: - (Optional) Interface name that is used for packet broadcasting.
        :param pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]] ip_filter_lists: - (Optional) IP addresses of the unconfigured nodes.
        :param pulumi.Input[_builtins.bool] is_manual_discovery: - (Optional) Indicates if the discovery is manual or not.
        :param pulumi.Input[_builtins.int] timeout: - (Optional) Timeout for the workflow in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uuid_filter_lists: - (Optional) Unconfigured node UUIDs.
        """
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if interface_filter_lists is not None:
            pulumi.set(__self__, "interface_filter_lists", interface_filter_lists)
        if ip_filter_lists is not None:
            pulumi.set(__self__, "ip_filter_lists", ip_filter_lists)
        if is_manual_discovery is not None:
            pulumi.set(__self__, "is_manual_discovery", is_manual_discovery)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unconfigured_nodes is not None:
            pulumi.set(__self__, "unconfigured_nodes", unconfigured_nodes)
        if uuid_filter_lists is not None:
            pulumi.set(__self__, "uuid_filter_lists", uuid_filter_lists)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Address type.
        Valid values are:
        - "IPV4"	IPV4 address type.
        - "IPV6"	IPV6 address type.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="interfaceFilterLists")
    def interface_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Interface name that is used for packet broadcasting.
        """
        return pulumi.get(self, "interface_filter_lists")

    @interface_filter_lists.setter
    def interface_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "interface_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipFilterLists")
    def ip_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]]:
        """
        - (Optional) IP addresses of the unconfigured nodes.
        """
        return pulumi.get(self, "ip_filter_lists")

    @ip_filter_lists.setter
    def ip_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs']]]]):
        pulumi.set(self, "ip_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="isManualDiscovery")
    def is_manual_discovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Indicates if the discovery is manual or not.
        """
        return pulumi.get(self, "is_manual_discovery")

    @is_manual_discovery.setter
    def is_manual_discovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_manual_discovery", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Timeout for the workflow in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="unconfiguredNodes")
    def unconfigured_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2UnconfiguredNodeArgs']]]]:
        return pulumi.get(self, "unconfigured_nodes")

    @unconfigured_nodes.setter
    def unconfigured_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersDiscoverUnconfiguredNodesV2UnconfiguredNodeArgs']]]]):
        pulumi.set(self, "unconfigured_nodes", value)

    @_builtins.property
    @pulumi.getter(name="uuidFilterLists")
    def uuid_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Unconfigured node UUIDs.
        """
        return pulumi.get(self, "uuid_filter_lists")

    @uuid_filter_lists.setter
    def uuid_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uuid_filter_lists", value)


@pulumi.type_token("nutanix:index/clustersDiscoverUnconfiguredNodesV2:ClustersDiscoverUnconfiguredNodesV2")
class ClustersDiscoverUnconfiguredNodesV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs', 'ClustersDiscoverUnconfiguredNodesV2IpFilterListArgsDict']]]]] = None,
                 is_manual_discovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 uuid_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Get the unconfigured node details such as node UUID, node position, node IP, foundation version and more.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: - (Optional) Address type.
               Valid values are:
               - "IPV4"	IPV4 address type.
               - "IPV6"	IPV6 address type.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_filter_lists: - (Optional) Interface name that is used for packet broadcasting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs', 'ClustersDiscoverUnconfiguredNodesV2IpFilterListArgsDict']]]] ip_filter_lists: - (Optional) IP addresses of the unconfigured nodes.
        :param pulumi.Input[_builtins.bool] is_manual_discovery: - (Optional) Indicates if the discovery is manual or not.
        :param pulumi.Input[_builtins.int] timeout: - (Optional) Timeout for the workflow in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uuid_filter_lists: - (Optional) Unconfigured node UUIDs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClustersDiscoverUnconfiguredNodesV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Get the unconfigured node details such as node UUID, node position, node IP, foundation version and more.

        :param str resource_name: The name of the resource.
        :param ClustersDiscoverUnconfiguredNodesV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClustersDiscoverUnconfiguredNodesV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs', 'ClustersDiscoverUnconfiguredNodesV2IpFilterListArgsDict']]]]] = None,
                 is_manual_discovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 uuid_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClustersDiscoverUnconfiguredNodesV2Args.__new__(ClustersDiscoverUnconfiguredNodesV2Args)

            __props__.__dict__["address_type"] = address_type
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["interface_filter_lists"] = interface_filter_lists
            __props__.__dict__["ip_filter_lists"] = ip_filter_lists
            __props__.__dict__["is_manual_discovery"] = is_manual_discovery
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["uuid_filter_lists"] = uuid_filter_lists
            __props__.__dict__["unconfigured_nodes"] = None
        super(ClustersDiscoverUnconfiguredNodesV2, __self__).__init__(
            'nutanix:index/clustersDiscoverUnconfiguredNodesV2:ClustersDiscoverUnconfiguredNodesV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            interface_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ip_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs', 'ClustersDiscoverUnconfiguredNodesV2IpFilterListArgsDict']]]]] = None,
            is_manual_discovery: Optional[pulumi.Input[_builtins.bool]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            unconfigured_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2UnconfiguredNodeArgs', 'ClustersDiscoverUnconfiguredNodesV2UnconfiguredNodeArgsDict']]]]] = None,
            uuid_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ClustersDiscoverUnconfiguredNodesV2':
        """
        Get an existing ClustersDiscoverUnconfiguredNodesV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: - (Optional) Address type.
               Valid values are:
               - "IPV4"	IPV4 address type.
               - "IPV6"	IPV6 address type.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_filter_lists: - (Optional) Interface name that is used for packet broadcasting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClustersDiscoverUnconfiguredNodesV2IpFilterListArgs', 'ClustersDiscoverUnconfiguredNodesV2IpFilterListArgsDict']]]] ip_filter_lists: - (Optional) IP addresses of the unconfigured nodes.
        :param pulumi.Input[_builtins.bool] is_manual_discovery: - (Optional) Indicates if the discovery is manual or not.
        :param pulumi.Input[_builtins.int] timeout: - (Optional) Timeout for the workflow in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uuid_filter_lists: - (Optional) Unconfigured node UUIDs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClustersDiscoverUnconfiguredNodesV2State.__new__(_ClustersDiscoverUnconfiguredNodesV2State)

        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["interface_filter_lists"] = interface_filter_lists
        __props__.__dict__["ip_filter_lists"] = ip_filter_lists
        __props__.__dict__["is_manual_discovery"] = is_manual_discovery
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["unconfigured_nodes"] = unconfigured_nodes
        __props__.__dict__["uuid_filter_lists"] = uuid_filter_lists
        return ClustersDiscoverUnconfiguredNodesV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Address type.
        Valid values are:
        - "IPV4"	IPV4 address type.
        - "IPV6"	IPV6 address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="interfaceFilterLists")
    def interface_filter_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        - (Optional) Interface name that is used for packet broadcasting.
        """
        return pulumi.get(self, "interface_filter_lists")

    @_builtins.property
    @pulumi.getter(name="ipFilterLists")
    def ip_filter_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ClustersDiscoverUnconfiguredNodesV2IpFilterList']]]:
        """
        - (Optional) IP addresses of the unconfigured nodes.
        """
        return pulumi.get(self, "ip_filter_lists")

    @_builtins.property
    @pulumi.getter(name="isManualDiscovery")
    def is_manual_discovery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Indicates if the discovery is manual or not.
        """
        return pulumi.get(self, "is_manual_discovery")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        - (Optional) Timeout for the workflow in seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="unconfiguredNodes")
    def unconfigured_nodes(self) -> pulumi.Output[Sequence['outputs.ClustersDiscoverUnconfiguredNodesV2UnconfiguredNode']]:
        return pulumi.get(self, "unconfigured_nodes")

    @_builtins.property
    @pulumi.getter(name="uuidFilterLists")
    def uuid_filter_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        - (Optional) Unconfigured node UUIDs.
        """
        return pulumi.get(self, "uuid_filter_lists")

