# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClustersUnconfiguredNodeNetworksV2Args', 'ClustersUnconfiguredNodeNetworksV2']

@pulumi.input_type
class ClustersUnconfiguredNodeNetworksV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 node_lists: pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]],
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClustersUnconfiguredNodeNetworksV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]] node_lists: -(Required) List of nodes for which the network information is required.
        :param pulumi.Input[_builtins.str] request_type: -(Optional) Request type
        """
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "node_lists", node_lists)
        if expand is not None:
            pulumi.set(__self__, "expand", expand)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeLists")
    def node_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]]:
        """
        -(Required) List of nodes for which the network information is required.
        """
        return pulumi.get(self, "node_lists")

    @node_lists.setter
    def node_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]]):
        pulumi.set(self, "node_lists", value)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expand")

    @expand.setter
    def expand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expand", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Request type
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_type", value)


@pulumi.input_type
class _ClustersUnconfiguredNodeNetworksV2State:
    def __init__(__self__, *,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]]] = None,
                 nodes_networking_details: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetailArgs']]]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClustersUnconfiguredNodeNetworksV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]] node_lists: -(Required) List of nodes for which the network information is required.
        :param pulumi.Input[_builtins.str] request_type: -(Optional) Request type
        """
        if expand is not None:
            pulumi.set(__self__, "expand", expand)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if node_lists is not None:
            pulumi.set(__self__, "node_lists", node_lists)
        if nodes_networking_details is not None:
            pulumi.set(__self__, "nodes_networking_details", nodes_networking_details)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expand")

    @expand.setter
    def expand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expand", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeLists")
    def node_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]]]:
        """
        -(Required) List of nodes for which the network information is required.
        """
        return pulumi.get(self, "node_lists")

    @node_lists.setter
    def node_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodeListArgs']]]]):
        pulumi.set(self, "node_lists", value)

    @_builtins.property
    @pulumi.getter(name="nodesNetworkingDetails")
    def nodes_networking_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetailArgs']]]]:
        return pulumi.get(self, "nodes_networking_details")

    @nodes_networking_details.setter
    def nodes_networking_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetailArgs']]]]):
        pulumi.set(self, "nodes_networking_details", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Request type
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_type", value)


@pulumi.type_token("nutanix:index/clustersUnconfiguredNodeNetworksV2:ClustersUnconfiguredNodeNetworksV2")
class ClustersUnconfiguredNodeNetworksV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodeListArgs', 'ClustersUnconfiguredNodeNetworksV2NodeListArgsDict']]]]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Get a dictionary of cluster networks and available uplinks on the given nodes. This API is not supported for XEN hypervisor type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # ## fetch Network info for unconfigured node
        node_network_info = nutanix.ClustersUnconfiguredNodeNetworksV2("node-network-info",
            ext_id="0005b6b0-0b0b-0000-0000-000000000000",
            request_type="expand_cluster",
            node_lists=[{
                "cvm_ips": [{
                    "ipv4s": [{
                        "value": "10.73.23.55",
                    }],
                }],
                "hypervisor_ips": [{
                    "ipv4s": [{
                        "value": "10.33.44.12",
                    }],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodeListArgs', 'ClustersUnconfiguredNodeNetworksV2NodeListArgsDict']]]] node_lists: -(Required) List of nodes for which the network information is required.
        :param pulumi.Input[_builtins.str] request_type: -(Optional) Request type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClustersUnconfiguredNodeNetworksV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Get a dictionary of cluster networks and available uplinks on the given nodes. This API is not supported for XEN hypervisor type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # ## fetch Network info for unconfigured node
        node_network_info = nutanix.ClustersUnconfiguredNodeNetworksV2("node-network-info",
            ext_id="0005b6b0-0b0b-0000-0000-000000000000",
            request_type="expand_cluster",
            node_lists=[{
                "cvm_ips": [{
                    "ipv4s": [{
                        "value": "10.73.23.55",
                    }],
                }],
                "hypervisor_ips": [{
                    "ipv4s": [{
                        "value": "10.33.44.12",
                    }],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ClustersUnconfiguredNodeNetworksV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClustersUnconfiguredNodeNetworksV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expand: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodeListArgs', 'ClustersUnconfiguredNodeNetworksV2NodeListArgsDict']]]]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClustersUnconfiguredNodeNetworksV2Args.__new__(ClustersUnconfiguredNodeNetworksV2Args)

            __props__.__dict__["expand"] = expand
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if node_lists is None and not opts.urn:
                raise TypeError("Missing required property 'node_lists'")
            __props__.__dict__["node_lists"] = node_lists
            __props__.__dict__["request_type"] = request_type
            __props__.__dict__["nodes_networking_details"] = None
        super(ClustersUnconfiguredNodeNetworksV2, __self__).__init__(
            'nutanix:index/clustersUnconfiguredNodeNetworksV2:ClustersUnconfiguredNodeNetworksV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expand: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodeListArgs', 'ClustersUnconfiguredNodeNetworksV2NodeListArgsDict']]]]] = None,
            nodes_networking_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetailArgs', 'ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetailArgsDict']]]]] = None,
            request_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClustersUnconfiguredNodeNetworksV2':
        """
        Get an existing ClustersUnconfiguredNodeNetworksV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClustersUnconfiguredNodeNetworksV2NodeListArgs', 'ClustersUnconfiguredNodeNetworksV2NodeListArgsDict']]]] node_lists: -(Required) List of nodes for which the network information is required.
        :param pulumi.Input[_builtins.str] request_type: -(Optional) Request type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClustersUnconfiguredNodeNetworksV2State.__new__(_ClustersUnconfiguredNodeNetworksV2State)

        __props__.__dict__["expand"] = expand
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["node_lists"] = node_lists
        __props__.__dict__["nodes_networking_details"] = nodes_networking_details
        __props__.__dict__["request_type"] = request_type
        return ClustersUnconfiguredNodeNetworksV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Cluster UUID.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="nodeLists")
    def node_lists(self) -> pulumi.Output[Sequence['outputs.ClustersUnconfiguredNodeNetworksV2NodeList']]:
        """
        -(Required) List of nodes for which the network information is required.
        """
        return pulumi.get(self, "node_lists")

    @_builtins.property
    @pulumi.getter(name="nodesNetworkingDetails")
    def nodes_networking_details(self) -> pulumi.Output[Sequence['outputs.ClustersUnconfiguredNodeNetworksV2NodesNetworkingDetail']]:
        return pulumi.get(self, "nodes_networking_details")

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Request type
        """
        return pulumi.get(self, "request_type")

