# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DirectoryServicesV2Args', 'DirectoryServicesV2']

@pulumi.input_type
class DirectoryServicesV2Args:
    def __init__(__self__, *,
                 directory_type: pulumi.Input[_builtins.str],
                 domain_name: pulumi.Input[_builtins.str],
                 service_accounts: pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]],
                 url: pulumi.Input[_builtins.str],
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ldap_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]] = None,
                 secondary_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 white_listed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DirectoryServicesV2 resource.
        :param pulumi.Input[_builtins.str] directory_type: -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        :param pulumi.Input[_builtins.str] domain_name: -(Required) Domain name for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]] service_accounts: -(Required) Information of Service account to connect to the Directory Service.
        :param pulumi.Input[_builtins.str] url: -(Required) URL for the Directory Service.
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] group_search_type: -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        :param pulumi.Input[_builtins.str] name: -(Required) Name for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]] open_ldap_configurations: -(Optional) Configuration for OpenLDAP Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_urls: -(Optional) Secondary URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] white_listed_groups: -(Optional) List of allowed User Groups for the Directory Service.
        """
        pulumi.set(__self__, "directory_type", directory_type)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "service_accounts", service_accounts)
        pulumi.set(__self__, "url", url)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if group_search_type is not None:
            pulumi.set(__self__, "group_search_type", group_search_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_ldap_configurations is not None:
            pulumi.set(__self__, "open_ldap_configurations", open_ldap_configurations)
        if secondary_urls is not None:
            pulumi.set(__self__, "secondary_urls", secondary_urls)
        if white_listed_groups is not None:
            pulumi.set(__self__, "white_listed_groups", white_listed_groups)

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        """
        return pulumi.get(self, "directory_type")

    @directory_type.setter
    def directory_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_type", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Domain name for the Directory Service.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]]:
        """
        -(Required) Information of Service account to connect to the Directory Service.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]]):
        pulumi.set(self, "service_accounts", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) URL for the Directory Service.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchType")
    def group_search_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        """
        return pulumi.get(self, "group_search_type")

    @group_search_type.setter
    def group_search_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name for the Directory Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openLdapConfigurations")
    def open_ldap_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]]:
        """
        -(Optional) Configuration for OpenLDAP Directory Service.
        """
        return pulumi.get(self, "open_ldap_configurations")

    @open_ldap_configurations.setter
    def open_ldap_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]]):
        pulumi.set(self, "open_ldap_configurations", value)

    @_builtins.property
    @pulumi.getter(name="secondaryUrls")
    def secondary_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) Secondary URL for the Directory Service.
        """
        return pulumi.get(self, "secondary_urls")

    @secondary_urls.setter
    def secondary_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_urls", value)

    @_builtins.property
    @pulumi.getter(name="whiteListedGroups")
    def white_listed_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) List of allowed User Groups for the Directory Service.
        """
        return pulumi.get(self, "white_listed_groups")

    @white_listed_groups.setter
    def white_listed_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "white_listed_groups", value)


@pulumi.input_type
class _DirectoryServicesV2State:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ldap_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]] = None,
                 secondary_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 white_listed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DirectoryServicesV2 resources.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the Directory Service.
        :param pulumi.Input[_builtins.str] created_time: - Creation time of the Directory Service.
        :param pulumi.Input[_builtins.str] directory_type: -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        :param pulumi.Input[_builtins.str] domain_name: -(Required) Domain name for the Directory Service.
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] group_search_type: -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the Directory Service.
        :param pulumi.Input[_builtins.str] name: -(Required) Name for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]] open_ldap_configurations: -(Optional) Configuration for OpenLDAP Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_urls: -(Optional) Secondary URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]] service_accounts: -(Required) Information of Service account to connect to the Directory Service.
        :param pulumi.Input[_builtins.str] url: -(Required) URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] white_listed_groups: -(Optional) List of allowed User Groups for the Directory Service.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if directory_type is not None:
            pulumi.set(__self__, "directory_type", directory_type)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if group_search_type is not None:
            pulumi.set(__self__, "group_search_type", group_search_type)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_ldap_configurations is not None:
            pulumi.set(__self__, "open_ldap_configurations", open_ldap_configurations)
        if secondary_urls is not None:
            pulumi.set(__self__, "secondary_urls", secondary_urls)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if white_listed_groups is not None:
            pulumi.set(__self__, "white_listed_groups", white_listed_groups)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or Service who created the Directory Service.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Creation time of the Directory Service.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        """
        return pulumi.get(self, "directory_type")

    @directory_type.setter
    def directory_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_type", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Domain name for the Directory Service.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchType")
    def group_search_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        """
        return pulumi.get(self, "group_search_type")

    @group_search_type.setter
    def group_search_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_type", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last updated time of the Directory Service.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name for the Directory Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openLdapConfigurations")
    def open_ldap_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]]:
        """
        -(Optional) Configuration for OpenLDAP Directory Service.
        """
        return pulumi.get(self, "open_ldap_configurations")

    @open_ldap_configurations.setter
    def open_ldap_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2OpenLdapConfigurationArgs']]]]):
        pulumi.set(self, "open_ldap_configurations", value)

    @_builtins.property
    @pulumi.getter(name="secondaryUrls")
    def secondary_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) Secondary URL for the Directory Service.
        """
        return pulumi.get(self, "secondary_urls")

    @secondary_urls.setter
    def secondary_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_urls", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]]]:
        """
        -(Required) Information of Service account to connect to the Directory Service.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryServicesV2ServiceAccountArgs']]]]):
        pulumi.set(self, "service_accounts", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) URL for the Directory Service.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="whiteListedGroups")
    def white_listed_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) List of allowed User Groups for the Directory Service.
        """
        return pulumi.get(self, "white_listed_groups")

    @white_listed_groups.setter
    def white_listed_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "white_listed_groups", value)


@pulumi.type_token("nutanix:index/directoryServicesV2:DirectoryServicesV2")
class DirectoryServicesV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ldap_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2OpenLdapConfigurationArgs', 'DirectoryServicesV2OpenLdapConfigurationArgsDict']]]]] = None,
                 secondary_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2ServiceAccountArgs', 'DirectoryServicesV2ServiceAccountArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 white_listed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to Create a Directory Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Add Directory Service .
        active_directory = nutanix.DirectoryServicesV2("active-directory",
            name="example_active_directory",
            url="ldap://10.xx.xx.xx:xxxx",
            directory_type="ACTIVE_DIRECTORY",
            domain_name="nutanix.com",
            service_accounts=[{
                "username": "username",
                "password": "password",
            }],
            white_listed_groups=["example"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory_type: -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        :param pulumi.Input[_builtins.str] domain_name: -(Required) Domain name for the Directory Service.
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] group_search_type: -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        :param pulumi.Input[_builtins.str] name: -(Required) Name for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2OpenLdapConfigurationArgs', 'DirectoryServicesV2OpenLdapConfigurationArgsDict']]]] open_ldap_configurations: -(Optional) Configuration for OpenLDAP Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_urls: -(Optional) Secondary URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2ServiceAccountArgs', 'DirectoryServicesV2ServiceAccountArgsDict']]]] service_accounts: -(Required) Information of Service account to connect to the Directory Service.
        :param pulumi.Input[_builtins.str] url: -(Required) URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] white_listed_groups: -(Optional) List of allowed User Groups for the Directory Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectoryServicesV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to Create a Directory Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Add Directory Service .
        active_directory = nutanix.DirectoryServicesV2("active-directory",
            name="example_active_directory",
            url="ldap://10.xx.xx.xx:xxxx",
            directory_type="ACTIVE_DIRECTORY",
            domain_name="nutanix.com",
            service_accounts=[{
                "username": "username",
                "password": "password",
            }],
            white_listed_groups=["example"])
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryServicesV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryServicesV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ldap_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2OpenLdapConfigurationArgs', 'DirectoryServicesV2OpenLdapConfigurationArgsDict']]]]] = None,
                 secondary_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2ServiceAccountArgs', 'DirectoryServicesV2ServiceAccountArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 white_listed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryServicesV2Args.__new__(DirectoryServicesV2Args)

            if directory_type is None and not opts.urn:
                raise TypeError("Missing required property 'directory_type'")
            __props__.__dict__["directory_type"] = directory_type
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["group_search_type"] = group_search_type
            __props__.__dict__["name"] = name
            __props__.__dict__["open_ldap_configurations"] = open_ldap_configurations
            __props__.__dict__["secondary_urls"] = secondary_urls
            if service_accounts is None and not opts.urn:
                raise TypeError("Missing required property 'service_accounts'")
            __props__.__dict__["service_accounts"] = service_accounts
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["white_listed_groups"] = white_listed_groups
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["last_updated_time"] = None
        super(DirectoryServicesV2, __self__).__init__(
            'nutanix:index/directoryServicesV2:DirectoryServicesV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            directory_type: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_search_type: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            open_ldap_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2OpenLdapConfigurationArgs', 'DirectoryServicesV2OpenLdapConfigurationArgsDict']]]]] = None,
            secondary_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2ServiceAccountArgs', 'DirectoryServicesV2ServiceAccountArgsDict']]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            white_listed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DirectoryServicesV2':
        """
        Get an existing DirectoryServicesV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the Directory Service.
        :param pulumi.Input[_builtins.str] created_time: - Creation time of the Directory Service.
        :param pulumi.Input[_builtins.str] directory_type: -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        :param pulumi.Input[_builtins.str] domain_name: -(Required) Domain name for the Directory Service.
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] group_search_type: -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the Directory Service.
        :param pulumi.Input[_builtins.str] name: -(Required) Name for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2OpenLdapConfigurationArgs', 'DirectoryServicesV2OpenLdapConfigurationArgsDict']]]] open_ldap_configurations: -(Optional) Configuration for OpenLDAP Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_urls: -(Optional) Secondary URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DirectoryServicesV2ServiceAccountArgs', 'DirectoryServicesV2ServiceAccountArgsDict']]]] service_accounts: -(Required) Information of Service account to connect to the Directory Service.
        :param pulumi.Input[_builtins.str] url: -(Required) URL for the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] white_listed_groups: -(Optional) List of allowed User Groups for the Directory Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectoryServicesV2State.__new__(_DirectoryServicesV2State)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["directory_type"] = directory_type
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["group_search_type"] = group_search_type
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["name"] = name
        __props__.__dict__["open_ldap_configurations"] = open_ldap_configurations
        __props__.__dict__["secondary_urls"] = secondary_urls
        __props__.__dict__["service_accounts"] = service_accounts
        __props__.__dict__["url"] = url
        __props__.__dict__["white_listed_groups"] = white_listed_groups
        return DirectoryServicesV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User or Service who created the Directory Service.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Creation time of the Directory Service.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        """
        return pulumi.get(self, "directory_type")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Domain name for the Directory Service.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="groupSearchType")
    def group_search_type(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        """
        return pulumi.get(self, "group_search_type")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Last updated time of the Directory Service.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Name for the Directory Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openLdapConfigurations")
    def open_ldap_configurations(self) -> pulumi.Output[Sequence['outputs.DirectoryServicesV2OpenLdapConfiguration']]:
        """
        -(Optional) Configuration for OpenLDAP Directory Service.
        """
        return pulumi.get(self, "open_ldap_configurations")

    @_builtins.property
    @pulumi.getter(name="secondaryUrls")
    def secondary_urls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        -(Optional) Secondary URL for the Directory Service.
        """
        return pulumi.get(self, "secondary_urls")

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> pulumi.Output[Sequence['outputs.DirectoryServicesV2ServiceAccount']]:
        """
        -(Required) Information of Service account to connect to the Directory Service.
        """
        return pulumi.get(self, "service_accounts")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) URL for the Directory Service.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="whiteListedGroups")
    def white_listed_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        -(Optional) List of allowed User Groups for the Directory Service.
        """
        return pulumi.get(self, "white_listed_groups")

