# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FloatingIpArgs', 'FloatingIp']

@pulumi.input_type
class FloatingIpArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FloatingIp resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] external_subnet_reference_name: The reference to a subnet. Should not be used with 
               {external_subnet_reference_uuid} .
        :param pulumi.Input[_builtins.str] external_subnet_reference_uuid: The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        :param pulumi.Input[_builtins.str] private_ip: Private IP with which floating IP is associated. Should be used with vpc_reference .
        :param pulumi.Input[_builtins.str] vm_nic_reference_uuid: The reference to a vm_nic .
        :param pulumi.Input[_builtins.str] vpc_reference_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if external_subnet_reference_name is not None:
            pulumi.set(__self__, "external_subnet_reference_name", external_subnet_reference_name)
        if external_subnet_reference_uuid is not None:
            pulumi.set(__self__, "external_subnet_reference_uuid", external_subnet_reference_uuid)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if vm_nic_reference_uuid is not None:
            pulumi.set(__self__, "vm_nic_reference_uuid", vm_nic_reference_uuid)
        if vpc_reference_name is not None:
            pulumi.set(__self__, "vpc_reference_name", vpc_reference_name)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceName")
    def external_subnet_reference_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a subnet. Should not be used with 
        {external_subnet_reference_uuid} .
        """
        return pulumi.get(self, "external_subnet_reference_name")

    @external_subnet_reference_name.setter
    def external_subnet_reference_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference_name", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuid")
    def external_subnet_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        """
        return pulumi.get(self, "external_subnet_reference_uuid")

    @external_subnet_reference_uuid.setter
    def external_subnet_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference_uuid", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP with which floating IP is associated. Should be used with vpc_reference .
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="vmNicReferenceUuid")
    def vm_nic_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vm_nic .
        """
        return pulumi.get(self, "vm_nic_reference_uuid")

    @vm_nic_reference_uuid.setter
    def vm_nic_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_nic_reference_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceName")
    def vpc_reference_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        """
        return pulumi.get(self, "vpc_reference_name")

    @vpc_reference_name.setter
    def vpc_reference_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)


@pulumi.input_type
class _FloatingIpState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FloatingIp resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] external_subnet_reference_name: The reference to a subnet. Should not be used with 
               {external_subnet_reference_uuid} .
        :param pulumi.Input[_builtins.str] external_subnet_reference_uuid: The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The floating_ips kind metadata.
        :param pulumi.Input[_builtins.str] private_ip: Private IP with which floating IP is associated. Should be used with vpc_reference .
        :param pulumi.Input[_builtins.str] vm_nic_reference_uuid: The reference to a vm_nic .
        :param pulumi.Input[_builtins.str] vpc_reference_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if external_subnet_reference_name is not None:
            pulumi.set(__self__, "external_subnet_reference_name", external_subnet_reference_name)
        if external_subnet_reference_uuid is not None:
            pulumi.set(__self__, "external_subnet_reference_uuid", external_subnet_reference_uuid)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if vm_nic_reference_uuid is not None:
            pulumi.set(__self__, "vm_nic_reference_uuid", vm_nic_reference_uuid)
        if vpc_reference_name is not None:
            pulumi.set(__self__, "vpc_reference_name", vpc_reference_name)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceName")
    def external_subnet_reference_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a subnet. Should not be used with 
        {external_subnet_reference_uuid} .
        """
        return pulumi.get(self, "external_subnet_reference_name")

    @external_subnet_reference_name.setter
    def external_subnet_reference_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference_name", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuid")
    def external_subnet_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        """
        return pulumi.get(self, "external_subnet_reference_uuid")

    @external_subnet_reference_uuid.setter
    def external_subnet_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference_uuid", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The floating_ips kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP with which floating IP is associated. Should be used with vpc_reference .
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="vmNicReferenceUuid")
    def vm_nic_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vm_nic .
        """
        return pulumi.get(self, "vm_nic_reference_uuid")

    @vm_nic_reference_uuid.setter
    def vm_nic_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_nic_reference_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceName")
    def vpc_reference_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        """
        return pulumi.get(self, "vpc_reference_name")

    @vpc_reference_name.setter
    def vpc_reference_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)


@pulumi.type_token("nutanix:index/floatingIp:FloatingIp")
class FloatingIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create Floating IPs.

        ## create Floating IP with External Subnet UUID

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip1 = nutanix.FloatingIp("fip1", external_subnet_reference_uuid="{{ext_sub_uuid}}")
        ```

        ## create Floating IP with vpc name with external subnet name

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip2 = nutanix.FloatingIp("fip2",
            external_subnet_reference_name="{{ext_sub_name}}",
            vpc_reference_name="{{vpc_name}}",
            private_ip="{{ip_address}}")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] external_subnet_reference_name: The reference to a subnet. Should not be used with 
               {external_subnet_reference_uuid} .
        :param pulumi.Input[_builtins.str] external_subnet_reference_uuid: The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        :param pulumi.Input[_builtins.str] private_ip: Private IP with which floating IP is associated. Should be used with vpc_reference .
        :param pulumi.Input[_builtins.str] vm_nic_reference_uuid: The reference to a vm_nic .
        :param pulumi.Input[_builtins.str] vpc_reference_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FloatingIpArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create Floating IPs.

        ## create Floating IP with External Subnet UUID

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip1 = nutanix.FloatingIp("fip1", external_subnet_reference_uuid="{{ext_sub_uuid}}")
        ```

        ## create Floating IP with vpc name with external subnet name

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip2 = nutanix.FloatingIp("fip2",
            external_subnet_reference_name="{{ext_sub_name}}",
            vpc_reference_name="{{vpc_name}}",
            private_ip="{{ip_address}}")
        ```

        :param str resource_name: The name of the resource.
        :param FloatingIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FloatingIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FloatingIpArgs.__new__(FloatingIpArgs)

            __props__.__dict__["api_version"] = api_version
            __props__.__dict__["external_subnet_reference_name"] = external_subnet_reference_name
            __props__.__dict__["external_subnet_reference_uuid"] = external_subnet_reference_uuid
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["vm_nic_reference_uuid"] = vm_nic_reference_uuid
            __props__.__dict__["vpc_reference_name"] = vpc_reference_name
            __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
            __props__.__dict__["metadata"] = None
        super(FloatingIp, __self__).__init__(
            'nutanix:index/floatingIp:FloatingIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            external_subnet_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_subnet_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            vm_nic_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_reference_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'FloatingIp':
        """
        Get an existing FloatingIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] external_subnet_reference_name: The reference to a subnet. Should not be used with 
               {external_subnet_reference_uuid} .
        :param pulumi.Input[_builtins.str] external_subnet_reference_uuid: The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The floating_ips kind metadata.
        :param pulumi.Input[_builtins.str] private_ip: Private IP with which floating IP is associated. Should be used with vpc_reference .
        :param pulumi.Input[_builtins.str] vm_nic_reference_uuid: The reference to a vm_nic .
        :param pulumi.Input[_builtins.str] vpc_reference_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FloatingIpState.__new__(_FloatingIpState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["external_subnet_reference_name"] = external_subnet_reference_name
        __props__.__dict__["external_subnet_reference_uuid"] = external_subnet_reference_uuid
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["vm_nic_reference_uuid"] = vm_nic_reference_uuid
        __props__.__dict__["vpc_reference_name"] = vpc_reference_name
        __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
        return FloatingIp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceName")
    def external_subnet_reference_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reference to a subnet. Should not be used with 
        {external_subnet_reference_uuid} .
        """
        return pulumi.get(self, "external_subnet_reference_name")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuid")
    def external_subnet_reference_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The reference to a subnet. Should not be used with {external_subnet_reference_name} .
        """
        return pulumi.get(self, "external_subnet_reference_uuid")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The floating_ips kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private IP with which floating IP is associated. Should be used with vpc_reference .
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="vmNicReferenceUuid")
    def vm_nic_reference_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reference to a vm_nic .
        """
        return pulumi.get(self, "vm_nic_reference_uuid")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceName")
    def vpc_reference_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}.
        """
        return pulumi.get(self, "vpc_reference_name")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_name}.
        """
        return pulumi.get(self, "vpc_reference_uuid")

