# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FloatingIpV2Args', 'FloatingIpV2']

@pulumi.input_type
class FloatingIpV2Args:
    def __init__(__self__, *,
                 associations: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]] = None,
                 floating_ips: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]] = None,
                 load_balancer_session_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nics: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]] = None):
        """
        The set of arguments for constructing a FloatingIpV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]] associations: Association of the Floating IP with either NIC or Private IP
        :param pulumi.Input[_builtins.str] description: Description for the Floating IP.
        :param pulumi.Input[_builtins.str] external_subnet_reference: External subnet reference for the Floating IP to be allocated in on-prem only.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]] external_subnets: Networking common base object
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]] floating_ips: Floating IP address.
        :param pulumi.Input[_builtins.str] name: Name of the floating IP.
        :param pulumi.Input[_builtins.str] vm_nic_reference: VM NIC reference.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]] vm_nics: Virtual NIC for projections
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference UUID
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]] vpcs: Networking common base object
        """
        if associations is not None:
            pulumi.set(__self__, "associations", associations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if external_subnet_reference is not None:
            pulumi.set(__self__, "external_subnet_reference", external_subnet_reference)
        if external_subnets is not None:
            pulumi.set(__self__, "external_subnets", external_subnets)
        if floating_ips is not None:
            pulumi.set(__self__, "floating_ips", floating_ips)
        if load_balancer_session_reference is not None:
            pulumi.set(__self__, "load_balancer_session_reference", load_balancer_session_reference)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vm_nic_reference is not None:
            pulumi.set(__self__, "vm_nic_reference", vm_nic_reference)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vpc_reference is not None:
            pulumi.set(__self__, "vpc_reference", vpc_reference)
        if vpcs is not None:
            pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]]:
        """
        Association of the Floating IP with either NIC or Private IP
        """
        return pulumi.get(self, "associations")

    @associations.setter
    def associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]]):
        pulumi.set(self, "associations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Floating IP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReference")
    def external_subnet_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External subnet reference for the Floating IP to be allocated in on-prem only.
        """
        return pulumi.get(self, "external_subnet_reference")

    @external_subnet_reference.setter
    def external_subnet_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]]:
        """
        Networking common base object
        """
        return pulumi.get(self, "external_subnets")

    @external_subnets.setter
    def external_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]]):
        pulumi.set(self, "external_subnets", value)

    @_builtins.property
    @pulumi.getter(name="floatingIps")
    def floating_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]]:
        """
        Floating IP address.
        """
        return pulumi.get(self, "floating_ips")

    @floating_ips.setter
    def floating_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]]):
        pulumi.set(self, "floating_ips", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSessionReference")
    def load_balancer_session_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "load_balancer_session_reference")

    @load_balancer_session_reference.setter
    def load_balancer_session_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_session_reference", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the floating IP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vmNicReference")
    def vm_nic_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM NIC reference.
        """
        return pulumi.get(self, "vm_nic_reference")

    @vm_nic_reference.setter
    def vm_nic_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_nic_reference", value)

    @_builtins.property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]]:
        """
        Virtual NIC for projections
        """
        return pulumi.get(self, "vm_nics")

    @vm_nics.setter
    def vm_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]]):
        pulumi.set(self, "vm_nics", value)

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference UUID
        """
        return pulumi.get(self, "vpc_reference")

    @vpc_reference.setter
    def vpc_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]]:
        """
        Networking common base object
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]]):
        pulumi.set(self, "vpcs", value)


@pulumi.input_type
class _FloatingIpV2State:
    def __init__(__self__, *,
                 association_status: Optional[pulumi.Input[_builtins.str]] = None,
                 associations: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]] = None,
                 floating_ip_value: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ips: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2LinkArgs']]]] = None,
                 load_balancer_session_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2MetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nics: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]] = None):
        """
        Input properties used for looking up and filtering FloatingIpV2 resources.
        :param pulumi.Input[_builtins.str] association_status: Association status of floating IP.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]] associations: Association of the Floating IP with either NIC or Private IP
        :param pulumi.Input[_builtins.str] description: Description for the Floating IP.
        :param pulumi.Input[_builtins.str] external_subnet_reference: External subnet reference for the Floating IP to be allocated in on-prem only.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]] external_subnets: Networking common base object
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]] floating_ips: Floating IP address.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2LinkArgs']]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2MetadataArgs']]] metadatas: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Name of the floating IP.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[_builtins.str] vm_nic_reference: VM NIC reference.
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]] vm_nics: Virtual NIC for projections
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference UUID
        :param pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]] vpcs: Networking common base object
        """
        if association_status is not None:
            pulumi.set(__self__, "association_status", association_status)
        if associations is not None:
            pulumi.set(__self__, "associations", associations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if external_subnet_reference is not None:
            pulumi.set(__self__, "external_subnet_reference", external_subnet_reference)
        if external_subnets is not None:
            pulumi.set(__self__, "external_subnets", external_subnets)
        if floating_ip_value is not None:
            pulumi.set(__self__, "floating_ip_value", floating_ip_value)
        if floating_ips is not None:
            pulumi.set(__self__, "floating_ips", floating_ips)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if load_balancer_session_reference is not None:
            pulumi.set(__self__, "load_balancer_session_reference", load_balancer_session_reference)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vm_nic_reference is not None:
            pulumi.set(__self__, "vm_nic_reference", vm_nic_reference)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vpc_reference is not None:
            pulumi.set(__self__, "vpc_reference", vpc_reference)
        if vpcs is not None:
            pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Association status of floating IP.
        """
        return pulumi.get(self, "association_status")

    @association_status.setter
    def association_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_status", value)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]]:
        """
        Association of the Floating IP with either NIC or Private IP
        """
        return pulumi.get(self, "associations")

    @associations.setter
    def associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2AssociationArgs']]]]):
        pulumi.set(self, "associations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Floating IP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReference")
    def external_subnet_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External subnet reference for the Floating IP to be allocated in on-prem only.
        """
        return pulumi.get(self, "external_subnet_reference")

    @external_subnet_reference.setter
    def external_subnet_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subnet_reference", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]]:
        """
        Networking common base object
        """
        return pulumi.get(self, "external_subnets")

    @external_subnets.setter
    def external_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2ExternalSubnetArgs']]]]):
        pulumi.set(self, "external_subnets", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpValue")
    def floating_ip_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "floating_ip_value")

    @floating_ip_value.setter
    def floating_ip_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_value", value)

    @_builtins.property
    @pulumi.getter(name="floatingIps")
    def floating_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]]:
        """
        Floating IP address.
        """
        return pulumi.get(self, "floating_ips")

    @floating_ips.setter
    def floating_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2FloatingIpArgs']]]]):
        pulumi.set(self, "floating_ips", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2LinkArgs']]]]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSessionReference")
    def load_balancer_session_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "load_balancer_session_reference")

    @load_balancer_session_reference.setter
    def load_balancer_session_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_session_reference", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2MetadataArgs']]]]:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2MetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the floating IP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vmNicReference")
    def vm_nic_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM NIC reference.
        """
        return pulumi.get(self, "vm_nic_reference")

    @vm_nic_reference.setter
    def vm_nic_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_nic_reference", value)

    @_builtins.property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]]:
        """
        Virtual NIC for projections
        """
        return pulumi.get(self, "vm_nics")

    @vm_nics.setter
    def vm_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VmNicArgs']]]]):
        pulumi.set(self, "vm_nics", value)

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference UUID
        """
        return pulumi.get(self, "vpc_reference")

    @vpc_reference.setter
    def vpc_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]]:
        """
        Networking common base object
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloatingIpV2VpcArgs']]]]):
        pulumi.set(self, "vpcs", value)


@pulumi.type_token("nutanix:index/floatingIpV2:FloatingIpV2")
class FloatingIpV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2AssociationArgs', 'FloatingIpV2AssociationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2ExternalSubnetArgs', 'FloatingIpV2ExternalSubnetArgsDict']]]]] = None,
                 floating_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2FloatingIpArgs', 'FloatingIpV2FloatingIpArgsDict']]]]] = None,
                 load_balancer_session_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VmNicArgs', 'FloatingIpV2VmNicArgsDict']]]]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VpcArgs', 'FloatingIpV2VpcArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create Floating IPs.

        ## Example1 :  create Floating IP with External Subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create Floating IP with External Subnet UUID
        fip_ext_subnet = nutanix.FloatingIpV2("fip-ext-subnet",
            name="example-fip",
            description="example fip  description",
            external_subnet_reference="ba250e3e-1db1-4950-917f-a9e2ea35b8e3")
        ```

        ## Example2 :  create Floating IP with External Subnet with vm association

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip_ext_subnet_vm = nutanix.FloatingIpV2("fip-ext-subnet-vm",
            name="example-fip",
            description="example fip  description",
            external_subnet_reference="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            associations=[{
                "vm_nic_associations": [{
                    "vm_nic_reference": "31e4b3b1-4b3b-4b3b-4b3b-4b3b4b3b4b3b",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2AssociationArgs', 'FloatingIpV2AssociationArgsDict']]]] associations: Association of the Floating IP with either NIC or Private IP
        :param pulumi.Input[_builtins.str] description: Description for the Floating IP.
        :param pulumi.Input[_builtins.str] external_subnet_reference: External subnet reference for the Floating IP to be allocated in on-prem only.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2ExternalSubnetArgs', 'FloatingIpV2ExternalSubnetArgsDict']]]] external_subnets: Networking common base object
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2FloatingIpArgs', 'FloatingIpV2FloatingIpArgsDict']]]] floating_ips: Floating IP address.
        :param pulumi.Input[_builtins.str] name: Name of the floating IP.
        :param pulumi.Input[_builtins.str] vm_nic_reference: VM NIC reference.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VmNicArgs', 'FloatingIpV2VmNicArgsDict']]]] vm_nics: Virtual NIC for projections
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference UUID
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VpcArgs', 'FloatingIpV2VpcArgsDict']]]] vpcs: Networking common base object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FloatingIpV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create Floating IPs.

        ## Example1 :  create Floating IP with External Subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create Floating IP with External Subnet UUID
        fip_ext_subnet = nutanix.FloatingIpV2("fip-ext-subnet",
            name="example-fip",
            description="example fip  description",
            external_subnet_reference="ba250e3e-1db1-4950-917f-a9e2ea35b8e3")
        ```

        ## Example2 :  create Floating IP with External Subnet with vm association

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        fip_ext_subnet_vm = nutanix.FloatingIpV2("fip-ext-subnet-vm",
            name="example-fip",
            description="example fip  description",
            external_subnet_reference="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            associations=[{
                "vm_nic_associations": [{
                    "vm_nic_reference": "31e4b3b1-4b3b-4b3b-4b3b-4b3b4b3b4b3b",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param FloatingIpV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FloatingIpV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2AssociationArgs', 'FloatingIpV2AssociationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnet_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2ExternalSubnetArgs', 'FloatingIpV2ExternalSubnetArgsDict']]]]] = None,
                 floating_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2FloatingIpArgs', 'FloatingIpV2FloatingIpArgsDict']]]]] = None,
                 load_balancer_session_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nic_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VmNicArgs', 'FloatingIpV2VmNicArgsDict']]]]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VpcArgs', 'FloatingIpV2VpcArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FloatingIpV2Args.__new__(FloatingIpV2Args)

            __props__.__dict__["associations"] = associations
            __props__.__dict__["description"] = description
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["external_subnet_reference"] = external_subnet_reference
            __props__.__dict__["external_subnets"] = external_subnets
            __props__.__dict__["floating_ips"] = floating_ips
            __props__.__dict__["load_balancer_session_reference"] = load_balancer_session_reference
            __props__.__dict__["name"] = name
            __props__.__dict__["vm_nic_reference"] = vm_nic_reference
            __props__.__dict__["vm_nics"] = vm_nics
            __props__.__dict__["vpc_reference"] = vpc_reference
            __props__.__dict__["vpcs"] = vpcs
            __props__.__dict__["association_status"] = None
            __props__.__dict__["floating_ip_value"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["tenant_id"] = None
        super(FloatingIpV2, __self__).__init__(
            'nutanix:index/floatingIpV2:FloatingIpV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            association_status: Optional[pulumi.Input[_builtins.str]] = None,
            associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2AssociationArgs', 'FloatingIpV2AssociationArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_subnet_reference: Optional[pulumi.Input[_builtins.str]] = None,
            external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2ExternalSubnetArgs', 'FloatingIpV2ExternalSubnetArgsDict']]]]] = None,
            floating_ip_value: Optional[pulumi.Input[_builtins.str]] = None,
            floating_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2FloatingIpArgs', 'FloatingIpV2FloatingIpArgsDict']]]]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2LinkArgs', 'FloatingIpV2LinkArgsDict']]]]] = None,
            load_balancer_session_reference: Optional[pulumi.Input[_builtins.str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2MetadataArgs', 'FloatingIpV2MetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_nic_reference: Optional[pulumi.Input[_builtins.str]] = None,
            vm_nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VmNicArgs', 'FloatingIpV2VmNicArgsDict']]]]] = None,
            vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
            vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VpcArgs', 'FloatingIpV2VpcArgsDict']]]]] = None) -> 'FloatingIpV2':
        """
        Get an existing FloatingIpV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] association_status: Association status of floating IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2AssociationArgs', 'FloatingIpV2AssociationArgsDict']]]] associations: Association of the Floating IP with either NIC or Private IP
        :param pulumi.Input[_builtins.str] description: Description for the Floating IP.
        :param pulumi.Input[_builtins.str] external_subnet_reference: External subnet reference for the Floating IP to be allocated in on-prem only.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2ExternalSubnetArgs', 'FloatingIpV2ExternalSubnetArgsDict']]]] external_subnets: Networking common base object
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2FloatingIpArgs', 'FloatingIpV2FloatingIpArgsDict']]]] floating_ips: Floating IP address.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2LinkArgs', 'FloatingIpV2LinkArgsDict']]]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2MetadataArgs', 'FloatingIpV2MetadataArgsDict']]]] metadatas: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Name of the floating IP.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[_builtins.str] vm_nic_reference: VM NIC reference.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VmNicArgs', 'FloatingIpV2VmNicArgsDict']]]] vm_nics: Virtual NIC for projections
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference UUID
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloatingIpV2VpcArgs', 'FloatingIpV2VpcArgsDict']]]] vpcs: Networking common base object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FloatingIpV2State.__new__(_FloatingIpV2State)

        __props__.__dict__["association_status"] = association_status
        __props__.__dict__["associations"] = associations
        __props__.__dict__["description"] = description
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["external_subnet_reference"] = external_subnet_reference
        __props__.__dict__["external_subnets"] = external_subnets
        __props__.__dict__["floating_ip_value"] = floating_ip_value
        __props__.__dict__["floating_ips"] = floating_ips
        __props__.__dict__["links"] = links
        __props__.__dict__["load_balancer_session_reference"] = load_balancer_session_reference
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vm_nic_reference"] = vm_nic_reference
        __props__.__dict__["vm_nics"] = vm_nics
        __props__.__dict__["vpc_reference"] = vpc_reference
        __props__.__dict__["vpcs"] = vpcs
        return FloatingIpV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> pulumi.Output[_builtins.str]:
        """
        Association status of floating IP.
        """
        return pulumi.get(self, "association_status")

    @_builtins.property
    @pulumi.getter
    def associations(self) -> pulumi.Output[Optional[Sequence['outputs.FloatingIpV2Association']]]:
        """
        Association of the Floating IP with either NIC or Private IP
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the Floating IP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReference")
    def external_subnet_reference(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External subnet reference for the Floating IP to be allocated in on-prem only.
        """
        return pulumi.get(self, "external_subnet_reference")

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2ExternalSubnet']]:
        """
        Networking common base object
        """
        return pulumi.get(self, "external_subnets")

    @_builtins.property
    @pulumi.getter(name="floatingIpValue")
    def floating_ip_value(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "floating_ip_value")

    @_builtins.property
    @pulumi.getter(name="floatingIps")
    def floating_ips(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2FloatingIp']]:
        """
        Floating IP address.
        """
        return pulumi.get(self, "floating_ips")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2Link']]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSessionReference")
    def load_balancer_session_reference(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "load_balancer_session_reference")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2Metadata']]:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the floating IP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vmNicReference")
    def vm_nic_reference(self) -> pulumi.Output[_builtins.str]:
        """
        VM NIC reference.
        """
        return pulumi.get(self, "vm_nic_reference")

    @_builtins.property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2VmNic']]:
        """
        Virtual NIC for projections
        """
        return pulumi.get(self, "vm_nics")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> pulumi.Output[_builtins.str]:
        """
        VPC reference UUID
        """
        return pulumi.get(self, "vpc_reference")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> pulumi.Output[Sequence['outputs.FloatingIpV2Vpc']]:
        """
        Networking common base object
        """
        return pulumi.get(self, "vpcs")

