# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FoundationCentralApiKeysArgs', 'FoundationCentralApiKeys']

@pulumi.input_type
class FoundationCentralApiKeysArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FoundationCentralApiKeys resource.
        :param pulumi.Input[_builtins.str] alias: - (Required) Alias for the api key to be created.
        """
        pulumi.set(__self__, "alias", alias)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) Alias for the api key to be created.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alias", value)


@pulumi.input_type
class _FoundationCentralApiKeysState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 created_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 current_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FoundationCentralApiKeys resources.
        :param pulumi.Input[_builtins.str] alias: - (Required) Alias for the api key to be created.
        :param pulumi.Input[_builtins.str] api_key: Api key in string format.
        :param pulumi.Input[_builtins.str] created_timestamp: Time when the api key was created.
        :param pulumi.Input[_builtins.str] current_time: Current time of Foundation Central.
        :param pulumi.Input[_builtins.str] key_uuid: UUID of the api key.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if created_timestamp is not None:
            pulumi.set(__self__, "created_timestamp", created_timestamp)
        if current_time is not None:
            pulumi.set(__self__, "current_time", current_time)
        if key_uuid is not None:
            pulumi.set(__self__, "key_uuid", key_uuid)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Alias for the api key to be created.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Api key in string format.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the api key was created.
        """
        return pulumi.get(self, "created_timestamp")

    @created_timestamp.setter
    def created_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="currentTime")
    def current_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current time of Foundation Central.
        """
        return pulumi.get(self, "current_time")

    @current_time.setter
    def current_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_time", value)

    @_builtins.property
    @pulumi.getter(name="keyUuid")
    def key_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the api key.
        """
        return pulumi.get(self, "key_uuid")

    @key_uuid.setter
    def key_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_uuid", value)


@pulumi.type_token("nutanix:index/foundationCentralApiKeys:FoundationCentralApiKeys")
class FoundationCentralApiKeys(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a new API key for nodes registration with Foundation Central.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        new_api_key = nutanix.FoundationCentralApiKeys("new_api_key", alias="<NAME-FOR-API-KEY>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: - (Required) Alias for the api key to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FoundationCentralApiKeysArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a new API key for nodes registration with Foundation Central.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        new_api_key = nutanix.FoundationCentralApiKeys("new_api_key", alias="<NAME-FOR-API-KEY>")
        ```

        :param str resource_name: The name of the resource.
        :param FoundationCentralApiKeysArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FoundationCentralApiKeysArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FoundationCentralApiKeysArgs.__new__(FoundationCentralApiKeysArgs)

            if alias is None and not opts.urn:
                raise TypeError("Missing required property 'alias'")
            __props__.__dict__["alias"] = alias
            __props__.__dict__["api_key"] = None
            __props__.__dict__["created_timestamp"] = None
            __props__.__dict__["current_time"] = None
            __props__.__dict__["key_uuid"] = None
        super(FoundationCentralApiKeys, __self__).__init__(
            'nutanix:index/foundationCentralApiKeys:FoundationCentralApiKeys',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            created_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            current_time: Optional[pulumi.Input[_builtins.str]] = None,
            key_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'FoundationCentralApiKeys':
        """
        Get an existing FoundationCentralApiKeys resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: - (Required) Alias for the api key to be created.
        :param pulumi.Input[_builtins.str] api_key: Api key in string format.
        :param pulumi.Input[_builtins.str] created_timestamp: Time when the api key was created.
        :param pulumi.Input[_builtins.str] current_time: Current time of Foundation Central.
        :param pulumi.Input[_builtins.str] key_uuid: UUID of the api key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FoundationCentralApiKeysState.__new__(_FoundationCentralApiKeysState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["created_timestamp"] = created_timestamp
        __props__.__dict__["current_time"] = current_time
        __props__.__dict__["key_uuid"] = key_uuid
        return FoundationCentralApiKeys(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Alias for the api key to be created.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        Api key in string format.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the api key was created.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="currentTime")
    def current_time(self) -> pulumi.Output[_builtins.str]:
        """
        Current time of Foundation Central.
        """
        return pulumi.get(self, "current_time")

    @_builtins.property
    @pulumi.getter(name="keyUuid")
    def key_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the api key.
        """
        return pulumi.get(self, "key_uuid")

