# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FoundationImageArgs', 'FoundationImage']

@pulumi.input_type
class FoundationImageArgs:
    def __init__(__self__, *,
                 filename: pulumi.Input[_builtins.str],
                 installer_type: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FoundationImage resource.
        :param pulumi.Input[_builtins.str] filename: - (Required) Name of installer file to be kept in foundation vm.
        :param pulumi.Input[_builtins.str] installer_type: - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        :param pulumi.Input[_builtins.str] source: - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        pulumi.set(__self__, "filename", filename)
        pulumi.set(__self__, "installer_type", installer_type)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) Name of installer file to be kept in foundation vm.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter(name="installerType")
    def installer_type(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        """
        return pulumi.get(self, "installer_type")

    @installer_type.setter
    def installer_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "installer_type", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _FoundationImageState:
    def __init__(__self__, *,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 in_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 installer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 md5sum: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FoundationImage resources.
        :param pulumi.Input[_builtins.str] filename: - (Required) Name of installer file to be kept in foundation vm.
        :param pulumi.Input[_builtins.bool] in_whitelist: - If hypervisor ISO is in whitelist.
        :param pulumi.Input[_builtins.str] installer_type: - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        :param pulumi.Input[_builtins.str] md5sum: - md5sum of the ISO.
        :param pulumi.Input[_builtins.str] name: - file location in foundation vm
        :param pulumi.Input[_builtins.str] source: - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if in_whitelist is not None:
            pulumi.set(__self__, "in_whitelist", in_whitelist)
        if installer_type is not None:
            pulumi.set(__self__, "installer_type", installer_type)
        if md5sum is not None:
            pulumi.set(__self__, "md5sum", md5sum)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of installer file to be kept in foundation vm.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter(name="inWhitelist")
    def in_whitelist(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - If hypervisor ISO is in whitelist.
        """
        return pulumi.get(self, "in_whitelist")

    @in_whitelist.setter
    def in_whitelist(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "in_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="installerType")
    def installer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        """
        return pulumi.get(self, "installer_type")

    @installer_type.setter
    def installer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "installer_type", value)

    @_builtins.property
    @pulumi.getter
    def md5sum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - md5sum of the ISO.
        """
        return pulumi.get(self, "md5sum")

    @md5sum.setter
    def md5sum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5sum", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - file location in foundation vm
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("nutanix:index/foundationImage:FoundationImage")
class FoundationImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 installer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Uploads hypervisor or AOS image to foundation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        nos_image = nutanix.FoundationImage("nos-image",
            source="../../../files/nutanix_installer_x86_64.tar",
            filename="nos_image.tar",
            installer_type="nos")
        hypervisor_image = nutanix.FoundationImage("hypervisor-image",
            source="../../../files/VMware-Installer.x86_64.iso",
            filename="esx_image.iso",
            installer_type="esx")
        ```

        ## lifecycle

        * `Update` : - Resource will trigger new resource create call for any kind of update in resource config and delete existing image from foundation vm.

        See detailed information in [Nutanix Foundation Image](https://www.nutanix.dev/api_references/foundation/#/b3A6MjIyMjM0MDQ-upload-hypervisor-or-aos-image-to-foundation).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filename: - (Required) Name of installer file to be kept in foundation vm.
        :param pulumi.Input[_builtins.str] installer_type: - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        :param pulumi.Input[_builtins.str] source: - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FoundationImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Uploads hypervisor or AOS image to foundation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        nos_image = nutanix.FoundationImage("nos-image",
            source="../../../files/nutanix_installer_x86_64.tar",
            filename="nos_image.tar",
            installer_type="nos")
        hypervisor_image = nutanix.FoundationImage("hypervisor-image",
            source="../../../files/VMware-Installer.x86_64.iso",
            filename="esx_image.iso",
            installer_type="esx")
        ```

        ## lifecycle

        * `Update` : - Resource will trigger new resource create call for any kind of update in resource config and delete existing image from foundation vm.

        See detailed information in [Nutanix Foundation Image](https://www.nutanix.dev/api_references/foundation/#/b3A6MjIyMjM0MDQ-upload-hypervisor-or-aos-image-to-foundation).

        :param str resource_name: The name of the resource.
        :param FoundationImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FoundationImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 installer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FoundationImageArgs.__new__(FoundationImageArgs)

            if filename is None and not opts.urn:
                raise TypeError("Missing required property 'filename'")
            __props__.__dict__["filename"] = filename
            if installer_type is None and not opts.urn:
                raise TypeError("Missing required property 'installer_type'")
            __props__.__dict__["installer_type"] = installer_type
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["in_whitelist"] = None
            __props__.__dict__["md5sum"] = None
            __props__.__dict__["name"] = None
        super(FoundationImage, __self__).__init__(
            'nutanix:index/foundationImage:FoundationImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filename: Optional[pulumi.Input[_builtins.str]] = None,
            in_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
            installer_type: Optional[pulumi.Input[_builtins.str]] = None,
            md5sum: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'FoundationImage':
        """
        Get an existing FoundationImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filename: - (Required) Name of installer file to be kept in foundation vm.
        :param pulumi.Input[_builtins.bool] in_whitelist: - If hypervisor ISO is in whitelist.
        :param pulumi.Input[_builtins.str] installer_type: - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        :param pulumi.Input[_builtins.str] md5sum: - md5sum of the ISO.
        :param pulumi.Input[_builtins.str] name: - file location in foundation vm
        :param pulumi.Input[_builtins.str] source: - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FoundationImageState.__new__(_FoundationImageState)

        __props__.__dict__["filename"] = filename
        __props__.__dict__["in_whitelist"] = in_whitelist
        __props__.__dict__["installer_type"] = installer_type
        __props__.__dict__["md5sum"] = md5sum
        __props__.__dict__["name"] = name
        __props__.__dict__["source"] = source
        return FoundationImage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Name of installer file to be kept in foundation vm.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter(name="inWhitelist")
    def in_whitelist(self) -> pulumi.Output[_builtins.bool]:
        """
        - If hypervisor ISO is in whitelist.
        """
        return pulumi.get(self, "in_whitelist")

    @_builtins.property
    @pulumi.getter(name="installerType")
    def installer_type(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) One of "kvm", "esx", "hyperv", "xen", or "nos".
        """
        return pulumi.get(self, "installer_type")

    @_builtins.property
    @pulumi.getter
    def md5sum(self) -> pulumi.Output[_builtins.str]:
        """
        - md5sum of the ISO.
        """
        return pulumi.get(self, "md5sum")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - file location in foundation vm
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Complete path to the file in machine where the .tf  files runs.
        """
        return pulumi.get(self, "source")

