# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FoundationImageNodesArgs', 'FoundationImageNodes']

@pulumi.input_type
class FoundationImageNodesArgs:
    def __init__(__self__, *,
                 blocks: pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]],
                 cvm_gateway: pulumi.Input[_builtins.str],
                 cvm_netmask: pulumi.Input[_builtins.str],
                 hypervisor_gateway: pulumi.Input[_builtins.str],
                 hypervisor_netmask: pulumi.Input[_builtins.str],
                 nos_package: pulumi.Input[_builtins.str],
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]] = None,
                 eos_metadata: Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']] = None,
                 fc_settings: Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']] = None,
                 hyperv_external_vnic: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_external_vswitch: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_product_key: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_sku: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisor_iso: Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']] = None,
                 hypervisor_nameserver: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_password: Optional[pulumi.Input[_builtins.str]] = None,
                 install_script: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_user: Optional[pulumi.Input[_builtins.str]] = None,
                 layout_egg_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_hypervisor: Optional[pulumi.Input[_builtins.bool]] = None,
                 svm_rescue_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tests: Optional[pulumi.Input['FoundationImageNodesTestsArgs']] = None,
                 ucsm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_user: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_path: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_username: Optional[pulumi.Input[_builtins.str]] = None,
                 xen_config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_label: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FoundationImageNodes resource.
        :param pulumi.Input[_builtins.str] cvm_gateway: - (Required) CVM gateway.
        :param pulumi.Input[_builtins.str] cvm_netmask: - (Required) CVM netmask.
        :param pulumi.Input[_builtins.str] hypervisor_gateway: - (Required) Hypervisor gateway.
        :param pulumi.Input[_builtins.str] hypervisor_netmask: - (Required) Hypervisor netmask.
        :param pulumi.Input[_builtins.str] nos_package: - (Required) NOS package.
        :param pulumi.Input['FoundationImageNodesEosMetadataArgs'] eos_metadata: - Contains user data from Eos portal.
        :param pulumi.Input['FoundationImageNodesFcSettingsArgs'] fc_settings: - Foundation Central specific settings.
        :param pulumi.Input[_builtins.str] hyperv_external_vnic: - Hyperv External virtual network adapter name.
        :param pulumi.Input[_builtins.str] hyperv_external_vswitch: - Hyperv External vswitch name.
        :param pulumi.Input[_builtins.str] hyperv_product_key: - Hyperv product key.
        :param pulumi.Input[_builtins.bool] hyperv_sku: - Hyperv SKU.
        :param pulumi.Input['FoundationImageNodesHypervisorIsoArgs'] hypervisor_iso: - Hypervisor ISO.
        :param pulumi.Input[_builtins.str] hypervisor_password: - Hypervisor password.
        :param pulumi.Input[_builtins.str] install_script: - install script.
        :param pulumi.Input[_builtins.str] ipmi_gateway: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        :param pulumi.Input[_builtins.str] ipmi_netmask: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        :param pulumi.Input[_builtins.str] ipmi_password: - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        :param pulumi.Input[_builtins.str] ipmi_user: - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        :param pulumi.Input[_builtins.str] layout_egg_uuid: - Id of the custom layout which needs to be passed to imaging request.
        :param pulumi.Input[_builtins.bool] skip_hypervisor: - If hypervisor installation should be skipped.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] svm_rescue_args: - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        :param pulumi.Input['FoundationImageNodesTestsArgs'] tests: - Types of tests to be performed.
        :param pulumi.Input[_builtins.str] ucsm_ip: - UCSM IP address.
        :param pulumi.Input[_builtins.str] ucsm_password: - UCSM password.
        :param pulumi.Input[_builtins.str] ucsm_user: - UCSM username.
        :param pulumi.Input[_builtins.str] unc_password: - UNC password.
        :param pulumi.Input[_builtins.str] unc_path: - UNC Path.
        :param pulumi.Input[_builtins.str] unc_username: - UNC username.
        :param pulumi.Input[_builtins.str] xen_config_type: - xen config types.
        :param pulumi.Input[_builtins.str] xs_master_ip: - xen server master IP address.
        :param pulumi.Input[_builtins.str] xs_master_label: - xen server master label.
        :param pulumi.Input[_builtins.str] xs_master_password: - xen server master password.
        :param pulumi.Input[_builtins.str] xs_master_username: - xen server master username.
        """
        pulumi.set(__self__, "blocks", blocks)
        pulumi.set(__self__, "cvm_gateway", cvm_gateway)
        pulumi.set(__self__, "cvm_netmask", cvm_netmask)
        pulumi.set(__self__, "hypervisor_gateway", hypervisor_gateway)
        pulumi.set(__self__, "hypervisor_netmask", hypervisor_netmask)
        pulumi.set(__self__, "nos_package", nos_package)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if eos_metadata is not None:
            pulumi.set(__self__, "eos_metadata", eos_metadata)
        if fc_settings is not None:
            pulumi.set(__self__, "fc_settings", fc_settings)
        if hyperv_external_vnic is not None:
            pulumi.set(__self__, "hyperv_external_vnic", hyperv_external_vnic)
        if hyperv_external_vswitch is not None:
            pulumi.set(__self__, "hyperv_external_vswitch", hyperv_external_vswitch)
        if hyperv_product_key is not None:
            pulumi.set(__self__, "hyperv_product_key", hyperv_product_key)
        if hyperv_sku is not None:
            pulumi.set(__self__, "hyperv_sku", hyperv_sku)
        if hypervisor_iso is not None:
            pulumi.set(__self__, "hypervisor_iso", hypervisor_iso)
        if hypervisor_nameserver is not None:
            pulumi.set(__self__, "hypervisor_nameserver", hypervisor_nameserver)
        if hypervisor_password is not None:
            pulumi.set(__self__, "hypervisor_password", hypervisor_password)
        if install_script is not None:
            pulumi.set(__self__, "install_script", install_script)
        if ipmi_gateway is not None:
            pulumi.set(__self__, "ipmi_gateway", ipmi_gateway)
        if ipmi_netmask is not None:
            pulumi.set(__self__, "ipmi_netmask", ipmi_netmask)
        if ipmi_password is not None:
            pulumi.set(__self__, "ipmi_password", ipmi_password)
        if ipmi_user is not None:
            pulumi.set(__self__, "ipmi_user", ipmi_user)
        if layout_egg_uuid is not None:
            pulumi.set(__self__, "layout_egg_uuid", layout_egg_uuid)
        if skip_hypervisor is not None:
            pulumi.set(__self__, "skip_hypervisor", skip_hypervisor)
        if svm_rescue_args is not None:
            pulumi.set(__self__, "svm_rescue_args", svm_rescue_args)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)
        if ucsm_ip is not None:
            pulumi.set(__self__, "ucsm_ip", ucsm_ip)
        if ucsm_password is not None:
            pulumi.set(__self__, "ucsm_password", ucsm_password)
        if ucsm_user is not None:
            pulumi.set(__self__, "ucsm_user", ucsm_user)
        if unc_password is not None:
            pulumi.set(__self__, "unc_password", unc_password)
        if unc_path is not None:
            pulumi.set(__self__, "unc_path", unc_path)
        if unc_username is not None:
            pulumi.set(__self__, "unc_username", unc_username)
        if xen_config_type is not None:
            pulumi.set(__self__, "xen_config_type", xen_config_type)
        if xs_master_ip is not None:
            pulumi.set(__self__, "xs_master_ip", xs_master_ip)
        if xs_master_label is not None:
            pulumi.set(__self__, "xs_master_label", xs_master_label)
        if xs_master_password is not None:
            pulumi.set(__self__, "xs_master_password", xs_master_password)
        if xs_master_username is not None:
            pulumi.set(__self__, "xs_master_username", xs_master_username)

    @_builtins.property
    @pulumi.getter
    def blocks(self) -> pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]]:
        return pulumi.get(self, "blocks")

    @blocks.setter
    def blocks(self, value: pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]]):
        pulumi.set(self, "blocks", value)

    @_builtins.property
    @pulumi.getter(name="cvmGateway")
    def cvm_gateway(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) CVM gateway.
        """
        return pulumi.get(self, "cvm_gateway")

    @cvm_gateway.setter
    def cvm_gateway(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cvm_gateway", value)

    @_builtins.property
    @pulumi.getter(name="cvmNetmask")
    def cvm_netmask(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) CVM netmask.
        """
        return pulumi.get(self, "cvm_netmask")

    @cvm_netmask.setter
    def cvm_netmask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cvm_netmask", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorGateway")
    def hypervisor_gateway(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) Hypervisor gateway.
        """
        return pulumi.get(self, "hypervisor_gateway")

    @hypervisor_gateway.setter
    def hypervisor_gateway(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hypervisor_gateway", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorNetmask")
    def hypervisor_netmask(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) Hypervisor netmask.
        """
        return pulumi.get(self, "hypervisor_netmask")

    @hypervisor_netmask.setter
    def hypervisor_netmask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hypervisor_netmask", value)

    @_builtins.property
    @pulumi.getter(name="nosPackage")
    def nos_package(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) NOS package.
        """
        return pulumi.get(self, "nos_package")

    @nos_package.setter
    def nos_package(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nos_package", value)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]]:
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter(name="eosMetadata")
    def eos_metadata(self) -> Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']]:
        """
        - Contains user data from Eos portal.
        """
        return pulumi.get(self, "eos_metadata")

    @eos_metadata.setter
    def eos_metadata(self, value: Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']]):
        pulumi.set(self, "eos_metadata", value)

    @_builtins.property
    @pulumi.getter(name="fcSettings")
    def fc_settings(self) -> Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']]:
        """
        - Foundation Central specific settings.
        """
        return pulumi.get(self, "fc_settings")

    @fc_settings.setter
    def fc_settings(self, value: Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']]):
        pulumi.set(self, "fc_settings", value)

    @_builtins.property
    @pulumi.getter(name="hypervExternalVnic")
    def hyperv_external_vnic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv External virtual network adapter name.
        """
        return pulumi.get(self, "hyperv_external_vnic")

    @hyperv_external_vnic.setter
    def hyperv_external_vnic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_external_vnic", value)

    @_builtins.property
    @pulumi.getter(name="hypervExternalVswitch")
    def hyperv_external_vswitch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv External vswitch name.
        """
        return pulumi.get(self, "hyperv_external_vswitch")

    @hyperv_external_vswitch.setter
    def hyperv_external_vswitch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_external_vswitch", value)

    @_builtins.property
    @pulumi.getter(name="hypervProductKey")
    def hyperv_product_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv product key.
        """
        return pulumi.get(self, "hyperv_product_key")

    @hyperv_product_key.setter
    def hyperv_product_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_product_key", value)

    @_builtins.property
    @pulumi.getter(name="hypervSku")
    def hyperv_sku(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Hyperv SKU.
        """
        return pulumi.get(self, "hyperv_sku")

    @hyperv_sku.setter
    def hyperv_sku(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hyperv_sku", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorIso")
    def hypervisor_iso(self) -> Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']]:
        """
        - Hypervisor ISO.
        """
        return pulumi.get(self, "hypervisor_iso")

    @hypervisor_iso.setter
    def hypervisor_iso(self, value: Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']]):
        pulumi.set(self, "hypervisor_iso", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorNameserver")
    def hypervisor_nameserver(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hypervisor_nameserver")

    @hypervisor_nameserver.setter
    def hypervisor_nameserver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_nameserver", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorPassword")
    def hypervisor_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hypervisor password.
        """
        return pulumi.get(self, "hypervisor_password")

    @hypervisor_password.setter
    def hypervisor_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_password", value)

    @_builtins.property
    @pulumi.getter(name="installScript")
    def install_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - install script.
        """
        return pulumi.get(self, "install_script")

    @install_script.setter
    def install_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "install_script", value)

    @_builtins.property
    @pulumi.getter(name="ipmiGateway")
    def ipmi_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        """
        return pulumi.get(self, "ipmi_gateway")

    @ipmi_gateway.setter
    def ipmi_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipmiNetmask")
    def ipmi_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        """
        return pulumi.get(self, "ipmi_netmask")

    @ipmi_netmask.setter
    def ipmi_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_netmask", value)

    @_builtins.property
    @pulumi.getter(name="ipmiPassword")
    def ipmi_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        """
        return pulumi.get(self, "ipmi_password")

    @ipmi_password.setter
    def ipmi_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_password", value)

    @_builtins.property
    @pulumi.getter(name="ipmiUser")
    def ipmi_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        """
        return pulumi.get(self, "ipmi_user")

    @ipmi_user.setter
    def ipmi_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_user", value)

    @_builtins.property
    @pulumi.getter(name="layoutEggUuid")
    def layout_egg_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Id of the custom layout which needs to be passed to imaging request.
        """
        return pulumi.get(self, "layout_egg_uuid")

    @layout_egg_uuid.setter
    def layout_egg_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "layout_egg_uuid", value)

    @_builtins.property
    @pulumi.getter(name="skipHypervisor")
    def skip_hypervisor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - If hypervisor installation should be skipped.
        """
        return pulumi.get(self, "skip_hypervisor")

    @skip_hypervisor.setter
    def skip_hypervisor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_hypervisor", value)

    @_builtins.property
    @pulumi.getter(name="svmRescueArgs")
    def svm_rescue_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        """
        return pulumi.get(self, "svm_rescue_args")

    @svm_rescue_args.setter
    def svm_rescue_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "svm_rescue_args", value)

    @_builtins.property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input['FoundationImageNodesTestsArgs']]:
        """
        - Types of tests to be performed.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input['FoundationImageNodesTestsArgs']]):
        pulumi.set(self, "tests", value)

    @_builtins.property
    @pulumi.getter(name="ucsmIp")
    def ucsm_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM IP address.
        """
        return pulumi.get(self, "ucsm_ip")

    @ucsm_ip.setter
    def ucsm_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_ip", value)

    @_builtins.property
    @pulumi.getter(name="ucsmPassword")
    def ucsm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM password.
        """
        return pulumi.get(self, "ucsm_password")

    @ucsm_password.setter
    def ucsm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_password", value)

    @_builtins.property
    @pulumi.getter(name="ucsmUser")
    def ucsm_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM username.
        """
        return pulumi.get(self, "ucsm_user")

    @ucsm_user.setter
    def ucsm_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_user", value)

    @_builtins.property
    @pulumi.getter(name="uncPassword")
    def unc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC password.
        """
        return pulumi.get(self, "unc_password")

    @unc_password.setter
    def unc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_password", value)

    @_builtins.property
    @pulumi.getter(name="uncPath")
    def unc_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC Path.
        """
        return pulumi.get(self, "unc_path")

    @unc_path.setter
    def unc_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_path", value)

    @_builtins.property
    @pulumi.getter(name="uncUsername")
    def unc_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC username.
        """
        return pulumi.get(self, "unc_username")

    @unc_username.setter
    def unc_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_username", value)

    @_builtins.property
    @pulumi.getter(name="xenConfigType")
    def xen_config_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen config types.
        """
        return pulumi.get(self, "xen_config_type")

    @xen_config_type.setter
    def xen_config_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xen_config_type", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterIp")
    def xs_master_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master IP address.
        """
        return pulumi.get(self, "xs_master_ip")

    @xs_master_ip.setter
    def xs_master_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_ip", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterLabel")
    def xs_master_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master label.
        """
        return pulumi.get(self, "xs_master_label")

    @xs_master_label.setter
    def xs_master_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_label", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterPassword")
    def xs_master_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master password.
        """
        return pulumi.get(self, "xs_master_password")

    @xs_master_password.setter
    def xs_master_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_password", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterUsername")
    def xs_master_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master username.
        """
        return pulumi.get(self, "xs_master_username")

    @xs_master_username.setter
    def xs_master_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_username", value)


@pulumi.input_type
class _FoundationImageNodesState:
    def __init__(__self__, *,
                 blocks: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]]] = None,
                 cluster_urls: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterUrlArgs']]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]] = None,
                 cvm_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 cvm_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 eos_metadata: Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']] = None,
                 fc_settings: Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']] = None,
                 hyperv_external_vnic: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_external_vswitch: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_product_key: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_sku: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisor_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_iso: Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']] = None,
                 hypervisor_nameserver: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_password: Optional[pulumi.Input[_builtins.str]] = None,
                 install_script: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_user: Optional[pulumi.Input[_builtins.str]] = None,
                 layout_egg_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 nos_package: Optional[pulumi.Input[_builtins.str]] = None,
                 session_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_hypervisor: Optional[pulumi.Input[_builtins.bool]] = None,
                 svm_rescue_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tests: Optional[pulumi.Input['FoundationImageNodesTestsArgs']] = None,
                 ucsm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_user: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_path: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_username: Optional[pulumi.Input[_builtins.str]] = None,
                 xen_config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_label: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FoundationImageNodes resources.
        :param pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterUrlArgs']]] cluster_urls: - list containing cluster name and cluster urls for created clusters in current session
               * `cluster_urls.#.cluster_name` :- cluster_name
               * `cluster_urls.#.cluster_url` :- url to access the cluster login
        :param pulumi.Input[_builtins.str] cvm_gateway: - (Required) CVM gateway.
        :param pulumi.Input[_builtins.str] cvm_netmask: - (Required) CVM netmask.
        :param pulumi.Input['FoundationImageNodesEosMetadataArgs'] eos_metadata: - Contains user data from Eos portal.
        :param pulumi.Input['FoundationImageNodesFcSettingsArgs'] fc_settings: - Foundation Central specific settings.
        :param pulumi.Input[_builtins.str] hyperv_external_vnic: - Hyperv External virtual network adapter name.
        :param pulumi.Input[_builtins.str] hyperv_external_vswitch: - Hyperv External vswitch name.
        :param pulumi.Input[_builtins.str] hyperv_product_key: - Hyperv product key.
        :param pulumi.Input[_builtins.bool] hyperv_sku: - Hyperv SKU.
        :param pulumi.Input[_builtins.str] hypervisor_gateway: - (Required) Hypervisor gateway.
        :param pulumi.Input['FoundationImageNodesHypervisorIsoArgs'] hypervisor_iso: - Hypervisor ISO.
        :param pulumi.Input[_builtins.str] hypervisor_netmask: - (Required) Hypervisor netmask.
        :param pulumi.Input[_builtins.str] hypervisor_password: - Hypervisor password.
        :param pulumi.Input[_builtins.str] install_script: - install script.
        :param pulumi.Input[_builtins.str] ipmi_gateway: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        :param pulumi.Input[_builtins.str] ipmi_netmask: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        :param pulumi.Input[_builtins.str] ipmi_password: - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        :param pulumi.Input[_builtins.str] ipmi_user: - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        :param pulumi.Input[_builtins.str] layout_egg_uuid: - Id of the custom layout which needs to be passed to imaging request.
        :param pulumi.Input[_builtins.str] nos_package: - (Required) NOS package.
        :param pulumi.Input[_builtins.str] session_id: - session_id of the imaging session
        :param pulumi.Input[_builtins.bool] skip_hypervisor: - If hypervisor installation should be skipped.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] svm_rescue_args: - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        :param pulumi.Input['FoundationImageNodesTestsArgs'] tests: - Types of tests to be performed.
        :param pulumi.Input[_builtins.str] ucsm_ip: - UCSM IP address.
        :param pulumi.Input[_builtins.str] ucsm_password: - UCSM password.
        :param pulumi.Input[_builtins.str] ucsm_user: - UCSM username.
        :param pulumi.Input[_builtins.str] unc_password: - UNC password.
        :param pulumi.Input[_builtins.str] unc_path: - UNC Path.
        :param pulumi.Input[_builtins.str] unc_username: - UNC username.
        :param pulumi.Input[_builtins.str] xen_config_type: - xen config types.
        :param pulumi.Input[_builtins.str] xs_master_ip: - xen server master IP address.
        :param pulumi.Input[_builtins.str] xs_master_label: - xen server master label.
        :param pulumi.Input[_builtins.str] xs_master_password: - xen server master password.
        :param pulumi.Input[_builtins.str] xs_master_username: - xen server master username.
        """
        if blocks is not None:
            pulumi.set(__self__, "blocks", blocks)
        if cluster_urls is not None:
            pulumi.set(__self__, "cluster_urls", cluster_urls)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if cvm_gateway is not None:
            pulumi.set(__self__, "cvm_gateway", cvm_gateway)
        if cvm_netmask is not None:
            pulumi.set(__self__, "cvm_netmask", cvm_netmask)
        if eos_metadata is not None:
            pulumi.set(__self__, "eos_metadata", eos_metadata)
        if fc_settings is not None:
            pulumi.set(__self__, "fc_settings", fc_settings)
        if hyperv_external_vnic is not None:
            pulumi.set(__self__, "hyperv_external_vnic", hyperv_external_vnic)
        if hyperv_external_vswitch is not None:
            pulumi.set(__self__, "hyperv_external_vswitch", hyperv_external_vswitch)
        if hyperv_product_key is not None:
            pulumi.set(__self__, "hyperv_product_key", hyperv_product_key)
        if hyperv_sku is not None:
            pulumi.set(__self__, "hyperv_sku", hyperv_sku)
        if hypervisor_gateway is not None:
            pulumi.set(__self__, "hypervisor_gateway", hypervisor_gateway)
        if hypervisor_iso is not None:
            pulumi.set(__self__, "hypervisor_iso", hypervisor_iso)
        if hypervisor_nameserver is not None:
            pulumi.set(__self__, "hypervisor_nameserver", hypervisor_nameserver)
        if hypervisor_netmask is not None:
            pulumi.set(__self__, "hypervisor_netmask", hypervisor_netmask)
        if hypervisor_password is not None:
            pulumi.set(__self__, "hypervisor_password", hypervisor_password)
        if install_script is not None:
            pulumi.set(__self__, "install_script", install_script)
        if ipmi_gateway is not None:
            pulumi.set(__self__, "ipmi_gateway", ipmi_gateway)
        if ipmi_netmask is not None:
            pulumi.set(__self__, "ipmi_netmask", ipmi_netmask)
        if ipmi_password is not None:
            pulumi.set(__self__, "ipmi_password", ipmi_password)
        if ipmi_user is not None:
            pulumi.set(__self__, "ipmi_user", ipmi_user)
        if layout_egg_uuid is not None:
            pulumi.set(__self__, "layout_egg_uuid", layout_egg_uuid)
        if nos_package is not None:
            pulumi.set(__self__, "nos_package", nos_package)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if skip_hypervisor is not None:
            pulumi.set(__self__, "skip_hypervisor", skip_hypervisor)
        if svm_rescue_args is not None:
            pulumi.set(__self__, "svm_rescue_args", svm_rescue_args)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)
        if ucsm_ip is not None:
            pulumi.set(__self__, "ucsm_ip", ucsm_ip)
        if ucsm_password is not None:
            pulumi.set(__self__, "ucsm_password", ucsm_password)
        if ucsm_user is not None:
            pulumi.set(__self__, "ucsm_user", ucsm_user)
        if unc_password is not None:
            pulumi.set(__self__, "unc_password", unc_password)
        if unc_path is not None:
            pulumi.set(__self__, "unc_path", unc_path)
        if unc_username is not None:
            pulumi.set(__self__, "unc_username", unc_username)
        if xen_config_type is not None:
            pulumi.set(__self__, "xen_config_type", xen_config_type)
        if xs_master_ip is not None:
            pulumi.set(__self__, "xs_master_ip", xs_master_ip)
        if xs_master_label is not None:
            pulumi.set(__self__, "xs_master_label", xs_master_label)
        if xs_master_password is not None:
            pulumi.set(__self__, "xs_master_password", xs_master_password)
        if xs_master_username is not None:
            pulumi.set(__self__, "xs_master_username", xs_master_username)

    @_builtins.property
    @pulumi.getter
    def blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]]]:
        return pulumi.get(self, "blocks")

    @blocks.setter
    def blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesBlockArgs']]]]):
        pulumi.set(self, "blocks", value)

    @_builtins.property
    @pulumi.getter(name="clusterUrls")
    def cluster_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterUrlArgs']]]]:
        """
        - list containing cluster name and cluster urls for created clusters in current session
        * `cluster_urls.#.cluster_name` :- cluster_name
        * `cluster_urls.#.cluster_url` :- url to access the cluster login
        """
        return pulumi.get(self, "cluster_urls")

    @cluster_urls.setter
    def cluster_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterUrlArgs']]]]):
        pulumi.set(self, "cluster_urls", value)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]]:
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FoundationImageNodesClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter(name="cvmGateway")
    def cvm_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) CVM gateway.
        """
        return pulumi.get(self, "cvm_gateway")

    @cvm_gateway.setter
    def cvm_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cvm_gateway", value)

    @_builtins.property
    @pulumi.getter(name="cvmNetmask")
    def cvm_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) CVM netmask.
        """
        return pulumi.get(self, "cvm_netmask")

    @cvm_netmask.setter
    def cvm_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cvm_netmask", value)

    @_builtins.property
    @pulumi.getter(name="eosMetadata")
    def eos_metadata(self) -> Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']]:
        """
        - Contains user data from Eos portal.
        """
        return pulumi.get(self, "eos_metadata")

    @eos_metadata.setter
    def eos_metadata(self, value: Optional[pulumi.Input['FoundationImageNodesEosMetadataArgs']]):
        pulumi.set(self, "eos_metadata", value)

    @_builtins.property
    @pulumi.getter(name="fcSettings")
    def fc_settings(self) -> Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']]:
        """
        - Foundation Central specific settings.
        """
        return pulumi.get(self, "fc_settings")

    @fc_settings.setter
    def fc_settings(self, value: Optional[pulumi.Input['FoundationImageNodesFcSettingsArgs']]):
        pulumi.set(self, "fc_settings", value)

    @_builtins.property
    @pulumi.getter(name="hypervExternalVnic")
    def hyperv_external_vnic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv External virtual network adapter name.
        """
        return pulumi.get(self, "hyperv_external_vnic")

    @hyperv_external_vnic.setter
    def hyperv_external_vnic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_external_vnic", value)

    @_builtins.property
    @pulumi.getter(name="hypervExternalVswitch")
    def hyperv_external_vswitch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv External vswitch name.
        """
        return pulumi.get(self, "hyperv_external_vswitch")

    @hyperv_external_vswitch.setter
    def hyperv_external_vswitch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_external_vswitch", value)

    @_builtins.property
    @pulumi.getter(name="hypervProductKey")
    def hyperv_product_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hyperv product key.
        """
        return pulumi.get(self, "hyperv_product_key")

    @hyperv_product_key.setter
    def hyperv_product_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_product_key", value)

    @_builtins.property
    @pulumi.getter(name="hypervSku")
    def hyperv_sku(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Hyperv SKU.
        """
        return pulumi.get(self, "hyperv_sku")

    @hyperv_sku.setter
    def hyperv_sku(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hyperv_sku", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorGateway")
    def hypervisor_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Hypervisor gateway.
        """
        return pulumi.get(self, "hypervisor_gateway")

    @hypervisor_gateway.setter
    def hypervisor_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_gateway", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorIso")
    def hypervisor_iso(self) -> Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']]:
        """
        - Hypervisor ISO.
        """
        return pulumi.get(self, "hypervisor_iso")

    @hypervisor_iso.setter
    def hypervisor_iso(self, value: Optional[pulumi.Input['FoundationImageNodesHypervisorIsoArgs']]):
        pulumi.set(self, "hypervisor_iso", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorNameserver")
    def hypervisor_nameserver(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hypervisor_nameserver")

    @hypervisor_nameserver.setter
    def hypervisor_nameserver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_nameserver", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorNetmask")
    def hypervisor_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Hypervisor netmask.
        """
        return pulumi.get(self, "hypervisor_netmask")

    @hypervisor_netmask.setter
    def hypervisor_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_netmask", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorPassword")
    def hypervisor_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Hypervisor password.
        """
        return pulumi.get(self, "hypervisor_password")

    @hypervisor_password.setter
    def hypervisor_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_password", value)

    @_builtins.property
    @pulumi.getter(name="installScript")
    def install_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - install script.
        """
        return pulumi.get(self, "install_script")

    @install_script.setter
    def install_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "install_script", value)

    @_builtins.property
    @pulumi.getter(name="ipmiGateway")
    def ipmi_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        """
        return pulumi.get(self, "ipmi_gateway")

    @ipmi_gateway.setter
    def ipmi_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipmiNetmask")
    def ipmi_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        """
        return pulumi.get(self, "ipmi_netmask")

    @ipmi_netmask.setter
    def ipmi_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_netmask", value)

    @_builtins.property
    @pulumi.getter(name="ipmiPassword")
    def ipmi_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        """
        return pulumi.get(self, "ipmi_password")

    @ipmi_password.setter
    def ipmi_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_password", value)

    @_builtins.property
    @pulumi.getter(name="ipmiUser")
    def ipmi_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        """
        return pulumi.get(self, "ipmi_user")

    @ipmi_user.setter
    def ipmi_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipmi_user", value)

    @_builtins.property
    @pulumi.getter(name="layoutEggUuid")
    def layout_egg_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Id of the custom layout which needs to be passed to imaging request.
        """
        return pulumi.get(self, "layout_egg_uuid")

    @layout_egg_uuid.setter
    def layout_egg_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "layout_egg_uuid", value)

    @_builtins.property
    @pulumi.getter(name="nosPackage")
    def nos_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) NOS package.
        """
        return pulumi.get(self, "nos_package")

    @nos_package.setter
    def nos_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nos_package", value)

    @_builtins.property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - session_id of the imaging session
        """
        return pulumi.get(self, "session_id")

    @session_id.setter
    def session_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_id", value)

    @_builtins.property
    @pulumi.getter(name="skipHypervisor")
    def skip_hypervisor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - If hypervisor installation should be skipped.
        """
        return pulumi.get(self, "skip_hypervisor")

    @skip_hypervisor.setter
    def skip_hypervisor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_hypervisor", value)

    @_builtins.property
    @pulumi.getter(name="svmRescueArgs")
    def svm_rescue_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        """
        return pulumi.get(self, "svm_rescue_args")

    @svm_rescue_args.setter
    def svm_rescue_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "svm_rescue_args", value)

    @_builtins.property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input['FoundationImageNodesTestsArgs']]:
        """
        - Types of tests to be performed.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input['FoundationImageNodesTestsArgs']]):
        pulumi.set(self, "tests", value)

    @_builtins.property
    @pulumi.getter(name="ucsmIp")
    def ucsm_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM IP address.
        """
        return pulumi.get(self, "ucsm_ip")

    @ucsm_ip.setter
    def ucsm_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_ip", value)

    @_builtins.property
    @pulumi.getter(name="ucsmPassword")
    def ucsm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM password.
        """
        return pulumi.get(self, "ucsm_password")

    @ucsm_password.setter
    def ucsm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_password", value)

    @_builtins.property
    @pulumi.getter(name="ucsmUser")
    def ucsm_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UCSM username.
        """
        return pulumi.get(self, "ucsm_user")

    @ucsm_user.setter
    def ucsm_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ucsm_user", value)

    @_builtins.property
    @pulumi.getter(name="uncPassword")
    def unc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC password.
        """
        return pulumi.get(self, "unc_password")

    @unc_password.setter
    def unc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_password", value)

    @_builtins.property
    @pulumi.getter(name="uncPath")
    def unc_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC Path.
        """
        return pulumi.get(self, "unc_path")

    @unc_path.setter
    def unc_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_path", value)

    @_builtins.property
    @pulumi.getter(name="uncUsername")
    def unc_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - UNC username.
        """
        return pulumi.get(self, "unc_username")

    @unc_username.setter
    def unc_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unc_username", value)

    @_builtins.property
    @pulumi.getter(name="xenConfigType")
    def xen_config_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen config types.
        """
        return pulumi.get(self, "xen_config_type")

    @xen_config_type.setter
    def xen_config_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xen_config_type", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterIp")
    def xs_master_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master IP address.
        """
        return pulumi.get(self, "xs_master_ip")

    @xs_master_ip.setter
    def xs_master_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_ip", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterLabel")
    def xs_master_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master label.
        """
        return pulumi.get(self, "xs_master_label")

    @xs_master_label.setter
    def xs_master_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_label", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterPassword")
    def xs_master_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master password.
        """
        return pulumi.get(self, "xs_master_password")

    @xs_master_password.setter
    def xs_master_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_password", value)

    @_builtins.property
    @pulumi.getter(name="xsMasterUsername")
    def xs_master_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - xen server master username.
        """
        return pulumi.get(self, "xs_master_username")

    @xs_master_username.setter
    def xs_master_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xs_master_username", value)


@pulumi.type_token("nutanix:index/foundationImageNodes:FoundationImageNodes")
class FoundationImageNodes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesBlockArgs', 'FoundationImageNodesBlockArgsDict']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesClusterArgs', 'FoundationImageNodesClusterArgsDict']]]]] = None,
                 cvm_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 cvm_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 eos_metadata: Optional[pulumi.Input[Union['FoundationImageNodesEosMetadataArgs', 'FoundationImageNodesEosMetadataArgsDict']]] = None,
                 fc_settings: Optional[pulumi.Input[Union['FoundationImageNodesFcSettingsArgs', 'FoundationImageNodesFcSettingsArgsDict']]] = None,
                 hyperv_external_vnic: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_external_vswitch: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_product_key: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_sku: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisor_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_iso: Optional[pulumi.Input[Union['FoundationImageNodesHypervisorIsoArgs', 'FoundationImageNodesHypervisorIsoArgsDict']]] = None,
                 hypervisor_nameserver: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_password: Optional[pulumi.Input[_builtins.str]] = None,
                 install_script: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_user: Optional[pulumi.Input[_builtins.str]] = None,
                 layout_egg_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 nos_package: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_hypervisor: Optional[pulumi.Input[_builtins.bool]] = None,
                 svm_rescue_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tests: Optional[pulumi.Input[Union['FoundationImageNodesTestsArgs', 'FoundationImageNodesTestsArgsDict']]] = None,
                 ucsm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_user: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_path: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_username: Optional[pulumi.Input[_builtins.str]] = None,
                 xen_config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_label: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a FoundationImageNodes resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cvm_gateway: - (Required) CVM gateway.
        :param pulumi.Input[_builtins.str] cvm_netmask: - (Required) CVM netmask.
        :param pulumi.Input[Union['FoundationImageNodesEosMetadataArgs', 'FoundationImageNodesEosMetadataArgsDict']] eos_metadata: - Contains user data from Eos portal.
        :param pulumi.Input[Union['FoundationImageNodesFcSettingsArgs', 'FoundationImageNodesFcSettingsArgsDict']] fc_settings: - Foundation Central specific settings.
        :param pulumi.Input[_builtins.str] hyperv_external_vnic: - Hyperv External virtual network adapter name.
        :param pulumi.Input[_builtins.str] hyperv_external_vswitch: - Hyperv External vswitch name.
        :param pulumi.Input[_builtins.str] hyperv_product_key: - Hyperv product key.
        :param pulumi.Input[_builtins.bool] hyperv_sku: - Hyperv SKU.
        :param pulumi.Input[_builtins.str] hypervisor_gateway: - (Required) Hypervisor gateway.
        :param pulumi.Input[Union['FoundationImageNodesHypervisorIsoArgs', 'FoundationImageNodesHypervisorIsoArgsDict']] hypervisor_iso: - Hypervisor ISO.
        :param pulumi.Input[_builtins.str] hypervisor_netmask: - (Required) Hypervisor netmask.
        :param pulumi.Input[_builtins.str] hypervisor_password: - Hypervisor password.
        :param pulumi.Input[_builtins.str] install_script: - install script.
        :param pulumi.Input[_builtins.str] ipmi_gateway: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        :param pulumi.Input[_builtins.str] ipmi_netmask: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        :param pulumi.Input[_builtins.str] ipmi_password: - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        :param pulumi.Input[_builtins.str] ipmi_user: - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        :param pulumi.Input[_builtins.str] layout_egg_uuid: - Id of the custom layout which needs to be passed to imaging request.
        :param pulumi.Input[_builtins.str] nos_package: - (Required) NOS package.
        :param pulumi.Input[_builtins.bool] skip_hypervisor: - If hypervisor installation should be skipped.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] svm_rescue_args: - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        :param pulumi.Input[Union['FoundationImageNodesTestsArgs', 'FoundationImageNodesTestsArgsDict']] tests: - Types of tests to be performed.
        :param pulumi.Input[_builtins.str] ucsm_ip: - UCSM IP address.
        :param pulumi.Input[_builtins.str] ucsm_password: - UCSM password.
        :param pulumi.Input[_builtins.str] ucsm_user: - UCSM username.
        :param pulumi.Input[_builtins.str] unc_password: - UNC password.
        :param pulumi.Input[_builtins.str] unc_path: - UNC Path.
        :param pulumi.Input[_builtins.str] unc_username: - UNC username.
        :param pulumi.Input[_builtins.str] xen_config_type: - xen config types.
        :param pulumi.Input[_builtins.str] xs_master_ip: - xen server master IP address.
        :param pulumi.Input[_builtins.str] xs_master_label: - xen server master label.
        :param pulumi.Input[_builtins.str] xs_master_password: - xen server master password.
        :param pulumi.Input[_builtins.str] xs_master_username: - xen server master username.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FoundationImageNodesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FoundationImageNodes resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FoundationImageNodesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FoundationImageNodesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesBlockArgs', 'FoundationImageNodesBlockArgsDict']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesClusterArgs', 'FoundationImageNodesClusterArgsDict']]]]] = None,
                 cvm_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 cvm_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 eos_metadata: Optional[pulumi.Input[Union['FoundationImageNodesEosMetadataArgs', 'FoundationImageNodesEosMetadataArgsDict']]] = None,
                 fc_settings: Optional[pulumi.Input[Union['FoundationImageNodesFcSettingsArgs', 'FoundationImageNodesFcSettingsArgsDict']]] = None,
                 hyperv_external_vnic: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_external_vswitch: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_product_key: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_sku: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisor_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_iso: Optional[pulumi.Input[Union['FoundationImageNodesHypervisorIsoArgs', 'FoundationImageNodesHypervisorIsoArgsDict']]] = None,
                 hypervisor_nameserver: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_password: Optional[pulumi.Input[_builtins.str]] = None,
                 install_script: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ipmi_user: Optional[pulumi.Input[_builtins.str]] = None,
                 layout_egg_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 nos_package: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_hypervisor: Optional[pulumi.Input[_builtins.bool]] = None,
                 svm_rescue_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tests: Optional[pulumi.Input[Union['FoundationImageNodesTestsArgs', 'FoundationImageNodesTestsArgsDict']]] = None,
                 ucsm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ucsm_user: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_path: Optional[pulumi.Input[_builtins.str]] = None,
                 unc_username: Optional[pulumi.Input[_builtins.str]] = None,
                 xen_config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_label: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 xs_master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FoundationImageNodesArgs.__new__(FoundationImageNodesArgs)

            if blocks is None and not opts.urn:
                raise TypeError("Missing required property 'blocks'")
            __props__.__dict__["blocks"] = blocks
            __props__.__dict__["clusters"] = clusters
            if cvm_gateway is None and not opts.urn:
                raise TypeError("Missing required property 'cvm_gateway'")
            __props__.__dict__["cvm_gateway"] = cvm_gateway
            if cvm_netmask is None and not opts.urn:
                raise TypeError("Missing required property 'cvm_netmask'")
            __props__.__dict__["cvm_netmask"] = cvm_netmask
            __props__.__dict__["eos_metadata"] = eos_metadata
            __props__.__dict__["fc_settings"] = fc_settings
            __props__.__dict__["hyperv_external_vnic"] = hyperv_external_vnic
            __props__.__dict__["hyperv_external_vswitch"] = hyperv_external_vswitch
            __props__.__dict__["hyperv_product_key"] = hyperv_product_key
            __props__.__dict__["hyperv_sku"] = hyperv_sku
            if hypervisor_gateway is None and not opts.urn:
                raise TypeError("Missing required property 'hypervisor_gateway'")
            __props__.__dict__["hypervisor_gateway"] = hypervisor_gateway
            __props__.__dict__["hypervisor_iso"] = hypervisor_iso
            __props__.__dict__["hypervisor_nameserver"] = hypervisor_nameserver
            if hypervisor_netmask is None and not opts.urn:
                raise TypeError("Missing required property 'hypervisor_netmask'")
            __props__.__dict__["hypervisor_netmask"] = hypervisor_netmask
            __props__.__dict__["hypervisor_password"] = hypervisor_password
            __props__.__dict__["install_script"] = install_script
            __props__.__dict__["ipmi_gateway"] = ipmi_gateway
            __props__.__dict__["ipmi_netmask"] = ipmi_netmask
            __props__.__dict__["ipmi_password"] = ipmi_password
            __props__.__dict__["ipmi_user"] = ipmi_user
            __props__.__dict__["layout_egg_uuid"] = layout_egg_uuid
            if nos_package is None and not opts.urn:
                raise TypeError("Missing required property 'nos_package'")
            __props__.__dict__["nos_package"] = nos_package
            __props__.__dict__["skip_hypervisor"] = skip_hypervisor
            __props__.__dict__["svm_rescue_args"] = svm_rescue_args
            __props__.__dict__["tests"] = tests
            __props__.__dict__["ucsm_ip"] = ucsm_ip
            __props__.__dict__["ucsm_password"] = ucsm_password
            __props__.__dict__["ucsm_user"] = ucsm_user
            __props__.__dict__["unc_password"] = unc_password
            __props__.__dict__["unc_path"] = unc_path
            __props__.__dict__["unc_username"] = unc_username
            __props__.__dict__["xen_config_type"] = xen_config_type
            __props__.__dict__["xs_master_ip"] = xs_master_ip
            __props__.__dict__["xs_master_label"] = xs_master_label
            __props__.__dict__["xs_master_password"] = xs_master_password
            __props__.__dict__["xs_master_username"] = xs_master_username
            __props__.__dict__["cluster_urls"] = None
            __props__.__dict__["session_id"] = None
        super(FoundationImageNodes, __self__).__init__(
            'nutanix:index/foundationImageNodes:FoundationImageNodes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blocks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesBlockArgs', 'FoundationImageNodesBlockArgsDict']]]]] = None,
            cluster_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesClusterUrlArgs', 'FoundationImageNodesClusterUrlArgsDict']]]]] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesClusterArgs', 'FoundationImageNodesClusterArgsDict']]]]] = None,
            cvm_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            cvm_netmask: Optional[pulumi.Input[_builtins.str]] = None,
            eos_metadata: Optional[pulumi.Input[Union['FoundationImageNodesEosMetadataArgs', 'FoundationImageNodesEosMetadataArgsDict']]] = None,
            fc_settings: Optional[pulumi.Input[Union['FoundationImageNodesFcSettingsArgs', 'FoundationImageNodesFcSettingsArgsDict']]] = None,
            hyperv_external_vnic: Optional[pulumi.Input[_builtins.str]] = None,
            hyperv_external_vswitch: Optional[pulumi.Input[_builtins.str]] = None,
            hyperv_product_key: Optional[pulumi.Input[_builtins.str]] = None,
            hyperv_sku: Optional[pulumi.Input[_builtins.bool]] = None,
            hypervisor_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            hypervisor_iso: Optional[pulumi.Input[Union['FoundationImageNodesHypervisorIsoArgs', 'FoundationImageNodesHypervisorIsoArgsDict']]] = None,
            hypervisor_nameserver: Optional[pulumi.Input[_builtins.str]] = None,
            hypervisor_netmask: Optional[pulumi.Input[_builtins.str]] = None,
            hypervisor_password: Optional[pulumi.Input[_builtins.str]] = None,
            install_script: Optional[pulumi.Input[_builtins.str]] = None,
            ipmi_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            ipmi_netmask: Optional[pulumi.Input[_builtins.str]] = None,
            ipmi_password: Optional[pulumi.Input[_builtins.str]] = None,
            ipmi_user: Optional[pulumi.Input[_builtins.str]] = None,
            layout_egg_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            nos_package: Optional[pulumi.Input[_builtins.str]] = None,
            session_id: Optional[pulumi.Input[_builtins.str]] = None,
            skip_hypervisor: Optional[pulumi.Input[_builtins.bool]] = None,
            svm_rescue_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tests: Optional[pulumi.Input[Union['FoundationImageNodesTestsArgs', 'FoundationImageNodesTestsArgsDict']]] = None,
            ucsm_ip: Optional[pulumi.Input[_builtins.str]] = None,
            ucsm_password: Optional[pulumi.Input[_builtins.str]] = None,
            ucsm_user: Optional[pulumi.Input[_builtins.str]] = None,
            unc_password: Optional[pulumi.Input[_builtins.str]] = None,
            unc_path: Optional[pulumi.Input[_builtins.str]] = None,
            unc_username: Optional[pulumi.Input[_builtins.str]] = None,
            xen_config_type: Optional[pulumi.Input[_builtins.str]] = None,
            xs_master_ip: Optional[pulumi.Input[_builtins.str]] = None,
            xs_master_label: Optional[pulumi.Input[_builtins.str]] = None,
            xs_master_password: Optional[pulumi.Input[_builtins.str]] = None,
            xs_master_username: Optional[pulumi.Input[_builtins.str]] = None) -> 'FoundationImageNodes':
        """
        Get an existing FoundationImageNodes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FoundationImageNodesClusterUrlArgs', 'FoundationImageNodesClusterUrlArgsDict']]]] cluster_urls: - list containing cluster name and cluster urls for created clusters in current session
               * `cluster_urls.#.cluster_name` :- cluster_name
               * `cluster_urls.#.cluster_url` :- url to access the cluster login
        :param pulumi.Input[_builtins.str] cvm_gateway: - (Required) CVM gateway.
        :param pulumi.Input[_builtins.str] cvm_netmask: - (Required) CVM netmask.
        :param pulumi.Input[Union['FoundationImageNodesEosMetadataArgs', 'FoundationImageNodesEosMetadataArgsDict']] eos_metadata: - Contains user data from Eos portal.
        :param pulumi.Input[Union['FoundationImageNodesFcSettingsArgs', 'FoundationImageNodesFcSettingsArgsDict']] fc_settings: - Foundation Central specific settings.
        :param pulumi.Input[_builtins.str] hyperv_external_vnic: - Hyperv External virtual network adapter name.
        :param pulumi.Input[_builtins.str] hyperv_external_vswitch: - Hyperv External vswitch name.
        :param pulumi.Input[_builtins.str] hyperv_product_key: - Hyperv product key.
        :param pulumi.Input[_builtins.bool] hyperv_sku: - Hyperv SKU.
        :param pulumi.Input[_builtins.str] hypervisor_gateway: - (Required) Hypervisor gateway.
        :param pulumi.Input[Union['FoundationImageNodesHypervisorIsoArgs', 'FoundationImageNodesHypervisorIsoArgsDict']] hypervisor_iso: - Hypervisor ISO.
        :param pulumi.Input[_builtins.str] hypervisor_netmask: - (Required) Hypervisor netmask.
        :param pulumi.Input[_builtins.str] hypervisor_password: - Hypervisor password.
        :param pulumi.Input[_builtins.str] install_script: - install script.
        :param pulumi.Input[_builtins.str] ipmi_gateway: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        :param pulumi.Input[_builtins.str] ipmi_netmask: - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        :param pulumi.Input[_builtins.str] ipmi_password: - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        :param pulumi.Input[_builtins.str] ipmi_user: - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        :param pulumi.Input[_builtins.str] layout_egg_uuid: - Id of the custom layout which needs to be passed to imaging request.
        :param pulumi.Input[_builtins.str] nos_package: - (Required) NOS package.
        :param pulumi.Input[_builtins.str] session_id: - session_id of the imaging session
        :param pulumi.Input[_builtins.bool] skip_hypervisor: - If hypervisor installation should be skipped.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] svm_rescue_args: - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        :param pulumi.Input[Union['FoundationImageNodesTestsArgs', 'FoundationImageNodesTestsArgsDict']] tests: - Types of tests to be performed.
        :param pulumi.Input[_builtins.str] ucsm_ip: - UCSM IP address.
        :param pulumi.Input[_builtins.str] ucsm_password: - UCSM password.
        :param pulumi.Input[_builtins.str] ucsm_user: - UCSM username.
        :param pulumi.Input[_builtins.str] unc_password: - UNC password.
        :param pulumi.Input[_builtins.str] unc_path: - UNC Path.
        :param pulumi.Input[_builtins.str] unc_username: - UNC username.
        :param pulumi.Input[_builtins.str] xen_config_type: - xen config types.
        :param pulumi.Input[_builtins.str] xs_master_ip: - xen server master IP address.
        :param pulumi.Input[_builtins.str] xs_master_label: - xen server master label.
        :param pulumi.Input[_builtins.str] xs_master_password: - xen server master password.
        :param pulumi.Input[_builtins.str] xs_master_username: - xen server master username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FoundationImageNodesState.__new__(_FoundationImageNodesState)

        __props__.__dict__["blocks"] = blocks
        __props__.__dict__["cluster_urls"] = cluster_urls
        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["cvm_gateway"] = cvm_gateway
        __props__.__dict__["cvm_netmask"] = cvm_netmask
        __props__.__dict__["eos_metadata"] = eos_metadata
        __props__.__dict__["fc_settings"] = fc_settings
        __props__.__dict__["hyperv_external_vnic"] = hyperv_external_vnic
        __props__.__dict__["hyperv_external_vswitch"] = hyperv_external_vswitch
        __props__.__dict__["hyperv_product_key"] = hyperv_product_key
        __props__.__dict__["hyperv_sku"] = hyperv_sku
        __props__.__dict__["hypervisor_gateway"] = hypervisor_gateway
        __props__.__dict__["hypervisor_iso"] = hypervisor_iso
        __props__.__dict__["hypervisor_nameserver"] = hypervisor_nameserver
        __props__.__dict__["hypervisor_netmask"] = hypervisor_netmask
        __props__.__dict__["hypervisor_password"] = hypervisor_password
        __props__.__dict__["install_script"] = install_script
        __props__.__dict__["ipmi_gateway"] = ipmi_gateway
        __props__.__dict__["ipmi_netmask"] = ipmi_netmask
        __props__.__dict__["ipmi_password"] = ipmi_password
        __props__.__dict__["ipmi_user"] = ipmi_user
        __props__.__dict__["layout_egg_uuid"] = layout_egg_uuid
        __props__.__dict__["nos_package"] = nos_package
        __props__.__dict__["session_id"] = session_id
        __props__.__dict__["skip_hypervisor"] = skip_hypervisor
        __props__.__dict__["svm_rescue_args"] = svm_rescue_args
        __props__.__dict__["tests"] = tests
        __props__.__dict__["ucsm_ip"] = ucsm_ip
        __props__.__dict__["ucsm_password"] = ucsm_password
        __props__.__dict__["ucsm_user"] = ucsm_user
        __props__.__dict__["unc_password"] = unc_password
        __props__.__dict__["unc_path"] = unc_path
        __props__.__dict__["unc_username"] = unc_username
        __props__.__dict__["xen_config_type"] = xen_config_type
        __props__.__dict__["xs_master_ip"] = xs_master_ip
        __props__.__dict__["xs_master_label"] = xs_master_label
        __props__.__dict__["xs_master_password"] = xs_master_password
        __props__.__dict__["xs_master_username"] = xs_master_username
        return FoundationImageNodes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def blocks(self) -> pulumi.Output[Sequence['outputs.FoundationImageNodesBlock']]:
        return pulumi.get(self, "blocks")

    @_builtins.property
    @pulumi.getter(name="clusterUrls")
    def cluster_urls(self) -> pulumi.Output[Sequence['outputs.FoundationImageNodesClusterUrl']]:
        """
        - list containing cluster name and cluster urls for created clusters in current session
        * `cluster_urls.#.cluster_name` :- cluster_name
        * `cluster_urls.#.cluster_url` :- url to access the cluster login
        """
        return pulumi.get(self, "cluster_urls")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Optional[Sequence['outputs.FoundationImageNodesCluster']]]:
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="cvmGateway")
    def cvm_gateway(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) CVM gateway.
        """
        return pulumi.get(self, "cvm_gateway")

    @_builtins.property
    @pulumi.getter(name="cvmNetmask")
    def cvm_netmask(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) CVM netmask.
        """
        return pulumi.get(self, "cvm_netmask")

    @_builtins.property
    @pulumi.getter(name="eosMetadata")
    def eos_metadata(self) -> pulumi.Output[Optional['outputs.FoundationImageNodesEosMetadata']]:
        """
        - Contains user data from Eos portal.
        """
        return pulumi.get(self, "eos_metadata")

    @_builtins.property
    @pulumi.getter(name="fcSettings")
    def fc_settings(self) -> pulumi.Output[Optional['outputs.FoundationImageNodesFcSettings']]:
        """
        - Foundation Central specific settings.
        """
        return pulumi.get(self, "fc_settings")

    @_builtins.property
    @pulumi.getter(name="hypervExternalVnic")
    def hyperv_external_vnic(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Hyperv External virtual network adapter name.
        """
        return pulumi.get(self, "hyperv_external_vnic")

    @_builtins.property
    @pulumi.getter(name="hypervExternalVswitch")
    def hyperv_external_vswitch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Hyperv External vswitch name.
        """
        return pulumi.get(self, "hyperv_external_vswitch")

    @_builtins.property
    @pulumi.getter(name="hypervProductKey")
    def hyperv_product_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Hyperv product key.
        """
        return pulumi.get(self, "hyperv_product_key")

    @_builtins.property
    @pulumi.getter(name="hypervSku")
    def hyperv_sku(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - Hyperv SKU.
        """
        return pulumi.get(self, "hyperv_sku")

    @_builtins.property
    @pulumi.getter(name="hypervisorGateway")
    def hypervisor_gateway(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Hypervisor gateway.
        """
        return pulumi.get(self, "hypervisor_gateway")

    @_builtins.property
    @pulumi.getter(name="hypervisorIso")
    def hypervisor_iso(self) -> pulumi.Output[Optional['outputs.FoundationImageNodesHypervisorIso']]:
        """
        - Hypervisor ISO.
        """
        return pulumi.get(self, "hypervisor_iso")

    @_builtins.property
    @pulumi.getter(name="hypervisorNameserver")
    def hypervisor_nameserver(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "hypervisor_nameserver")

    @_builtins.property
    @pulumi.getter(name="hypervisorNetmask")
    def hypervisor_netmask(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Hypervisor netmask.
        """
        return pulumi.get(self, "hypervisor_netmask")

    @_builtins.property
    @pulumi.getter(name="hypervisorPassword")
    def hypervisor_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Hypervisor password.
        """
        return pulumi.get(self, "hypervisor_password")

    @_builtins.property
    @pulumi.getter(name="installScript")
    def install_script(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - install script.
        """
        return pulumi.get(self, "install_script")

    @_builtins.property
    @pulumi.getter(name="ipmiGateway")
    def ipmi_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI gateway
        """
        return pulumi.get(self, "ipmi_gateway")

    @_builtins.property
    @pulumi.getter(name="ipmiNetmask")
    def ipmi_netmask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) default IPMI netmask
        """
        return pulumi.get(self, "ipmi_netmask")

    @_builtins.property
    @pulumi.getter(name="ipmiPassword")
    def ipmi_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI password.
        """
        return pulumi.get(self, "ipmi_password")

    @_builtins.property
    @pulumi.getter(name="ipmiUser")
    def ipmi_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required incase using IPMI based imaging either here or inside node spec) IPMI username.
        """
        return pulumi.get(self, "ipmi_user")

    @_builtins.property
    @pulumi.getter(name="layoutEggUuid")
    def layout_egg_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Id of the custom layout which needs to be passed to imaging request.
        """
        return pulumi.get(self, "layout_egg_uuid")

    @_builtins.property
    @pulumi.getter(name="nosPackage")
    def nos_package(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) NOS package.
        """
        return pulumi.get(self, "nos_package")

    @_builtins.property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> pulumi.Output[_builtins.str]:
        """
        - session_id of the imaging session
        """
        return pulumi.get(self, "session_id")

    @_builtins.property
    @pulumi.getter(name="skipHypervisor")
    def skip_hypervisor(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - If hypervisor installation should be skipped.
        """
        return pulumi.get(self, "skip_hypervisor")

    @_builtins.property
    @pulumi.getter(name="svmRescueArgs")
    def svm_rescue_args(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        - Arguments to be passed to svm_rescue for AOS installation. Ensure that the arguments provided are supported by the AOS version used for imaging.
        """
        return pulumi.get(self, "svm_rescue_args")

    @_builtins.property
    @pulumi.getter
    def tests(self) -> pulumi.Output[Optional['outputs.FoundationImageNodesTests']]:
        """
        - Types of tests to be performed.
        """
        return pulumi.get(self, "tests")

    @_builtins.property
    @pulumi.getter(name="ucsmIp")
    def ucsm_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UCSM IP address.
        """
        return pulumi.get(self, "ucsm_ip")

    @_builtins.property
    @pulumi.getter(name="ucsmPassword")
    def ucsm_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UCSM password.
        """
        return pulumi.get(self, "ucsm_password")

    @_builtins.property
    @pulumi.getter(name="ucsmUser")
    def ucsm_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UCSM username.
        """
        return pulumi.get(self, "ucsm_user")

    @_builtins.property
    @pulumi.getter(name="uncPassword")
    def unc_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UNC password.
        """
        return pulumi.get(self, "unc_password")

    @_builtins.property
    @pulumi.getter(name="uncPath")
    def unc_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UNC Path.
        """
        return pulumi.get(self, "unc_path")

    @_builtins.property
    @pulumi.getter(name="uncUsername")
    def unc_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - UNC username.
        """
        return pulumi.get(self, "unc_username")

    @_builtins.property
    @pulumi.getter(name="xenConfigType")
    def xen_config_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - xen config types.
        """
        return pulumi.get(self, "xen_config_type")

    @_builtins.property
    @pulumi.getter(name="xsMasterIp")
    def xs_master_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - xen server master IP address.
        """
        return pulumi.get(self, "xs_master_ip")

    @_builtins.property
    @pulumi.getter(name="xsMasterLabel")
    def xs_master_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - xen server master label.
        """
        return pulumi.get(self, "xs_master_label")

    @_builtins.property
    @pulumi.getter(name="xsMasterPassword")
    def xs_master_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - xen server master password.
        """
        return pulumi.get(self, "xs_master_password")

    @_builtins.property
    @pulumi.getter(name="xsMasterUsername")
    def xs_master_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - xen server master username.
        """
        return pulumi.get(self, "xs_master_username")

