# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAddressGroupV2Result',
    'AwaitableGetAddressGroupV2Result',
    'get_address_group_v2',
    'get_address_group_v2_output',
]

@pulumi.output_type
class GetAddressGroupV2Result:
    """
    A collection of values returned by getAddressGroupV2.
    """
    def __init__(__self__, created_by=None, description=None, ext_id=None, id=None, ip_ranges=None, ipv4_addresses=None, links=None, name=None, policy_references=None, tenant_id=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_ranges and not isinstance(ip_ranges, list):
            raise TypeError("Expected argument 'ip_ranges' to be a list")
        pulumi.set(__self__, "ip_ranges", ip_ranges)
        if ipv4_addresses and not isinstance(ipv4_addresses, list):
            raise TypeError("Expected argument 'ipv4_addresses' to be a list")
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_references and not isinstance(policy_references, list):
            raise TypeError("Expected argument 'policy_references' to be a list")
        pulumi.set(__self__, "policy_references", policy_references)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        created by.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user defined annotation for an Address Group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Sequence['outputs.GetAddressGroupV2IpRangeResult']:
        """
        List of IP range containing start and end IP
        """
        return pulumi.get(self, "ip_ranges")

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence['outputs.GetAddressGroupV2Ipv4AddressResult']:
        """
        List of CIDR blocks in the Address Group.
        """
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetAddressGroupV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A short identifier for an Address Group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyReferences")
    def policy_references(self) -> Sequence[_builtins.str]:
        """
        Reference to policy associated with Address Group.
        """
        return pulumi.get(self, "policy_references")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetAddressGroupV2Result(GetAddressGroupV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressGroupV2Result(
            created_by=self.created_by,
            description=self.description,
            ext_id=self.ext_id,
            id=self.id,
            ip_ranges=self.ip_ranges,
            ipv4_addresses=self.ipv4_addresses,
            links=self.links,
            name=self.name,
            policy_references=self.policy_references,
            tenant_id=self.tenant_id)


def get_address_group_v2(ext_id: Optional[_builtins.str] = None,
                         ipv4_addresses: Optional[Sequence[Union['GetAddressGroupV2Ipv4AddressArgs', 'GetAddressGroupV2Ipv4AddressArgsDict']]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressGroupV2Result:
    """
    Get an Address Group by ExtID

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_addr_group = nutanix.get_address_group_v2(ext_id="0005b3b0-0b3b-4b3b-8b3b-0b3b3b3b3b3b")
    ```


    :param _builtins.str ext_id: Address group UUID.
    :param Sequence[Union['GetAddressGroupV2Ipv4AddressArgs', 'GetAddressGroupV2Ipv4AddressArgsDict']] ipv4_addresses: List of CIDR blocks in the Address Group.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['ipv4Addresses'] = ipv4_addresses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getAddressGroupV2:getAddressGroupV2', __args__, opts=opts, typ=GetAddressGroupV2Result).value

    return AwaitableGetAddressGroupV2Result(
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_ranges=pulumi.get(__ret__, 'ip_ranges'),
        ipv4_addresses=pulumi.get(__ret__, 'ipv4_addresses'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        policy_references=pulumi.get(__ret__, 'policy_references'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_address_group_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                ipv4_addresses: Optional[pulumi.Input[Optional[Sequence[Union['GetAddressGroupV2Ipv4AddressArgs', 'GetAddressGroupV2Ipv4AddressArgsDict']]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressGroupV2Result]:
    """
    Get an Address Group by ExtID

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_addr_group = nutanix.get_address_group_v2(ext_id="0005b3b0-0b3b-4b3b-8b3b-0b3b3b3b3b3b")
    ```


    :param _builtins.str ext_id: Address group UUID.
    :param Sequence[Union['GetAddressGroupV2Ipv4AddressArgs', 'GetAddressGroupV2Ipv4AddressArgsDict']] ipv4_addresses: List of CIDR blocks in the Address Group.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['ipv4Addresses'] = ipv4_addresses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getAddressGroupV2:getAddressGroupV2', __args__, opts=opts, typ=GetAddressGroupV2Result)
    return __ret__.apply(lambda __response__: GetAddressGroupV2Result(
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        ip_ranges=pulumi.get(__response__, 'ip_ranges'),
        ipv4_addresses=pulumi.get(__response__, 'ipv4_addresses'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        policy_references=pulumi.get(__response__, 'policy_references'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
