# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCategoriesV2Result',
    'AwaitableGetCategoriesV2Result',
    'get_categories_v2',
    'get_categories_v2_output',
]

@pulumi.output_type
class GetCategoriesV2Result:
    """
    A collection of values returned by getCategoriesV2.
    """
    def __init__(__self__, categories=None, expand=None, filter=None, id=None, limit=None, order_by=None, page=None, select=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if expand and not isinstance(expand, str):
            raise TypeError("Expected argument 'expand' to be a str")
        pulumi.set(__self__, "expand", expand)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetCategoriesV2CategoryResult']:
        """
        List of categories
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetCategoriesV2Result(GetCategoriesV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCategoriesV2Result(
            categories=self.categories,
            expand=self.expand,
            filter=self.filter,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select)


def get_categories_v2(expand: Optional[_builtins.str] = None,
                      filter: Optional[_builtins.str] = None,
                      limit: Optional[_builtins.int] = None,
                      order_by: Optional[_builtins.str] = None,
                      page: Optional[_builtins.int] = None,
                      select: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCategoriesV2Result:
    """
    List categories

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    categories_list = nutanix.get_categories_v2()
    categories_paginated = nutanix.get_categories_v2(page=1,
        limit=10)
    categories_sorted = nutanix.get_categories_v2(order_by="key desc")
    categories_filtered = nutanix.get_categories_v2(filter="key eq 'key_example'")
    pulumi.export("category", categories_list.categories[0])
    ```

    ## Categories

    The `categories` contains list of categories. Each category has the following attributes:

    * `ext_id`: The extID for the category.
    * `key`: The key of a category when it is represented in key:value format.
    * `value`: The value of a category when it is represented in key:value format
    * `type`: Denotes the type of a category.
      There are three types of categories: SYSTEM, INTERNAL, and USER.
    * `description`: A string consisting of the description of the category as defined by the user.
    * `owner_uuid`: This field contains the UUID of a user who owns the category.
    * `associations`: This field gives basic information about resources that are associated to the category.
    * `detailed_associations`: This field gives detailed information about resources that are associated to the category.
    * `tenant_id`: A globally unique identifier that represents the tenant that owns this entity.
    * `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    ### associations
    * `category_id`: External identifier for the given category, used across all v4 apis/entities/resources where categories are referenced.
    * `resource_type`: An enum denoting the associated resource types. Resource types are further grouped into 2 types - entity or a policy.
    * `resource_group`: An enum denoting the resource group.
      Resources can be organized into either an entity or a policy.
    * `count`: Count of associations of a particular type of entity or policy

    ### detailed_associations
    * `category_id`: External identifier for the given category, used across all v4 apis/entities/resources where categories are referenced.
    * `resource_type`: An enum denoting the associated resource types. Resource types are further grouped into 2 types - entity or a policy.
    * `resource_group`: An enum denoting the resource group.
      Resources can be organized into either an entity or a policy.
    * `resource_id`: The UUID of the entity or policy associated with the particular category.

    See detailed information in [Nutanix List Categories v4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/Categories/operation/listCategories).


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported:
           - associations
           - detailedAssociations
    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - extId
           - key
           - ownerUuid
           - type
           - value
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - key
           - value
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           - description
           - extId
           - key
           - ownerUuid
           - type
           - value
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getCategoriesV2:getCategoriesV2', __args__, opts=opts, typ=GetCategoriesV2Result).value

    return AwaitableGetCategoriesV2Result(
        categories=pulumi.get(__ret__, 'categories'),
        expand=pulumi.get(__ret__, 'expand'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'))
def get_categories_v2_output(expand: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCategoriesV2Result]:
    """
    List categories

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    categories_list = nutanix.get_categories_v2()
    categories_paginated = nutanix.get_categories_v2(page=1,
        limit=10)
    categories_sorted = nutanix.get_categories_v2(order_by="key desc")
    categories_filtered = nutanix.get_categories_v2(filter="key eq 'key_example'")
    pulumi.export("category", categories_list.categories[0])
    ```

    ## Categories

    The `categories` contains list of categories. Each category has the following attributes:

    * `ext_id`: The extID for the category.
    * `key`: The key of a category when it is represented in key:value format.
    * `value`: The value of a category when it is represented in key:value format
    * `type`: Denotes the type of a category.
      There are three types of categories: SYSTEM, INTERNAL, and USER.
    * `description`: A string consisting of the description of the category as defined by the user.
    * `owner_uuid`: This field contains the UUID of a user who owns the category.
    * `associations`: This field gives basic information about resources that are associated to the category.
    * `detailed_associations`: This field gives detailed information about resources that are associated to the category.
    * `tenant_id`: A globally unique identifier that represents the tenant that owns this entity.
    * `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    ### associations
    * `category_id`: External identifier for the given category, used across all v4 apis/entities/resources where categories are referenced.
    * `resource_type`: An enum denoting the associated resource types. Resource types are further grouped into 2 types - entity or a policy.
    * `resource_group`: An enum denoting the resource group.
      Resources can be organized into either an entity or a policy.
    * `count`: Count of associations of a particular type of entity or policy

    ### detailed_associations
    * `category_id`: External identifier for the given category, used across all v4 apis/entities/resources where categories are referenced.
    * `resource_type`: An enum denoting the associated resource types. Resource types are further grouped into 2 types - entity or a policy.
    * `resource_group`: An enum denoting the resource group.
      Resources can be organized into either an entity or a policy.
    * `resource_id`: The UUID of the entity or policy associated with the particular category.

    See detailed information in [Nutanix List Categories v4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/Categories/operation/listCategories).


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported:
           - associations
           - detailedAssociations
    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - extId
           - key
           - ownerUuid
           - type
           - value
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - key
           - value
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           - description
           - extId
           - key
           - ownerUuid
           - type
           - value
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getCategoriesV2:getCategoriesV2', __args__, opts=opts, typ=GetCategoriesV2Result)
    return __ret__.apply(lambda __response__: GetCategoriesV2Result(
        categories=pulumi.get(__response__, 'categories'),
        expand=pulumi.get(__response__, 'expand'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select')))
