# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCategoryKeyResult',
    'AwaitableGetCategoryKeyResult',
    'get_category_key',
    'get_category_key_output',
]

@pulumi.output_type
class GetCategoryKeyResult:
    """
    A collection of values returned by getCategoryKey.
    """
    def __init__(__self__, api_version=None, description=None, id=None, name=None, system_defined=None, values=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_defined and not isinstance(system_defined, bool):
            raise TypeError("Expected argument 'system_defined' to be a bool")
        pulumi.set(__self__, "system_defined", system_defined)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - A description for category key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="systemDefined")
    def system_defined(self) -> _builtins.bool:
        """
        - Specifying whether its a system defined category.
        """
        return pulumi.get(self, "system_defined")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        - A list of the values from this category key (if it has them).
        """
        return pulumi.get(self, "values")


class AwaitableGetCategoryKeyResult(GetCategoryKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCategoryKeyResult(
            api_version=self.api_version,
            description=self.description,
            id=self.id,
            name=self.name,
            system_defined=self.system_defined,
            values=self.values)


def get_category_key(name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCategoryKeyResult:
    """
    Describe a Nutanix Category Key and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_key_value_category_key = nutanix.CategoryKey("test_key_value",
        name="data_source_category_key_test_values",
        description="Data Source CategoryKey Test with Values")
    test_value = nutanix.CategoryValue("test_value",
        name=test_key_value_category_key.name,
        value="test_category_value_data_source",
        description="Data Source CategoryValue Test with Values")
    test_key_value = nutanix.get_category_key_output(name=test_key_value_category_key.name)
    ```


    :param _builtins.str name: - (Required) The name for the category key.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getCategoryKey:getCategoryKey', __args__, opts=opts, typ=GetCategoryKeyResult).value

    return AwaitableGetCategoryKeyResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        system_defined=pulumi.get(__ret__, 'system_defined'),
        values=pulumi.get(__ret__, 'values'))
def get_category_key_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCategoryKeyResult]:
    """
    Describe a Nutanix Category Key and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_key_value_category_key = nutanix.CategoryKey("test_key_value",
        name="data_source_category_key_test_values",
        description="Data Source CategoryKey Test with Values")
    test_value = nutanix.CategoryValue("test_value",
        name=test_key_value_category_key.name,
        value="test_category_value_data_source",
        description="Data Source CategoryValue Test with Values")
    test_key_value = nutanix.get_category_key_output(name=test_key_value_category_key.name)
    ```


    :param _builtins.str name: - (Required) The name for the category key.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getCategoryKey:getCategoryKey', __args__, opts=opts, typ=GetCategoryKeyResult)
    return __ret__.apply(lambda __response__: GetCategoryKeyResult(
        api_version=pulumi.get(__response__, 'api_version'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        system_defined=pulumi.get(__response__, 'system_defined'),
        values=pulumi.get(__response__, 'values')))
