# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCategoryV2Result',
    'AwaitableGetCategoryV2Result',
    'get_category_v2',
    'get_category_v2_output',
]

@pulumi.output_type
class GetCategoryV2Result:
    """
    A collection of values returned by getCategoryV2.
    """
    def __init__(__self__, associations=None, description=None, detailed_associations=None, expand=None, ext_id=None, id=None, key=None, links=None, owner_uuid=None, tenant_id=None, type=None, value=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if detailed_associations and not isinstance(detailed_associations, list):
            raise TypeError("Expected argument 'detailed_associations' to be a list")
        pulumi.set(__self__, "detailed_associations", detailed_associations)
        if expand and not isinstance(expand, str):
            raise TypeError("Expected argument 'expand' to be a str")
        pulumi.set(__self__, "expand", expand)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if owner_uuid and not isinstance(owner_uuid, str):
            raise TypeError("Expected argument 'owner_uuid' to be a str")
        pulumi.set(__self__, "owner_uuid", owner_uuid)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetCategoryV2AssociationResult']:
        """
        This field gives basic information about resources that are associated to the category.
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A string consisting of the description of the category as defined by the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detailedAssociations")
    def detailed_associations(self) -> Sequence['outputs.GetCategoryV2DetailedAssociationResult']:
        """
        This field gives detailed information about resources that are associated to the category.
        """
        return pulumi.get(self, "detailed_associations")

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of a category when it is represented in key:value format.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetCategoryV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> _builtins.str:
        """
        This field contains the UUID of a user who owns the category.
        """
        return pulumi.get(self, "owner_uuid")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Denotes the type of a category.
        There are three types of categories: SYSTEM, INTERNAL, and USER.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of a category when it is represented in key:value format
        """
        return pulumi.get(self, "value")


class AwaitableGetCategoryV2Result(GetCategoryV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCategoryV2Result(
            associations=self.associations,
            description=self.description,
            detailed_associations=self.detailed_associations,
            expand=self.expand,
            ext_id=self.ext_id,
            id=self.id,
            key=self.key,
            links=self.links,
            owner_uuid=self.owner_uuid,
            tenant_id=self.tenant_id,
            type=self.type,
            value=self.value)


def get_category_v2(expand: Optional[_builtins.str] = None,
                    ext_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCategoryV2Result:
    """
    Fetch a category

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_category = nutanix.get_category_v2(ext_id="85e68112-5b2b-4220-bc8d-e529e4bf420e")
    ```


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported:
           - associations
           - detailedAssociations
    :param _builtins.str ext_id: The extID for the category.
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getCategoryV2:getCategoryV2', __args__, opts=opts, typ=GetCategoryV2Result).value

    return AwaitableGetCategoryV2Result(
        associations=pulumi.get(__ret__, 'associations'),
        description=pulumi.get(__ret__, 'description'),
        detailed_associations=pulumi.get(__ret__, 'detailed_associations'),
        expand=pulumi.get(__ret__, 'expand'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        links=pulumi.get(__ret__, 'links'),
        owner_uuid=pulumi.get(__ret__, 'owner_uuid'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        type=pulumi.get(__ret__, 'type'),
        value=pulumi.get(__ret__, 'value'))
def get_category_v2_output(expand: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCategoryV2Result]:
    """
    Fetch a category

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_category = nutanix.get_category_v2(ext_id="85e68112-5b2b-4220-bc8d-e529e4bf420e")
    ```


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported:
           - associations
           - detailedAssociations
    :param _builtins.str ext_id: The extID for the category.
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getCategoryV2:getCategoryV2', __args__, opts=opts, typ=GetCategoryV2Result)
    return __ret__.apply(lambda __response__: GetCategoryV2Result(
        associations=pulumi.get(__response__, 'associations'),
        description=pulumi.get(__response__, 'description'),
        detailed_associations=pulumi.get(__response__, 'detailed_associations'),
        expand=pulumi.get(__response__, 'expand'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        links=pulumi.get(__response__, 'links'),
        owner_uuid=pulumi.get(__response__, 'owner_uuid'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        type=pulumi.get(__response__, 'type'),
        value=pulumi.get(__response__, 'value')))
