# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetClusterV2Result',
    'AwaitableGetClusterV2Result',
    'get_cluster_v2',
    'get_cluster_v2_output',
]

@pulumi.output_type
class GetClusterV2Result:
    """
    A collection of values returned by getClusterV2.
    """
    def __init__(__self__, backup_eligibility_score=None, categories=None, cluster_profile_ext_id=None, configs=None, container_name=None, expand=None, ext_id=None, id=None, inefficient_vm_count=None, links=None, name=None, networks=None, nodes=None, tenant_id=None, upgrade_status=None, vm_count=None):
        if backup_eligibility_score and not isinstance(backup_eligibility_score, int):
            raise TypeError("Expected argument 'backup_eligibility_score' to be a int")
        pulumi.set(__self__, "backup_eligibility_score", backup_eligibility_score)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if cluster_profile_ext_id and not isinstance(cluster_profile_ext_id, str):
            raise TypeError("Expected argument 'cluster_profile_ext_id' to be a str")
        pulumi.set(__self__, "cluster_profile_ext_id", cluster_profile_ext_id)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if container_name and not isinstance(container_name, str):
            raise TypeError("Expected argument 'container_name' to be a str")
        pulumi.set(__self__, "container_name", container_name)
        if expand and not isinstance(expand, str):
            raise TypeError("Expected argument 'expand' to be a str")
        pulumi.set(__self__, "expand", expand)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inefficient_vm_count and not isinstance(inefficient_vm_count, int):
            raise TypeError("Expected argument 'inefficient_vm_count' to be a int")
        pulumi.set(__self__, "inefficient_vm_count", inefficient_vm_count)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if upgrade_status and not isinstance(upgrade_status, str):
            raise TypeError("Expected argument 'upgrade_status' to be a str")
        pulumi.set(__self__, "upgrade_status", upgrade_status)
        if vm_count and not isinstance(vm_count, int):
            raise TypeError("Expected argument 'vm_count' to be a int")
        pulumi.set(__self__, "vm_count", vm_count)

    @_builtins.property
    @pulumi.getter(name="backupEligibilityScore")
    def backup_eligibility_score(self) -> _builtins.int:
        """
        -  Score to indicate how much cluster is eligible for storing domain manager backup.
        """
        return pulumi.get(self, "backup_eligibility_score")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        -  List of categories associated to the PE cluster.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="clusterProfileExtId")
    def cluster_profile_ext_id(self) -> _builtins.str:
        """
        -  Cluster profile UUID.
        """
        return pulumi.get(self, "cluster_profile_ext_id")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetClusterV2ConfigResult']:
        """
        -  Cluster configuration details.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> _builtins.str:
        """
        -  The name of the default container created as part of cluster creation. This is part of payload for cluster create operation only.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        -  A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inefficientVmCount")
    def inefficient_vm_count(self) -> _builtins.int:
        """
        -  Number of inefficient VMs in the cluster.
        """
        return pulumi.get(self, "inefficient_vm_count")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetClusterV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - HTTP Proxy server name configuration needed to access a cluster which is hosted behind a HTTP Proxy to not reveal its identity.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetClusterV2NetworkResult']:
        """
        -  Network details of a cluster.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetClusterV2NodeResult']:
        """
        -  Node reference for a cluster.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        -  globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="upgradeStatus")
    def upgrade_status(self) -> _builtins.str:
        """
        -  Upgrade status of a cluster.
        Valid values are:
        - "CANCELLED"	The cluster upgrade is cancelled.
        - "FAILED"	The cluster upgrade failed.
        - "QUEUED"	The cluster upgrade is in the queue.
        - "SUCCEEDED"	The cluster was upgraded successfully.
        - "DOWNLOADING" The luster upgrade is downloading.
        - "PENDING"The cluster upgrade is in pending state.
        - "UPGRADING" The cluster is in upgrade state.
        - "PREUPGRADE" The cluster is in pre-upgrade state.
        - "SCHEDULED" The cluster upgrade is in scheduled state.
        """
        return pulumi.get(self, "upgrade_status")

    @_builtins.property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> _builtins.int:
        """
        -  Number of VMs in the cluster.
        """
        return pulumi.get(self, "vm_count")


class AwaitableGetClusterV2Result(GetClusterV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterV2Result(
            backup_eligibility_score=self.backup_eligibility_score,
            categories=self.categories,
            cluster_profile_ext_id=self.cluster_profile_ext_id,
            configs=self.configs,
            container_name=self.container_name,
            expand=self.expand,
            ext_id=self.ext_id,
            id=self.id,
            inefficient_vm_count=self.inefficient_vm_count,
            links=self.links,
            name=self.name,
            networks=self.networks,
            nodes=self.nodes,
            tenant_id=self.tenant_id,
            upgrade_status=self.upgrade_status,
            vm_count=self.vm_count)


def get_cluster_v2(expand: Optional[_builtins.str] = None,
                   ext_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterV2Result:
    """
    Fetches the cluster entity details identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_cluster = nutanix.get_cluster_v2(ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
    ```


    :param _builtins.str expand: -(Optional) A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name.
           The following expansion keys are supported:
           - "clusterProfile".
           - "storageSummary".
    :param _builtins.str ext_id: -(Required) Represents clusters uuid
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getClusterV2:getClusterV2', __args__, opts=opts, typ=GetClusterV2Result).value

    return AwaitableGetClusterV2Result(
        backup_eligibility_score=pulumi.get(__ret__, 'backup_eligibility_score'),
        categories=pulumi.get(__ret__, 'categories'),
        cluster_profile_ext_id=pulumi.get(__ret__, 'cluster_profile_ext_id'),
        configs=pulumi.get(__ret__, 'configs'),
        container_name=pulumi.get(__ret__, 'container_name'),
        expand=pulumi.get(__ret__, 'expand'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        inefficient_vm_count=pulumi.get(__ret__, 'inefficient_vm_count'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        nodes=pulumi.get(__ret__, 'nodes'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        upgrade_status=pulumi.get(__ret__, 'upgrade_status'),
        vm_count=pulumi.get(__ret__, 'vm_count'))
def get_cluster_v2_output(expand: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterV2Result]:
    """
    Fetches the cluster entity details identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_cluster = nutanix.get_cluster_v2(ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
    ```


    :param _builtins.str expand: -(Optional) A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name.
           The following expansion keys are supported:
           - "clusterProfile".
           - "storageSummary".
    :param _builtins.str ext_id: -(Required) Represents clusters uuid
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getClusterV2:getClusterV2', __args__, opts=opts, typ=GetClusterV2Result)
    return __ret__.apply(lambda __response__: GetClusterV2Result(
        backup_eligibility_score=pulumi.get(__response__, 'backup_eligibility_score'),
        categories=pulumi.get(__response__, 'categories'),
        cluster_profile_ext_id=pulumi.get(__response__, 'cluster_profile_ext_id'),
        configs=pulumi.get(__response__, 'configs'),
        container_name=pulumi.get(__response__, 'container_name'),
        expand=pulumi.get(__response__, 'expand'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        inefficient_vm_count=pulumi.get(__response__, 'inefficient_vm_count'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        nodes=pulumi.get(__response__, 'nodes'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        upgrade_status=pulumi.get(__response__, 'upgrade_status'),
        vm_count=pulumi.get(__response__, 'vm_count')))
