# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, api_version=None, entities=None, id=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if entities and not isinstance(entities, list):
            raise TypeError("Expected argument 'entities' to be a list")
        pulumi.set(__self__, "entities", entities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The API version.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.GetClustersEntityResult']:
        """
        List of Clusters
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            api_version=self.api_version,
            entities=self.entities,
            id=self.id)


def get_clusters(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    Describes Clusters

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    clusters = nutanix.get_clusters()
    ```

    ## Reference

    The `project_reference`, `owner_reference`, `availability_zone_reference`, `cluster_reference`, attributes supports the following:

    * `kind`: - The kind name (Default value: project).
    * `name`: - the name.
    * `UUID`: - the UUID.

    ### Version

    The version attribute supports the following:

    * `product_name`: - Name of the producer/distribution of the image. For example windows or red hat.
    * `product_version`: - Version string for the disk image.

    See detailed information in [Nutanix Clusters](https://www.nutanix.dev/api_references/prism-central-v3/#/d93c30e04327e-get-a-list-of-existing-clusters).
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        entities=pulumi.get(__ret__, 'entities'),
        id=pulumi.get(__ret__, 'id'))
def get_clusters_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    Describes Clusters

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    clusters = nutanix.get_clusters()
    ```

    ## Reference

    The `project_reference`, `owner_reference`, `availability_zone_reference`, `cluster_reference`, attributes supports the following:

    * `kind`: - The kind name (Default value: project).
    * `name`: - the name.
    * `UUID`: - the UUID.

    ### Version

    The version attribute supports the following:

    * `product_name`: - Name of the producer/distribution of the image. For example windows or red hat.
    * `product_version`: - Version string for the disk image.

    See detailed information in [Nutanix Clusters](https://www.nutanix.dev/api_references/prism-central-v3/#/d93c30e04327e-get-a-list-of-existing-clusters).
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        api_version=pulumi.get(__response__, 'api_version'),
        entities=pulumi.get(__response__, 'entities'),
        id=pulumi.get(__response__, 'id')))
