# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDirectoryServiceV2Result',
    'AwaitableGetDirectoryServiceV2Result',
    'get_directory_service_v2',
    'get_directory_service_v2_output',
]

@pulumi.output_type
class GetDirectoryServiceV2Result:
    """
    A collection of values returned by getDirectoryServiceV2.
    """
    def __init__(__self__, created_by=None, created_time=None, directory_type=None, domain_name=None, ext_id=None, group_search_type=None, id=None, last_updated_time=None, name=None, open_ldap_configurations=None, secondary_urls=None, service_accounts=None, url=None, white_listed_groups=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if directory_type and not isinstance(directory_type, str):
            raise TypeError("Expected argument 'directory_type' to be a str")
        pulumi.set(__self__, "directory_type", directory_type)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if group_search_type and not isinstance(group_search_type, str):
            raise TypeError("Expected argument 'group_search_type' to be a str")
        pulumi.set(__self__, "group_search_type", group_search_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if open_ldap_configurations and not isinstance(open_ldap_configurations, list):
            raise TypeError("Expected argument 'open_ldap_configurations' to be a list")
        pulumi.set(__self__, "open_ldap_configurations", open_ldap_configurations)
        if secondary_urls and not isinstance(secondary_urls, list):
            raise TypeError("Expected argument 'secondary_urls' to be a list")
        pulumi.set(__self__, "secondary_urls", secondary_urls)
        if service_accounts and not isinstance(service_accounts, list):
            raise TypeError("Expected argument 'service_accounts' to be a list")
        pulumi.set(__self__, "service_accounts", service_accounts)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if white_listed_groups and not isinstance(white_listed_groups, list):
            raise TypeError("Expected argument 'white_listed_groups' to be a list")
        pulumi.set(__self__, "white_listed_groups", white_listed_groups)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        - User or Service who created the Directory Service.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        - Creation time of the Directory Service.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> _builtins.str:
        """
        - Type of Directory Service, Supported values are: "ACTIVE_DIRECTORY" (Directory Service type is Active Directory.) and "OPEN_LDAP" (Directory Service type is Open LDAP.)
        """
        return pulumi.get(self, "directory_type")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        - Domain name for the Directory Service.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="groupSearchType")
    def group_search_type(self) -> _builtins.str:
        """
        - Group membership search type for the Directory Service. Supported values are: "NON_RECURSIVE" (Doesn't search recursively within groups.) and "RECURSIVE" (Searches recursively within groups.)
        """
        return pulumi.get(self, "group_search_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        - Last updated time of the Directory Service.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Name for the Directory Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openLdapConfigurations")
    def open_ldap_configurations(self) -> Sequence['outputs.GetDirectoryServiceV2OpenLdapConfigurationResult']:
        """
        - Configuration for OpenLDAP Directory Service.
        """
        return pulumi.get(self, "open_ldap_configurations")

    @_builtins.property
    @pulumi.getter(name="secondaryUrls")
    def secondary_urls(self) -> Sequence[_builtins.str]:
        """
        - Secondary URL for the Directory Service.
        """
        return pulumi.get(self, "secondary_urls")

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence['outputs.GetDirectoryServiceV2ServiceAccountResult']:
        """
        - Information of Service account to connect to the Directory Service.
        """
        return pulumi.get(self, "service_accounts")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        - URL for the Directory Service.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="whiteListedGroups")
    def white_listed_groups(self) -> Sequence[_builtins.str]:
        """
        - List of allowed User Groups for the Directory Service.
        """
        return pulumi.get(self, "white_listed_groups")


class AwaitableGetDirectoryServiceV2Result(GetDirectoryServiceV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDirectoryServiceV2Result(
            created_by=self.created_by,
            created_time=self.created_time,
            directory_type=self.directory_type,
            domain_name=self.domain_name,
            ext_id=self.ext_id,
            group_search_type=self.group_search_type,
            id=self.id,
            last_updated_time=self.last_updated_time,
            name=self.name,
            open_ldap_configurations=self.open_ldap_configurations,
            secondary_urls=self.secondary_urls,
            service_accounts=self.service_accounts,
            url=self.url,
            white_listed_groups=self.white_listed_groups)


def get_directory_service_v2(ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDirectoryServiceV2Result:
    """
    Provides a datasource to retrieve all Directory Service(s).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get a Directory Service.
    get_active_directory = nutanix.get_directory_service_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: -(Required) External identifier of the Directory Service.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getDirectoryServiceV2:getDirectoryServiceV2', __args__, opts=opts, typ=GetDirectoryServiceV2Result).value

    return AwaitableGetDirectoryServiceV2Result(
        created_by=pulumi.get(__ret__, 'created_by'),
        created_time=pulumi.get(__ret__, 'created_time'),
        directory_type=pulumi.get(__ret__, 'directory_type'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        group_search_type=pulumi.get(__ret__, 'group_search_type'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        name=pulumi.get(__ret__, 'name'),
        open_ldap_configurations=pulumi.get(__ret__, 'open_ldap_configurations'),
        secondary_urls=pulumi.get(__ret__, 'secondary_urls'),
        service_accounts=pulumi.get(__ret__, 'service_accounts'),
        url=pulumi.get(__ret__, 'url'),
        white_listed_groups=pulumi.get(__ret__, 'white_listed_groups'))
def get_directory_service_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDirectoryServiceV2Result]:
    """
    Provides a datasource to retrieve all Directory Service(s).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get a Directory Service.
    get_active_directory = nutanix.get_directory_service_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: -(Required) External identifier of the Directory Service.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getDirectoryServiceV2:getDirectoryServiceV2', __args__, opts=opts, typ=GetDirectoryServiceV2Result)
    return __ret__.apply(lambda __response__: GetDirectoryServiceV2Result(
        created_by=pulumi.get(__response__, 'created_by'),
        created_time=pulumi.get(__response__, 'created_time'),
        directory_type=pulumi.get(__response__, 'directory_type'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        group_search_type=pulumi.get(__response__, 'group_search_type'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        name=pulumi.get(__response__, 'name'),
        open_ldap_configurations=pulumi.get(__response__, 'open_ldap_configurations'),
        secondary_urls=pulumi.get(__response__, 'secondary_urls'),
        service_accounts=pulumi.get(__response__, 'service_accounts'),
        url=pulumi.get(__response__, 'url'),
        white_listed_groups=pulumi.get(__response__, 'white_listed_groups')))
