# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFloatingIpV2Result',
    'AwaitableGetFloatingIpV2Result',
    'get_floating_ip_v2',
    'get_floating_ip_v2_output',
]

@pulumi.output_type
class GetFloatingIpV2Result:
    """
    A collection of values returned by getFloatingIpV2.
    """
    def __init__(__self__, association_status=None, associations=None, description=None, ext_id=None, external_subnet_reference=None, external_subnets=None, floating_ip_value=None, floating_ips=None, id=None, links=None, metadatas=None, name=None, private_ip=None, tenant_id=None, vm_nic_reference=None, vm_nics=None, vpc_reference=None, vpcs=None):
        if association_status and not isinstance(association_status, str):
            raise TypeError("Expected argument 'association_status' to be a str")
        pulumi.set(__self__, "association_status", association_status)
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if external_subnet_reference and not isinstance(external_subnet_reference, str):
            raise TypeError("Expected argument 'external_subnet_reference' to be a str")
        pulumi.set(__self__, "external_subnet_reference", external_subnet_reference)
        if external_subnets and not isinstance(external_subnets, list):
            raise TypeError("Expected argument 'external_subnets' to be a list")
        pulumi.set(__self__, "external_subnets", external_subnets)
        if floating_ip_value and not isinstance(floating_ip_value, str):
            raise TypeError("Expected argument 'floating_ip_value' to be a str")
        pulumi.set(__self__, "floating_ip_value", floating_ip_value)
        if floating_ips and not isinstance(floating_ips, list):
            raise TypeError("Expected argument 'floating_ips' to be a list")
        pulumi.set(__self__, "floating_ips", floating_ips)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vm_nic_reference and not isinstance(vm_nic_reference, str):
            raise TypeError("Expected argument 'vm_nic_reference' to be a str")
        pulumi.set(__self__, "vm_nic_reference", vm_nic_reference)
        if vm_nics and not isinstance(vm_nics, list):
            raise TypeError("Expected argument 'vm_nics' to be a list")
        pulumi.set(__self__, "vm_nics", vm_nics)
        if vpc_reference and not isinstance(vpc_reference, str):
            raise TypeError("Expected argument 'vpc_reference' to be a str")
        pulumi.set(__self__, "vpc_reference", vpc_reference)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> _builtins.str:
        """
        Association status of floating IP.
        """
        return pulumi.get(self, "association_status")

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetFloatingIpV2AssociationResult']:
        """
        Association of the Floating IP with either NIC or Private IP
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description for the Floating IP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReference")
    def external_subnet_reference(self) -> _builtins.str:
        """
        External subnet reference for the Floating IP to be allocated in on-prem only.
        """
        return pulumi.get(self, "external_subnet_reference")

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Sequence['outputs.GetFloatingIpV2ExternalSubnetResult']:
        """
        Networking common base object
        """
        return pulumi.get(self, "external_subnets")

    @_builtins.property
    @pulumi.getter(name="floatingIpValue")
    def floating_ip_value(self) -> _builtins.str:
        """
        Floating IP value in string
        """
        return pulumi.get(self, "floating_ip_value")

    @_builtins.property
    @pulumi.getter(name="floatingIps")
    def floating_ips(self) -> Sequence['outputs.GetFloatingIpV2FloatingIpResult']:
        """
        Floating IP address.
        """
        return pulumi.get(self, "floating_ips")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetFloatingIpV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetFloatingIpV2MetadataResult']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the floating IP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        Private IP value in string
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vmNicReference")
    def vm_nic_reference(self) -> _builtins.str:
        """
        VM NIC reference.
        """
        return pulumi.get(self, "vm_nic_reference")

    @_builtins.property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Sequence['outputs.GetFloatingIpV2VmNicResult']:
        """
        Virtual NIC for projections
        """
        return pulumi.get(self, "vm_nics")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> _builtins.str:
        """
        VPC reference UUID
        """
        return pulumi.get(self, "vpc_reference")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetFloatingIpV2VpcResult']:
        """
        Networking common base object
        """
        return pulumi.get(self, "vpcs")


class AwaitableGetFloatingIpV2Result(GetFloatingIpV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFloatingIpV2Result(
            association_status=self.association_status,
            associations=self.associations,
            description=self.description,
            ext_id=self.ext_id,
            external_subnet_reference=self.external_subnet_reference,
            external_subnets=self.external_subnets,
            floating_ip_value=self.floating_ip_value,
            floating_ips=self.floating_ips,
            id=self.id,
            links=self.links,
            metadatas=self.metadatas,
            name=self.name,
            private_ip=self.private_ip,
            tenant_id=self.tenant_id,
            vm_nic_reference=self.vm_nic_reference,
            vm_nics=self.vm_nics,
            vpc_reference=self.vpc_reference,
            vpcs=self.vpcs)


def get_floating_ip_v2(ext_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFloatingIpV2Result:
    """
    Provides a datasource to retrieve the floating IP for this extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_floating_ip = nutanix.get_floating_ip_v2(ext_id="cf1a7643-605e-4622-9f2a-b3fdccdbd072")
    ```


    :param _builtins.str ext_id: Floating IP UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFloatingIpV2:getFloatingIpV2', __args__, opts=opts, typ=GetFloatingIpV2Result).value

    return AwaitableGetFloatingIpV2Result(
        association_status=pulumi.get(__ret__, 'association_status'),
        associations=pulumi.get(__ret__, 'associations'),
        description=pulumi.get(__ret__, 'description'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        external_subnet_reference=pulumi.get(__ret__, 'external_subnet_reference'),
        external_subnets=pulumi.get(__ret__, 'external_subnets'),
        floating_ip_value=pulumi.get(__ret__, 'floating_ip_value'),
        floating_ips=pulumi.get(__ret__, 'floating_ips'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vm_nic_reference=pulumi.get(__ret__, 'vm_nic_reference'),
        vm_nics=pulumi.get(__ret__, 'vm_nics'),
        vpc_reference=pulumi.get(__ret__, 'vpc_reference'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_floating_ip_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFloatingIpV2Result]:
    """
    Provides a datasource to retrieve the floating IP for this extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_floating_ip = nutanix.get_floating_ip_v2(ext_id="cf1a7643-605e-4622-9f2a-b3fdccdbd072")
    ```


    :param _builtins.str ext_id: Floating IP UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFloatingIpV2:getFloatingIpV2', __args__, opts=opts, typ=GetFloatingIpV2Result)
    return __ret__.apply(lambda __response__: GetFloatingIpV2Result(
        association_status=pulumi.get(__response__, 'association_status'),
        associations=pulumi.get(__response__, 'associations'),
        description=pulumi.get(__response__, 'description'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        external_subnet_reference=pulumi.get(__response__, 'external_subnet_reference'),
        external_subnets=pulumi.get(__response__, 'external_subnets'),
        floating_ip_value=pulumi.get(__response__, 'floating_ip_value'),
        floating_ips=pulumi.get(__response__, 'floating_ips'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vm_nic_reference=pulumi.get(__response__, 'vm_nic_reference'),
        vm_nics=pulumi.get(__response__, 'vm_nics'),
        vpc_reference=pulumi.get(__response__, 'vpc_reference'),
        vpcs=pulumi.get(__response__, 'vpcs')))
