# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFoundationCentralApiKeysResult',
    'AwaitableGetFoundationCentralApiKeysResult',
    'get_foundation_central_api_keys',
    'get_foundation_central_api_keys_output',
]

@pulumi.output_type
class GetFoundationCentralApiKeysResult:
    """
    A collection of values returned by getFoundationCentralApiKeys.
    """
    def __init__(__self__, alias=None, api_key=None, created_timestamp=None, current_time=None, id=None, key_uuid=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if api_key and not isinstance(api_key, str):
            raise TypeError("Expected argument 'api_key' to be a str")
        pulumi.set(__self__, "api_key", api_key)
        if created_timestamp and not isinstance(created_timestamp, str):
            raise TypeError("Expected argument 'created_timestamp' to be a str")
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        if current_time and not isinstance(current_time, str):
            raise TypeError("Expected argument 'current_time' to be a str")
        pulumi.set(__self__, "current_time", current_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_uuid and not isinstance(key_uuid, str):
            raise TypeError("Expected argument 'key_uuid' to be a str")
        pulumi.set(__self__, "key_uuid", key_uuid)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> _builtins.str:
        """
        Alias of the api key.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        Api key in string format.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> _builtins.str:
        """
        Time when the api key was created.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="currentTime")
    def current_time(self) -> _builtins.str:
        """
        Current time of Foundation Central.
        """
        return pulumi.get(self, "current_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyUuid")
    def key_uuid(self) -> _builtins.str:
        """
        UUID of the api key.
        """
        return pulumi.get(self, "key_uuid")


class AwaitableGetFoundationCentralApiKeysResult(GetFoundationCentralApiKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationCentralApiKeysResult(
            alias=self.alias,
            api_key=self.api_key,
            created_timestamp=self.created_timestamp,
            current_time=self.current_time,
            id=self.id,
            key_uuid=self.key_uuid)


def get_foundation_central_api_keys(key_uuid: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationCentralApiKeysResult:
    """
    Get an api key given its UUID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    api_keys_list = nutanix.get_foundation_central_api_keys(key_uuid="<KEY_UUID>")
    ```


    :param _builtins.str key_uuid: UUID of the key which needs to be fetched.
    """
    __args__ = dict()
    __args__['keyUuid'] = key_uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationCentralApiKeys:getFoundationCentralApiKeys', __args__, opts=opts, typ=GetFoundationCentralApiKeysResult).value

    return AwaitableGetFoundationCentralApiKeysResult(
        alias=pulumi.get(__ret__, 'alias'),
        api_key=pulumi.get(__ret__, 'api_key'),
        created_timestamp=pulumi.get(__ret__, 'created_timestamp'),
        current_time=pulumi.get(__ret__, 'current_time'),
        id=pulumi.get(__ret__, 'id'),
        key_uuid=pulumi.get(__ret__, 'key_uuid'))
def get_foundation_central_api_keys_output(key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationCentralApiKeysResult]:
    """
    Get an api key given its UUID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    api_keys_list = nutanix.get_foundation_central_api_keys(key_uuid="<KEY_UUID>")
    ```


    :param _builtins.str key_uuid: UUID of the key which needs to be fetched.
    """
    __args__ = dict()
    __args__['keyUuid'] = key_uuid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationCentralApiKeys:getFoundationCentralApiKeys', __args__, opts=opts, typ=GetFoundationCentralApiKeysResult)
    return __ret__.apply(lambda __response__: GetFoundationCentralApiKeysResult(
        alias=pulumi.get(__response__, 'alias'),
        api_key=pulumi.get(__response__, 'api_key'),
        created_timestamp=pulumi.get(__response__, 'created_timestamp'),
        current_time=pulumi.get(__response__, 'current_time'),
        id=pulumi.get(__response__, 'id'),
        key_uuid=pulumi.get(__response__, 'key_uuid')))
