# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFoundationCentralClusterDetailsResult',
    'AwaitableGetFoundationCentralClusterDetailsResult',
    'get_foundation_central_cluster_details',
    'get_foundation_central_cluster_details_output',
]

@pulumi.output_type
class GetFoundationCentralClusterDetailsResult:
    """
    A collection of values returned by getFoundationCentralClusterDetails.
    """
    def __init__(__self__, archived=None, cluster_external_ip=None, cluster_name=None, cluster_size=None, cluster_status=None, common_network_settings=None, created_timestamp=None, current_time=None, destroyed=None, foundation_init_configs=None, foundation_init_node_uuid=None, id=None, imaged_cluster_uuid=None, imaged_node_uuid_lists=None, redundancy_factor=None, storage_node_count=None, workflow_type=None):
        if archived and not isinstance(archived, bool):
            raise TypeError("Expected argument 'archived' to be a bool")
        pulumi.set(__self__, "archived", archived)
        if cluster_external_ip and not isinstance(cluster_external_ip, str):
            raise TypeError("Expected argument 'cluster_external_ip' to be a str")
        pulumi.set(__self__, "cluster_external_ip", cluster_external_ip)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_size and not isinstance(cluster_size, int):
            raise TypeError("Expected argument 'cluster_size' to be a int")
        pulumi.set(__self__, "cluster_size", cluster_size)
        if cluster_status and not isinstance(cluster_status, dict):
            raise TypeError("Expected argument 'cluster_status' to be a dict")
        pulumi.set(__self__, "cluster_status", cluster_status)
        if common_network_settings and not isinstance(common_network_settings, dict):
            raise TypeError("Expected argument 'common_network_settings' to be a dict")
        pulumi.set(__self__, "common_network_settings", common_network_settings)
        if created_timestamp and not isinstance(created_timestamp, str):
            raise TypeError("Expected argument 'created_timestamp' to be a str")
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        if current_time and not isinstance(current_time, str):
            raise TypeError("Expected argument 'current_time' to be a str")
        pulumi.set(__self__, "current_time", current_time)
        if destroyed and not isinstance(destroyed, bool):
            raise TypeError("Expected argument 'destroyed' to be a bool")
        pulumi.set(__self__, "destroyed", destroyed)
        if foundation_init_configs and not isinstance(foundation_init_configs, list):
            raise TypeError("Expected argument 'foundation_init_configs' to be a list")
        pulumi.set(__self__, "foundation_init_configs", foundation_init_configs)
        if foundation_init_node_uuid and not isinstance(foundation_init_node_uuid, str):
            raise TypeError("Expected argument 'foundation_init_node_uuid' to be a str")
        pulumi.set(__self__, "foundation_init_node_uuid", foundation_init_node_uuid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if imaged_cluster_uuid and not isinstance(imaged_cluster_uuid, str):
            raise TypeError("Expected argument 'imaged_cluster_uuid' to be a str")
        pulumi.set(__self__, "imaged_cluster_uuid", imaged_cluster_uuid)
        if imaged_node_uuid_lists and not isinstance(imaged_node_uuid_lists, list):
            raise TypeError("Expected argument 'imaged_node_uuid_lists' to be a list")
        pulumi.set(__self__, "imaged_node_uuid_lists", imaged_node_uuid_lists)
        if redundancy_factor and not isinstance(redundancy_factor, int):
            raise TypeError("Expected argument 'redundancy_factor' to be a int")
        pulumi.set(__self__, "redundancy_factor", redundancy_factor)
        if storage_node_count and not isinstance(storage_node_count, int):
            raise TypeError("Expected argument 'storage_node_count' to be a int")
        pulumi.set(__self__, "storage_node_count", storage_node_count)
        if workflow_type and not isinstance(workflow_type, str):
            raise TypeError("Expected argument 'workflow_type' to be a str")
        pulumi.set(__self__, "workflow_type", workflow_type)

    @_builtins.property
    @pulumi.getter
    def archived(self) -> _builtins.bool:
        """
        True if the cluster creation request is archived, False otherwise
        """
        return pulumi.get(self, "archived")

    @_builtins.property
    @pulumi.getter(name="clusterExternalIp")
    def cluster_external_ip(self) -> _builtins.str:
        """
        External management ip of the cluster.
        """
        return pulumi.get(self, "cluster_external_ip")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        Cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> _builtins.int:
        """
        Number of nodes in the cluster.
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter(name="clusterStatus")
    def cluster_status(self) -> 'outputs.GetFoundationCentralClusterDetailsClusterStatusResult':
        """
        Details of cluster creation process.
        """
        return pulumi.get(self, "cluster_status")

    @_builtins.property
    @pulumi.getter(name="commonNetworkSettings")
    def common_network_settings(self) -> 'outputs.GetFoundationCentralClusterDetailsCommonNetworkSettingsResult':
        """
        Common network settings across the nodes in the cluster.
        """
        return pulumi.get(self, "common_network_settings")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> _builtins.str:
        """
        Time when the cluster creation request was received in Foundation Central.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="currentTime")
    def current_time(self) -> _builtins.str:
        """
        Current time of Foundation Central.
        """
        return pulumi.get(self, "current_time")

    @_builtins.property
    @pulumi.getter
    def destroyed(self) -> _builtins.bool:
        """
        True if the cluster is destroyed, False otherwise
        """
        return pulumi.get(self, "destroyed")

    @_builtins.property
    @pulumi.getter(name="foundationInitConfigs")
    def foundation_init_configs(self) -> Sequence['outputs.GetFoundationCentralClusterDetailsFoundationInitConfigResult']:
        """
        Json config used by Foundation to create the cluster.
        """
        return pulumi.get(self, "foundation_init_configs")

    @_builtins.property
    @pulumi.getter(name="foundationInitNodeUuid")
    def foundation_init_node_uuid(self) -> _builtins.str:
        """
        UUID of the first node coordinating cluster creation.
        """
        return pulumi.get(self, "foundation_init_node_uuid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imagedClusterUuid")
    def imaged_cluster_uuid(self) -> _builtins.str:
        """
        UUID of the cluster.
        """
        return pulumi.get(self, "imaged_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="imagedNodeUuidLists")
    def imaged_node_uuid_lists(self) -> Sequence[_builtins.str]:
        """
        List of UUIDs of imaged nodes.
        """
        return pulumi.get(self, "imaged_node_uuid_lists")

    @_builtins.property
    @pulumi.getter(name="redundancyFactor")
    def redundancy_factor(self) -> Optional[_builtins.int]:
        """
        Redundancy factor of the cluster.
        """
        return pulumi.get(self, "redundancy_factor")

    @_builtins.property
    @pulumi.getter(name="storageNodeCount")
    def storage_node_count(self) -> _builtins.int:
        """
        Number of storage only nodes in the cluster. AHV iso for storage node will be taken from aos package.
        """
        return pulumi.get(self, "storage_node_count")

    @_builtins.property
    @pulumi.getter(name="workflowType")
    def workflow_type(self) -> _builtins.str:
        """
        If imaging and cluster creation is coordinated by Foundation, value will be FOUNDATION_WF. If the nodes are in phoenix, value will be PHOENIX_WF.
        """
        return pulumi.get(self, "workflow_type")


class AwaitableGetFoundationCentralClusterDetailsResult(GetFoundationCentralClusterDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationCentralClusterDetailsResult(
            archived=self.archived,
            cluster_external_ip=self.cluster_external_ip,
            cluster_name=self.cluster_name,
            cluster_size=self.cluster_size,
            cluster_status=self.cluster_status,
            common_network_settings=self.common_network_settings,
            created_timestamp=self.created_timestamp,
            current_time=self.current_time,
            destroyed=self.destroyed,
            foundation_init_configs=self.foundation_init_configs,
            foundation_init_node_uuid=self.foundation_init_node_uuid,
            id=self.id,
            imaged_cluster_uuid=self.imaged_cluster_uuid,
            imaged_node_uuid_lists=self.imaged_node_uuid_lists,
            redundancy_factor=self.redundancy_factor,
            storage_node_count=self.storage_node_count,
            workflow_type=self.workflow_type)


def get_foundation_central_cluster_details(cluster_external_ip: Optional[_builtins.str] = None,
                                           cluster_name: Optional[_builtins.str] = None,
                                           cluster_size: Optional[_builtins.int] = None,
                                           cluster_status: Optional[Union['GetFoundationCentralClusterDetailsClusterStatusArgs', 'GetFoundationCentralClusterDetailsClusterStatusArgsDict']] = None,
                                           common_network_settings: Optional[Union['GetFoundationCentralClusterDetailsCommonNetworkSettingsArgs', 'GetFoundationCentralClusterDetailsCommonNetworkSettingsArgsDict']] = None,
                                           imaged_cluster_uuid: Optional[_builtins.str] = None,
                                           redundancy_factor: Optional[_builtins.int] = None,
                                           storage_node_count: Optional[_builtins.int] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationCentralClusterDetailsResult:
    """
    Get a cluster details created using Foundation Central.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    imaged_cluster_details = nutanix.get_foundation_central_cluster_details(imaged_cluster_uuid="<CLUSTER-UUID>")
    ```


    :param _builtins.str cluster_external_ip: External management ip of the cluster.
    :param _builtins.str cluster_name: Cluster name.
    :param _builtins.int cluster_size: Number of nodes in the cluster.
    :param Union['GetFoundationCentralClusterDetailsClusterStatusArgs', 'GetFoundationCentralClusterDetailsClusterStatusArgsDict'] cluster_status: Details of cluster creation process.
    :param Union['GetFoundationCentralClusterDetailsCommonNetworkSettingsArgs', 'GetFoundationCentralClusterDetailsCommonNetworkSettingsArgsDict'] common_network_settings: Common network settings across the nodes in the cluster.
    :param _builtins.str imaged_cluster_uuid: UUID of the cluster whose details need to be fetched.
    :param _builtins.int redundancy_factor: Redundancy factor of the cluster.
    :param _builtins.int storage_node_count: Number of storage only nodes in the cluster. AHV iso for storage node will be taken from aos package.
    """
    __args__ = dict()
    __args__['clusterExternalIp'] = cluster_external_ip
    __args__['clusterName'] = cluster_name
    __args__['clusterSize'] = cluster_size
    __args__['clusterStatus'] = cluster_status
    __args__['commonNetworkSettings'] = common_network_settings
    __args__['imagedClusterUuid'] = imaged_cluster_uuid
    __args__['redundancyFactor'] = redundancy_factor
    __args__['storageNodeCount'] = storage_node_count
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationCentralClusterDetails:getFoundationCentralClusterDetails', __args__, opts=opts, typ=GetFoundationCentralClusterDetailsResult).value

    return AwaitableGetFoundationCentralClusterDetailsResult(
        archived=pulumi.get(__ret__, 'archived'),
        cluster_external_ip=pulumi.get(__ret__, 'cluster_external_ip'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        cluster_size=pulumi.get(__ret__, 'cluster_size'),
        cluster_status=pulumi.get(__ret__, 'cluster_status'),
        common_network_settings=pulumi.get(__ret__, 'common_network_settings'),
        created_timestamp=pulumi.get(__ret__, 'created_timestamp'),
        current_time=pulumi.get(__ret__, 'current_time'),
        destroyed=pulumi.get(__ret__, 'destroyed'),
        foundation_init_configs=pulumi.get(__ret__, 'foundation_init_configs'),
        foundation_init_node_uuid=pulumi.get(__ret__, 'foundation_init_node_uuid'),
        id=pulumi.get(__ret__, 'id'),
        imaged_cluster_uuid=pulumi.get(__ret__, 'imaged_cluster_uuid'),
        imaged_node_uuid_lists=pulumi.get(__ret__, 'imaged_node_uuid_lists'),
        redundancy_factor=pulumi.get(__ret__, 'redundancy_factor'),
        storage_node_count=pulumi.get(__ret__, 'storage_node_count'),
        workflow_type=pulumi.get(__ret__, 'workflow_type'))
def get_foundation_central_cluster_details_output(cluster_external_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  cluster_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                  cluster_status: Optional[pulumi.Input[Optional[Union['GetFoundationCentralClusterDetailsClusterStatusArgs', 'GetFoundationCentralClusterDetailsClusterStatusArgsDict']]]] = None,
                                                  common_network_settings: Optional[pulumi.Input[Optional[Union['GetFoundationCentralClusterDetailsCommonNetworkSettingsArgs', 'GetFoundationCentralClusterDetailsCommonNetworkSettingsArgsDict']]]] = None,
                                                  imaged_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                                                  redundancy_factor: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                  storage_node_count: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationCentralClusterDetailsResult]:
    """
    Get a cluster details created using Foundation Central.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    imaged_cluster_details = nutanix.get_foundation_central_cluster_details(imaged_cluster_uuid="<CLUSTER-UUID>")
    ```


    :param _builtins.str cluster_external_ip: External management ip of the cluster.
    :param _builtins.str cluster_name: Cluster name.
    :param _builtins.int cluster_size: Number of nodes in the cluster.
    :param Union['GetFoundationCentralClusterDetailsClusterStatusArgs', 'GetFoundationCentralClusterDetailsClusterStatusArgsDict'] cluster_status: Details of cluster creation process.
    :param Union['GetFoundationCentralClusterDetailsCommonNetworkSettingsArgs', 'GetFoundationCentralClusterDetailsCommonNetworkSettingsArgsDict'] common_network_settings: Common network settings across the nodes in the cluster.
    :param _builtins.str imaged_cluster_uuid: UUID of the cluster whose details need to be fetched.
    :param _builtins.int redundancy_factor: Redundancy factor of the cluster.
    :param _builtins.int storage_node_count: Number of storage only nodes in the cluster. AHV iso for storage node will be taken from aos package.
    """
    __args__ = dict()
    __args__['clusterExternalIp'] = cluster_external_ip
    __args__['clusterName'] = cluster_name
    __args__['clusterSize'] = cluster_size
    __args__['clusterStatus'] = cluster_status
    __args__['commonNetworkSettings'] = common_network_settings
    __args__['imagedClusterUuid'] = imaged_cluster_uuid
    __args__['redundancyFactor'] = redundancy_factor
    __args__['storageNodeCount'] = storage_node_count
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationCentralClusterDetails:getFoundationCentralClusterDetails', __args__, opts=opts, typ=GetFoundationCentralClusterDetailsResult)
    return __ret__.apply(lambda __response__: GetFoundationCentralClusterDetailsResult(
        archived=pulumi.get(__response__, 'archived'),
        cluster_external_ip=pulumi.get(__response__, 'cluster_external_ip'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        cluster_size=pulumi.get(__response__, 'cluster_size'),
        cluster_status=pulumi.get(__response__, 'cluster_status'),
        common_network_settings=pulumi.get(__response__, 'common_network_settings'),
        created_timestamp=pulumi.get(__response__, 'created_timestamp'),
        current_time=pulumi.get(__response__, 'current_time'),
        destroyed=pulumi.get(__response__, 'destroyed'),
        foundation_init_configs=pulumi.get(__response__, 'foundation_init_configs'),
        foundation_init_node_uuid=pulumi.get(__response__, 'foundation_init_node_uuid'),
        id=pulumi.get(__response__, 'id'),
        imaged_cluster_uuid=pulumi.get(__response__, 'imaged_cluster_uuid'),
        imaged_node_uuid_lists=pulumi.get(__response__, 'imaged_node_uuid_lists'),
        redundancy_factor=pulumi.get(__response__, 'redundancy_factor'),
        storage_node_count=pulumi.get(__response__, 'storage_node_count'),
        workflow_type=pulumi.get(__response__, 'workflow_type')))
