# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFoundationCentralImagedNodeDetailsResult',
    'AwaitableGetFoundationCentralImagedNodeDetailsResult',
    'get_foundation_central_imaged_node_details',
    'get_foundation_central_imaged_node_details_output',
]

@pulumi.output_type
class GetFoundationCentralImagedNodeDetailsResult:
    """
    A collection of values returned by getFoundationCentralImagedNodeDetails.
    """
    def __init__(__self__, aos_version=None, api_key_uuid=None, available=None, block_serial=None, created_timestamp=None, current_time=None, cvm_gateway=None, cvm_ip=None, cvm_ipv6=None, cvm_netmask=None, cvm_up=None, cvm_uuid=None, cvm_vlan_id=None, foundation_version=None, hardware_attributes=None, hypervisor_gateway=None, hypervisor_hostname=None, hypervisor_ip=None, hypervisor_netmask=None, hypervisor_type=None, hypervisor_version=None, id=None, imaged_cluster_uuid=None, imaged_node_uuid=None, ipmi_gateway=None, ipmi_ip=None, ipmi_netmask=None, ipv6_interface=None, latest_hb_ts_lists=None, model=None, node_position=None, node_serial=None, node_state=None, node_type=None, object_version=None):
        if aos_version and not isinstance(aos_version, str):
            raise TypeError("Expected argument 'aos_version' to be a str")
        pulumi.set(__self__, "aos_version", aos_version)
        if api_key_uuid and not isinstance(api_key_uuid, str):
            raise TypeError("Expected argument 'api_key_uuid' to be a str")
        pulumi.set(__self__, "api_key_uuid", api_key_uuid)
        if available and not isinstance(available, bool):
            raise TypeError("Expected argument 'available' to be a bool")
        pulumi.set(__self__, "available", available)
        if block_serial and not isinstance(block_serial, str):
            raise TypeError("Expected argument 'block_serial' to be a str")
        pulumi.set(__self__, "block_serial", block_serial)
        if created_timestamp and not isinstance(created_timestamp, str):
            raise TypeError("Expected argument 'created_timestamp' to be a str")
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        if current_time and not isinstance(current_time, str):
            raise TypeError("Expected argument 'current_time' to be a str")
        pulumi.set(__self__, "current_time", current_time)
        if cvm_gateway and not isinstance(cvm_gateway, str):
            raise TypeError("Expected argument 'cvm_gateway' to be a str")
        pulumi.set(__self__, "cvm_gateway", cvm_gateway)
        if cvm_ip and not isinstance(cvm_ip, str):
            raise TypeError("Expected argument 'cvm_ip' to be a str")
        pulumi.set(__self__, "cvm_ip", cvm_ip)
        if cvm_ipv6 and not isinstance(cvm_ipv6, str):
            raise TypeError("Expected argument 'cvm_ipv6' to be a str")
        pulumi.set(__self__, "cvm_ipv6", cvm_ipv6)
        if cvm_netmask and not isinstance(cvm_netmask, str):
            raise TypeError("Expected argument 'cvm_netmask' to be a str")
        pulumi.set(__self__, "cvm_netmask", cvm_netmask)
        if cvm_up and not isinstance(cvm_up, bool):
            raise TypeError("Expected argument 'cvm_up' to be a bool")
        pulumi.set(__self__, "cvm_up", cvm_up)
        if cvm_uuid and not isinstance(cvm_uuid, str):
            raise TypeError("Expected argument 'cvm_uuid' to be a str")
        pulumi.set(__self__, "cvm_uuid", cvm_uuid)
        if cvm_vlan_id and not isinstance(cvm_vlan_id, int):
            raise TypeError("Expected argument 'cvm_vlan_id' to be a int")
        pulumi.set(__self__, "cvm_vlan_id", cvm_vlan_id)
        if foundation_version and not isinstance(foundation_version, str):
            raise TypeError("Expected argument 'foundation_version' to be a str")
        pulumi.set(__self__, "foundation_version", foundation_version)
        if hardware_attributes and not isinstance(hardware_attributes, dict):
            raise TypeError("Expected argument 'hardware_attributes' to be a dict")
        pulumi.set(__self__, "hardware_attributes", hardware_attributes)
        if hypervisor_gateway and not isinstance(hypervisor_gateway, str):
            raise TypeError("Expected argument 'hypervisor_gateway' to be a str")
        pulumi.set(__self__, "hypervisor_gateway", hypervisor_gateway)
        if hypervisor_hostname and not isinstance(hypervisor_hostname, str):
            raise TypeError("Expected argument 'hypervisor_hostname' to be a str")
        pulumi.set(__self__, "hypervisor_hostname", hypervisor_hostname)
        if hypervisor_ip and not isinstance(hypervisor_ip, str):
            raise TypeError("Expected argument 'hypervisor_ip' to be a str")
        pulumi.set(__self__, "hypervisor_ip", hypervisor_ip)
        if hypervisor_netmask and not isinstance(hypervisor_netmask, str):
            raise TypeError("Expected argument 'hypervisor_netmask' to be a str")
        pulumi.set(__self__, "hypervisor_netmask", hypervisor_netmask)
        if hypervisor_type and not isinstance(hypervisor_type, str):
            raise TypeError("Expected argument 'hypervisor_type' to be a str")
        pulumi.set(__self__, "hypervisor_type", hypervisor_type)
        if hypervisor_version and not isinstance(hypervisor_version, str):
            raise TypeError("Expected argument 'hypervisor_version' to be a str")
        pulumi.set(__self__, "hypervisor_version", hypervisor_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if imaged_cluster_uuid and not isinstance(imaged_cluster_uuid, str):
            raise TypeError("Expected argument 'imaged_cluster_uuid' to be a str")
        pulumi.set(__self__, "imaged_cluster_uuid", imaged_cluster_uuid)
        if imaged_node_uuid and not isinstance(imaged_node_uuid, str):
            raise TypeError("Expected argument 'imaged_node_uuid' to be a str")
        pulumi.set(__self__, "imaged_node_uuid", imaged_node_uuid)
        if ipmi_gateway and not isinstance(ipmi_gateway, str):
            raise TypeError("Expected argument 'ipmi_gateway' to be a str")
        pulumi.set(__self__, "ipmi_gateway", ipmi_gateway)
        if ipmi_ip and not isinstance(ipmi_ip, str):
            raise TypeError("Expected argument 'ipmi_ip' to be a str")
        pulumi.set(__self__, "ipmi_ip", ipmi_ip)
        if ipmi_netmask and not isinstance(ipmi_netmask, str):
            raise TypeError("Expected argument 'ipmi_netmask' to be a str")
        pulumi.set(__self__, "ipmi_netmask", ipmi_netmask)
        if ipv6_interface and not isinstance(ipv6_interface, str):
            raise TypeError("Expected argument 'ipv6_interface' to be a str")
        pulumi.set(__self__, "ipv6_interface", ipv6_interface)
        if latest_hb_ts_lists and not isinstance(latest_hb_ts_lists, list):
            raise TypeError("Expected argument 'latest_hb_ts_lists' to be a list")
        pulumi.set(__self__, "latest_hb_ts_lists", latest_hb_ts_lists)
        if model and not isinstance(model, str):
            raise TypeError("Expected argument 'model' to be a str")
        pulumi.set(__self__, "model", model)
        if node_position and not isinstance(node_position, str):
            raise TypeError("Expected argument 'node_position' to be a str")
        pulumi.set(__self__, "node_position", node_position)
        if node_serial and not isinstance(node_serial, str):
            raise TypeError("Expected argument 'node_serial' to be a str")
        pulumi.set(__self__, "node_serial", node_serial)
        if node_state and not isinstance(node_state, str):
            raise TypeError("Expected argument 'node_state' to be a str")
        pulumi.set(__self__, "node_state", node_state)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if object_version and not isinstance(object_version, int):
            raise TypeError("Expected argument 'object_version' to be a int")
        pulumi.set(__self__, "object_version", object_version)

    @_builtins.property
    @pulumi.getter(name="aosVersion")
    def aos_version(self) -> _builtins.str:
        """
        AOS version currently installed on the node.
        """
        return pulumi.get(self, "aos_version")

    @_builtins.property
    @pulumi.getter(name="apiKeyUuid")
    def api_key_uuid(self) -> _builtins.str:
        """
        API key used to register the node.
        """
        return pulumi.get(self, "api_key_uuid")

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Specifies whether the node is available for cluster creation.
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter(name="blockSerial")
    def block_serial(self) -> _builtins.str:
        """
        Serial number of the block to which the node belongs.
        """
        return pulumi.get(self, "block_serial")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> _builtins.str:
        """
        Time when the node was discovered in Foundation Central.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="currentTime")
    def current_time(self) -> _builtins.str:
        """
        Current time of Foundation Central.
        """
        return pulumi.get(self, "current_time")

    @_builtins.property
    @pulumi.getter(name="cvmGateway")
    def cvm_gateway(self) -> _builtins.str:
        """
        gateway of the cvm.
        """
        return pulumi.get(self, "cvm_gateway")

    @_builtins.property
    @pulumi.getter(name="cvmIp")
    def cvm_ip(self) -> _builtins.str:
        """
        IP address of the cvm.
        """
        return pulumi.get(self, "cvm_ip")

    @_builtins.property
    @pulumi.getter(name="cvmIpv6")
    def cvm_ipv6(self) -> _builtins.str:
        """
        IPv6 address of the cvm.
        """
        return pulumi.get(self, "cvm_ipv6")

    @_builtins.property
    @pulumi.getter(name="cvmNetmask")
    def cvm_netmask(self) -> _builtins.str:
        """
        netmask of the cvm.
        """
        return pulumi.get(self, "cvm_netmask")

    @_builtins.property
    @pulumi.getter(name="cvmUp")
    def cvm_up(self) -> _builtins.bool:
        """
        Denotes whether the CVM is up or not on this node.
        """
        return pulumi.get(self, "cvm_up")

    @_builtins.property
    @pulumi.getter(name="cvmUuid")
    def cvm_uuid(self) -> _builtins.str:
        """
        Node UUID from the node's cvm.
        """
        return pulumi.get(self, "cvm_uuid")

    @_builtins.property
    @pulumi.getter(name="cvmVlanId")
    def cvm_vlan_id(self) -> _builtins.int:
        """
        Vlan tag of the cvm, if the cvm is on a vlan.
        """
        return pulumi.get(self, "cvm_vlan_id")

    @_builtins.property
    @pulumi.getter(name="foundationVersion")
    def foundation_version(self) -> _builtins.str:
        """
        Foundation version installed on the node.
        """
        return pulumi.get(self, "foundation_version")

    @_builtins.property
    @pulumi.getter(name="hardwareAttributes")
    def hardware_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Hardware attributes json of the node.
        """
        return pulumi.get(self, "hardware_attributes")

    @_builtins.property
    @pulumi.getter(name="hypervisorGateway")
    def hypervisor_gateway(self) -> _builtins.str:
        """
        gateway of the hypervisor.
        """
        return pulumi.get(self, "hypervisor_gateway")

    @_builtins.property
    @pulumi.getter(name="hypervisorHostname")
    def hypervisor_hostname(self) -> _builtins.str:
        """
        Name of the hypervisor host.
        """
        return pulumi.get(self, "hypervisor_hostname")

    @_builtins.property
    @pulumi.getter(name="hypervisorIp")
    def hypervisor_ip(self) -> _builtins.str:
        """
        IP address of the hypervisor.
        """
        return pulumi.get(self, "hypervisor_ip")

    @_builtins.property
    @pulumi.getter(name="hypervisorNetmask")
    def hypervisor_netmask(self) -> _builtins.str:
        """
        netmask of the hypervisor.
        """
        return pulumi.get(self, "hypervisor_netmask")

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> _builtins.str:
        """
        Hypervisor type currently installed on the node. Must be one of {kvm, esx, hyperv}.
        """
        return pulumi.get(self, "hypervisor_type")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> _builtins.str:
        """
        Version of the hypervisor currently installed on the node.
        """
        return pulumi.get(self, "hypervisor_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imagedClusterUuid")
    def imaged_cluster_uuid(self) -> _builtins.str:
        """
        UUID of the cluster to which the node belongs, if any.
        """
        return pulumi.get(self, "imaged_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="imagedNodeUuid")
    def imaged_node_uuid(self) -> _builtins.str:
        """
        UUID of the node.
        """
        return pulumi.get(self, "imaged_node_uuid")

    @_builtins.property
    @pulumi.getter(name="ipmiGateway")
    def ipmi_gateway(self) -> _builtins.str:
        """
        gateway of the ipmi.
        """
        return pulumi.get(self, "ipmi_gateway")

    @_builtins.property
    @pulumi.getter(name="ipmiIp")
    def ipmi_ip(self) -> _builtins.str:
        """
        IP address of the ipmi.
        """
        return pulumi.get(self, "ipmi_ip")

    @_builtins.property
    @pulumi.getter(name="ipmiNetmask")
    def ipmi_netmask(self) -> _builtins.str:
        """
        netmask of the ipmi.
        """
        return pulumi.get(self, "ipmi_netmask")

    @_builtins.property
    @pulumi.getter(name="ipv6Interface")
    def ipv6_interface(self) -> _builtins.str:
        """
        Name of the cvm interface having ipv6 address.
        """
        return pulumi.get(self, "ipv6_interface")

    @_builtins.property
    @pulumi.getter(name="latestHbTsLists")
    def latest_hb_ts_lists(self) -> Sequence[_builtins.str]:
        """
        List of timestamps when the node has sent heartbeats to Foundation Central.
        """
        return pulumi.get(self, "latest_hb_ts_lists")

    @_builtins.property
    @pulumi.getter
    def model(self) -> _builtins.str:
        """
        Model of the node.
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter(name="nodePosition")
    def node_position(self) -> _builtins.str:
        """
        Position of the node in the block.
        """
        return pulumi.get(self, "node_position")

    @_builtins.property
    @pulumi.getter(name="nodeSerial")
    def node_serial(self) -> _builtins.str:
        """
        Serial number of the node.
        """
        return pulumi.get(self, "node_serial")

    @_builtins.property
    @pulumi.getter(name="nodeState")
    def node_state(self) -> _builtins.str:
        """
        Specifies whether the node is discovering, available or unavailable for cluster creation.
        """
        return pulumi.get(self, "node_state")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> _builtins.str:
        """
        Specifies the type of node - on-prem, AWS, GCP etc.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> _builtins.int:
        """
        Version of the node used for CAS.
        """
        return pulumi.get(self, "object_version")


class AwaitableGetFoundationCentralImagedNodeDetailsResult(GetFoundationCentralImagedNodeDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationCentralImagedNodeDetailsResult(
            aos_version=self.aos_version,
            api_key_uuid=self.api_key_uuid,
            available=self.available,
            block_serial=self.block_serial,
            created_timestamp=self.created_timestamp,
            current_time=self.current_time,
            cvm_gateway=self.cvm_gateway,
            cvm_ip=self.cvm_ip,
            cvm_ipv6=self.cvm_ipv6,
            cvm_netmask=self.cvm_netmask,
            cvm_up=self.cvm_up,
            cvm_uuid=self.cvm_uuid,
            cvm_vlan_id=self.cvm_vlan_id,
            foundation_version=self.foundation_version,
            hardware_attributes=self.hardware_attributes,
            hypervisor_gateway=self.hypervisor_gateway,
            hypervisor_hostname=self.hypervisor_hostname,
            hypervisor_ip=self.hypervisor_ip,
            hypervisor_netmask=self.hypervisor_netmask,
            hypervisor_type=self.hypervisor_type,
            hypervisor_version=self.hypervisor_version,
            id=self.id,
            imaged_cluster_uuid=self.imaged_cluster_uuid,
            imaged_node_uuid=self.imaged_node_uuid,
            ipmi_gateway=self.ipmi_gateway,
            ipmi_ip=self.ipmi_ip,
            ipmi_netmask=self.ipmi_netmask,
            ipv6_interface=self.ipv6_interface,
            latest_hb_ts_lists=self.latest_hb_ts_lists,
            model=self.model,
            node_position=self.node_position,
            node_serial=self.node_serial,
            node_state=self.node_state,
            node_type=self.node_type,
            object_version=self.object_version)


def get_foundation_central_imaged_node_details(imaged_node_uuid: Optional[_builtins.str] = None,
                                               ipv6_interface: Optional[_builtins.str] = None,
                                               object_version: Optional[_builtins.int] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationCentralImagedNodeDetailsResult:
    """
    Get the details of a single node given its UUID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    nodes_details = nutanix.get_foundation_central_imaged_node_details(imaged_node_uuid="<IMAGED-NODE-UUID>")
    ```


    :param _builtins.str imaged_node_uuid: UUID of the node whose details need to be fetched.
    :param _builtins.str ipv6_interface: Name of the cvm interface having ipv6 address.
    :param _builtins.int object_version: Version of the node used for CAS.
    """
    __args__ = dict()
    __args__['imagedNodeUuid'] = imaged_node_uuid
    __args__['ipv6Interface'] = ipv6_interface
    __args__['objectVersion'] = object_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationCentralImagedNodeDetails:getFoundationCentralImagedNodeDetails', __args__, opts=opts, typ=GetFoundationCentralImagedNodeDetailsResult).value

    return AwaitableGetFoundationCentralImagedNodeDetailsResult(
        aos_version=pulumi.get(__ret__, 'aos_version'),
        api_key_uuid=pulumi.get(__ret__, 'api_key_uuid'),
        available=pulumi.get(__ret__, 'available'),
        block_serial=pulumi.get(__ret__, 'block_serial'),
        created_timestamp=pulumi.get(__ret__, 'created_timestamp'),
        current_time=pulumi.get(__ret__, 'current_time'),
        cvm_gateway=pulumi.get(__ret__, 'cvm_gateway'),
        cvm_ip=pulumi.get(__ret__, 'cvm_ip'),
        cvm_ipv6=pulumi.get(__ret__, 'cvm_ipv6'),
        cvm_netmask=pulumi.get(__ret__, 'cvm_netmask'),
        cvm_up=pulumi.get(__ret__, 'cvm_up'),
        cvm_uuid=pulumi.get(__ret__, 'cvm_uuid'),
        cvm_vlan_id=pulumi.get(__ret__, 'cvm_vlan_id'),
        foundation_version=pulumi.get(__ret__, 'foundation_version'),
        hardware_attributes=pulumi.get(__ret__, 'hardware_attributes'),
        hypervisor_gateway=pulumi.get(__ret__, 'hypervisor_gateway'),
        hypervisor_hostname=pulumi.get(__ret__, 'hypervisor_hostname'),
        hypervisor_ip=pulumi.get(__ret__, 'hypervisor_ip'),
        hypervisor_netmask=pulumi.get(__ret__, 'hypervisor_netmask'),
        hypervisor_type=pulumi.get(__ret__, 'hypervisor_type'),
        hypervisor_version=pulumi.get(__ret__, 'hypervisor_version'),
        id=pulumi.get(__ret__, 'id'),
        imaged_cluster_uuid=pulumi.get(__ret__, 'imaged_cluster_uuid'),
        imaged_node_uuid=pulumi.get(__ret__, 'imaged_node_uuid'),
        ipmi_gateway=pulumi.get(__ret__, 'ipmi_gateway'),
        ipmi_ip=pulumi.get(__ret__, 'ipmi_ip'),
        ipmi_netmask=pulumi.get(__ret__, 'ipmi_netmask'),
        ipv6_interface=pulumi.get(__ret__, 'ipv6_interface'),
        latest_hb_ts_lists=pulumi.get(__ret__, 'latest_hb_ts_lists'),
        model=pulumi.get(__ret__, 'model'),
        node_position=pulumi.get(__ret__, 'node_position'),
        node_serial=pulumi.get(__ret__, 'node_serial'),
        node_state=pulumi.get(__ret__, 'node_state'),
        node_type=pulumi.get(__ret__, 'node_type'),
        object_version=pulumi.get(__ret__, 'object_version'))
def get_foundation_central_imaged_node_details_output(imaged_node_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                                                      ipv6_interface: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      object_version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationCentralImagedNodeDetailsResult]:
    """
    Get the details of a single node given its UUID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    nodes_details = nutanix.get_foundation_central_imaged_node_details(imaged_node_uuid="<IMAGED-NODE-UUID>")
    ```


    :param _builtins.str imaged_node_uuid: UUID of the node whose details need to be fetched.
    :param _builtins.str ipv6_interface: Name of the cvm interface having ipv6 address.
    :param _builtins.int object_version: Version of the node used for CAS.
    """
    __args__ = dict()
    __args__['imagedNodeUuid'] = imaged_node_uuid
    __args__['ipv6Interface'] = ipv6_interface
    __args__['objectVersion'] = object_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationCentralImagedNodeDetails:getFoundationCentralImagedNodeDetails', __args__, opts=opts, typ=GetFoundationCentralImagedNodeDetailsResult)
    return __ret__.apply(lambda __response__: GetFoundationCentralImagedNodeDetailsResult(
        aos_version=pulumi.get(__response__, 'aos_version'),
        api_key_uuid=pulumi.get(__response__, 'api_key_uuid'),
        available=pulumi.get(__response__, 'available'),
        block_serial=pulumi.get(__response__, 'block_serial'),
        created_timestamp=pulumi.get(__response__, 'created_timestamp'),
        current_time=pulumi.get(__response__, 'current_time'),
        cvm_gateway=pulumi.get(__response__, 'cvm_gateway'),
        cvm_ip=pulumi.get(__response__, 'cvm_ip'),
        cvm_ipv6=pulumi.get(__response__, 'cvm_ipv6'),
        cvm_netmask=pulumi.get(__response__, 'cvm_netmask'),
        cvm_up=pulumi.get(__response__, 'cvm_up'),
        cvm_uuid=pulumi.get(__response__, 'cvm_uuid'),
        cvm_vlan_id=pulumi.get(__response__, 'cvm_vlan_id'),
        foundation_version=pulumi.get(__response__, 'foundation_version'),
        hardware_attributes=pulumi.get(__response__, 'hardware_attributes'),
        hypervisor_gateway=pulumi.get(__response__, 'hypervisor_gateway'),
        hypervisor_hostname=pulumi.get(__response__, 'hypervisor_hostname'),
        hypervisor_ip=pulumi.get(__response__, 'hypervisor_ip'),
        hypervisor_netmask=pulumi.get(__response__, 'hypervisor_netmask'),
        hypervisor_type=pulumi.get(__response__, 'hypervisor_type'),
        hypervisor_version=pulumi.get(__response__, 'hypervisor_version'),
        id=pulumi.get(__response__, 'id'),
        imaged_cluster_uuid=pulumi.get(__response__, 'imaged_cluster_uuid'),
        imaged_node_uuid=pulumi.get(__response__, 'imaged_node_uuid'),
        ipmi_gateway=pulumi.get(__response__, 'ipmi_gateway'),
        ipmi_ip=pulumi.get(__response__, 'ipmi_ip'),
        ipmi_netmask=pulumi.get(__response__, 'ipmi_netmask'),
        ipv6_interface=pulumi.get(__response__, 'ipv6_interface'),
        latest_hb_ts_lists=pulumi.get(__response__, 'latest_hb_ts_lists'),
        model=pulumi.get(__response__, 'model'),
        node_position=pulumi.get(__response__, 'node_position'),
        node_serial=pulumi.get(__response__, 'node_serial'),
        node_state=pulumi.get(__response__, 'node_state'),
        node_type=pulumi.get(__response__, 'node_type'),
        object_version=pulumi.get(__response__, 'object_version')))
