# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFoundationCentralListApiKeysResult',
    'AwaitableGetFoundationCentralListApiKeysResult',
    'get_foundation_central_list_api_keys',
    'get_foundation_central_list_api_keys_output',
]

@pulumi.output_type
class GetFoundationCentralListApiKeysResult:
    """
    A collection of values returned by getFoundationCentralListApiKeys.
    """
    def __init__(__self__, api_keys=None, id=None, length=None, metadata=None, offset=None):
        if api_keys and not isinstance(api_keys, list):
            raise TypeError("Expected argument 'api_keys' to be a list")
        pulumi.set(__self__, "api_keys", api_keys)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if length and not isinstance(length, int):
            raise TypeError("Expected argument 'length' to be a int")
        pulumi.set(__self__, "length", length)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)

    @_builtins.property
    @pulumi.getter(name="apiKeys")
    def api_keys(self) -> Sequence['outputs.GetFoundationCentralListApiKeysApiKeyResult']:
        return pulumi.get(self, "api_keys")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def length(self) -> Optional[_builtins.int]:
        """
        The number of records retrieved.
        """
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.GetFoundationCentralListApiKeysMetadataResult']:
        """
        List metadata output for all list apis.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        """
        Offset from the start of the object list.
        """
        return pulumi.get(self, "offset")


class AwaitableGetFoundationCentralListApiKeysResult(GetFoundationCentralListApiKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationCentralListApiKeysResult(
            api_keys=self.api_keys,
            id=self.id,
            length=self.length,
            metadata=self.metadata,
            offset=self.offset)


def get_foundation_central_list_api_keys(length: Optional[_builtins.int] = None,
                                         metadata: Optional[Union['GetFoundationCentralListApiKeysMetadataArgs', 'GetFoundationCentralListApiKeysMetadataArgsDict']] = None,
                                         offset: Optional[_builtins.int] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationCentralListApiKeysResult:
    """
    List all the api keys created in Foundation Central.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    api_keys_list = nutanix.get_foundation_central_list_api_keys()
    ```


    :param _builtins.int length: The number of records retrieved.
    :param Union['GetFoundationCentralListApiKeysMetadataArgs', 'GetFoundationCentralListApiKeysMetadataArgsDict'] metadata: List metadata output for all list apis.
    :param _builtins.int offset: Offset from the start of the object list.
    """
    __args__ = dict()
    __args__['length'] = length
    __args__['metadata'] = metadata
    __args__['offset'] = offset
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationCentralListApiKeys:getFoundationCentralListApiKeys', __args__, opts=opts, typ=GetFoundationCentralListApiKeysResult).value

    return AwaitableGetFoundationCentralListApiKeysResult(
        api_keys=pulumi.get(__ret__, 'api_keys'),
        id=pulumi.get(__ret__, 'id'),
        length=pulumi.get(__ret__, 'length'),
        metadata=pulumi.get(__ret__, 'metadata'),
        offset=pulumi.get(__ret__, 'offset'))
def get_foundation_central_list_api_keys_output(length: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                metadata: Optional[pulumi.Input[Optional[Union['GetFoundationCentralListApiKeysMetadataArgs', 'GetFoundationCentralListApiKeysMetadataArgsDict']]]] = None,
                                                offset: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationCentralListApiKeysResult]:
    """
    List all the api keys created in Foundation Central.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    api_keys_list = nutanix.get_foundation_central_list_api_keys()
    ```


    :param _builtins.int length: The number of records retrieved.
    :param Union['GetFoundationCentralListApiKeysMetadataArgs', 'GetFoundationCentralListApiKeysMetadataArgsDict'] metadata: List metadata output for all list apis.
    :param _builtins.int offset: Offset from the start of the object list.
    """
    __args__ = dict()
    __args__['length'] = length
    __args__['metadata'] = metadata
    __args__['offset'] = offset
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationCentralListApiKeys:getFoundationCentralListApiKeys', __args__, opts=opts, typ=GetFoundationCentralListApiKeysResult)
    return __ret__.apply(lambda __response__: GetFoundationCentralListApiKeysResult(
        api_keys=pulumi.get(__response__, 'api_keys'),
        id=pulumi.get(__response__, 'id'),
        length=pulumi.get(__response__, 'length'),
        metadata=pulumi.get(__response__, 'metadata'),
        offset=pulumi.get(__response__, 'offset')))
