# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFoundationDiscoverNodesResult',
    'AwaitableGetFoundationDiscoverNodesResult',
    'get_foundation_discover_nodes',
    'get_foundation_discover_nodes_output',
]

@pulumi.output_type
class GetFoundationDiscoverNodesResult:
    """
    A collection of values returned by getFoundationDiscoverNodes.
    """
    def __init__(__self__, entities=None, id=None):
        if entities and not isinstance(entities, list):
            raise TypeError("Expected argument 'entities' to be a list")
        pulumi.set(__self__, "entities", entities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.GetFoundationDiscoverNodesEntityResult']:
        """
        List of Nutanix-imaged nodes within an IPv6 network
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFoundationDiscoverNodesResult(GetFoundationDiscoverNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationDiscoverNodesResult(
            entities=self.entities,
            id=self.id)


def get_foundation_discover_nodes(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationDiscoverNodesResult:
    """
    Discovers and lists Nutanix-imaged nodes within an IPv6 network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    discovered_nodes = nutanix.get_foundation_discover_nodes()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationDiscoverNodes:getFoundationDiscoverNodes', __args__, opts=opts, typ=GetFoundationDiscoverNodesResult).value

    return AwaitableGetFoundationDiscoverNodesResult(
        entities=pulumi.get(__ret__, 'entities'),
        id=pulumi.get(__ret__, 'id'))
def get_foundation_discover_nodes_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationDiscoverNodesResult]:
    """
    Discovers and lists Nutanix-imaged nodes within an IPv6 network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    discovered_nodes = nutanix.get_foundation_discover_nodes()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationDiscoverNodes:getFoundationDiscoverNodes', __args__, opts=opts, typ=GetFoundationDiscoverNodesResult)
    return __ret__.apply(lambda __response__: GetFoundationDiscoverNodesResult(
        entities=pulumi.get(__response__, 'entities'),
        id=pulumi.get(__response__, 'id')))
